/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.util;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PlatformUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static int javaMajor_;
    private static int osMajor_;
    private static int osMinor_;
    private static boolean isMac_;
    private static boolean isMacEAWT_;
    private static boolean isMacDarkMode_;
    private static boolean isWindows_;
    private static boolean jfxChecked_;
    private static boolean jfxEnabled_;

    public static boolean isMacintosh() {
        return isMac_;
    }

    public static boolean isOldMacintoshAPI() {
        return isMacEAWT_;
    }

    public static boolean isMacintoshDarkMode() {
        return isMacDarkMode_;
    }

    public static boolean isWindows() {
        return isWindows_;
    }

    public static boolean isLinuxEtc() {
        return !isMac_ && !isWindows_;
    }

    public static synchronized boolean isJfxEnabled() {
        if (jfxChecked_) {
            return jfxEnabled_;
        }
        try {
            LOGGER.debug("Trying to initializing JavaFX.");
            Class.forName("javafx.embed.swing.JFXPanel");
            Class<?> platformClass = Class.forName("javafx.application.Platform");
            Method invMethod = platformClass.getDeclaredMethod("runLater", Runnable.class);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                }
            };
            invMethod.invoke(null, r);
            LOGGER.debug("Succeeded.");
            jfxEnabled_ = true;
        }
        catch (Exception exc) {
            LOGGER.debug("Failed. JavaFX probably not available.");
            jfxEnabled_ = false;
        }
        jfxChecked_ = true;
        return jfxEnabled_;
    }

    public static int getOSMajor() {
        return osMajor_;
    }

    public static int getOSMinor() {
        return osMinor_;
    }

    public static int getJavaMajor() {
        return javaMajor_;
    }

    public static boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    public static void logSystemProperties() {
        Properties props = System.getProperties();
        Set<String> pkeyset = props.stringPropertyNames();
        ArrayList<String> pkeylist = new ArrayList<String>();
        pkeylist.addAll(pkeyset);
        Collections.sort(pkeylist);
        for (String pkey : pkeylist) {
            LOGGER.info("pkey {}, value {}", (Object)pkey, (Object)System.getProperty(pkey));
        }
    }

    public static void logUIProperties() {
        if (PlatformUtils.isHeadless()) {
            LOGGER.info("Running headless.");
            return;
        }
        try {
            UIDefaults defs = UIManager.getDefaults();
            Set uikeyset = defs.keySet();
            LOGGER.info("UI key count {}", (Object)uikeyset.size());
            ArrayList<String> uikeylist = new ArrayList<String>();
            for (Object oo : uikeyset) {
                uikeylist.add(oo.toString());
            }
            Collections.sort(uikeylist);
            for (String uikey : uikeylist) {
                LOGGER.info("uikey {}, value {}", (Object)uikey, defs.get(uikey));
            }
        }
        catch (Exception exc) {
            LOGGER.info("{}", (Object)exc.toString());
        }
    }

    public static void logGraphicsDevices() {
        if (PlatformUtils.isHeadless()) {
            LOGGER.info("Current environment is headless.");
            return;
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] devices = ge.getScreenDevices();
        LOGGER.info("Discovered {} graphics devices", (Object)devices.length);
        int count = 0;
        for (GraphicsDevice device : devices) {
            GraphicsConfiguration gc = device.getDefaultConfiguration();
            int dtype = device.getType();
            LOGGER.info("Device              {}", (Object)(++count));
            LOGGER.info("- Is default device {}", (Object)device.equals(ge.getDefaultScreenDevice()));
            LOGGER.info("- Device type       {}", (Object)dtype);
            LOGGER.info("- Type is raster    {}", (Object)(dtype == 0 ? 1 : 0));
            LOGGER.info("- Config bounds     {}", (Object)gc.getBounds());
            LOGGER.info("- Config insets     {}", (Object)tk.getScreenInsets(gc));
        }
    }

    private PlatformUtils() {
    }

    static {
        String jVersion = null;
        try {
            javaMajor_ = -1;
            jVersion = System.getProperty("java.version");
            if (jVersion.startsWith("1.")) {
                jVersion = jVersion.substring(2);
            }
            jVersion = jVersion.replaceFirst("\\D*", "");
            jVersion = jVersion.replaceFirst("\\..*", "");
            javaMajor_ = Integer.valueOf(jVersion);
        }
        catch (Exception ignore) {
            LOGGER.warn("Unable to parse Java version, {}.", (Object)jVersion);
        }
        LOGGER.trace("Java major {}", (Object)javaMajor_);
        try {
            String osName = System.getProperty("os.name");
            isMac_ = osName.contains("Mac");
            isWindows_ = osName.contains("Windows");
        }
        catch (Exception ignore) {
            LOGGER.warn("No OS name in system properties?");
        }
        String osVersion = System.getProperty("os.version");
        try {
            osMajor_ = -1;
            osMinor_ = -1;
            String[] tokens = osVersion.split("\\.");
            osMajor_ = tokens.length > 0 ? Integer.valueOf(tokens[0]) : 0;
            osMinor_ = tokens.length > 1 ? Integer.valueOf(tokens[1]) : 0;
        }
        catch (Exception exc) {
            LOGGER.warn("Unable to parse OS version to int(s), {}.", (Object)osVersion);
        }
        try {
            if (isMac_ && (osMajor_ > 10 || osMinor_ >= 14)) {
                String dmStr = System.getProperty("macos.DarkMode");
                if (dmStr == null) {
                    dmStr = System.getProperty("DarkMode");
                }
                isMacDarkMode_ = dmStr != null && dmStr.equalsIgnoreCase("true");
            }
        }
        catch (Exception exc) {
            LOGGER.warn("Unable to parse DarkMode property");
        }
        if (isMac_ && javaMajor_ == 8) {
            try {
                Class.forName("com.apple.eawt.Application");
                isMacEAWT_ = true;
                LOGGER.trace("Found eawt.Application; setting isMacEAWT true");
            }
            catch (Exception exc) {
                LOGGER.warn("Exception checking for Apple Java API: {}", (Object)exc.toString());
            }
        }
    }
}

