/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.windoid;

import gov.nasa.giss.ui.menu.GissMenuBar;
import gov.nasa.giss.ui.windoid.Windoid;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class WindoidKeyEventDispatcher
implements KeyEventDispatcher {
    private JFrame pframe_;
    private Windoid windoid_;

    public WindoidKeyEventDispatcher(JFrame pframe, Windoid windoid) {
        this.pframe_ = pframe;
        this.windoid_ = windoid;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        JMenuBar jmb;
        if (!this.pframe_.isVisible()) {
            return false;
        }
        int iid = e.getID();
        if (iid != 401) {
            return false;
        }
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component kfo = kfm.getPermanentFocusOwner();
        if (kfo == null) {
            kfo = kfm.getFocusOwner();
        }
        if (kfo == null) {
            return false;
        }
        if (kfo instanceof Windoid) {
            if (kfo != this.windoid_) {
                return false;
            }
        } else if (kfo instanceof JComponent) {
            Container tla = ((JComponent)kfo).getTopLevelAncestor();
            if (tla != this.windoid_) {
                return false;
            }
        } else {
            return false;
        }
        if (!((jmb = this.pframe_.getJMenuBar()) instanceof GissMenuBar)) {
            return false;
        }
        KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
        JMenuItem jmi = ((GissMenuBar)jmb).getItemByKeyStroke(ks);
        if (jmi == null) {
            return false;
        }
        Action a = jmi.getAction();
        if (a == null) {
            return false;
        }
        EventQueue.invokeLater(() -> a.actionPerformed(null));
        return true;
    }
}

