/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.windoid;

import gov.nasa.giss.ui.windoid.WindoidHeader;
import java.awt.Container;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.event.MouseInputAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindoidHeaderMouseAdapter
extends MouseInputAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected WindoidHeader header_;
    private boolean dragInProgress_;
    private Point windowPoint_;
    private Point mousePoint_;

    public WindoidHeaderMouseAdapter(WindoidHeader header) {
        LOGGER.trace("");
        this.header_ = header;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        LOGGER.trace("{}", (Object)this.header_.isCloseable());
        if (this.header_.isCloseable()) {
            if (this.header_.inCloseButton(e.getPoint())) {
                LOGGER.trace("close button");
                ((Window)this.header_.getTopLevelAncestor()).setVisible(false);
            }
        } else if (e.getClickCount() == 2) {
            LOGGER.trace("double click");
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.moveWindow(e.getPoint());
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (!this.dragInProgress_) {
            this.header_.setCloseHighlighted(this.header_.isCloseable());
            this.header_.setResizeHighlighted(this.header_.isResizeable());
            this.header_.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.dragInProgress_) {
            this.header_.setCloseHighlighted(false);
            this.header_.setResizeHighlighted(false);
            this.header_.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.dragInProgress_ = true;
        Container parent = this.header_.getTopLevelAncestor();
        if (parent != null) {
            this.windowPoint_ = parent.getLocation();
            this.mousePoint_ = e.getPoint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.moveWindow(e.getPoint());
        this.dragInProgress_ = false;
    }

    private void moveWindow(Point p) {
        if (!this.dragInProgress_) {
            return;
        }
        int dx = p.x - this.mousePoint_.x;
        int dy = p.y - this.mousePoint_.y;
        this.windowPoint_.translate(dx, dy);
        Container parent = this.header_.getTopLevelAncestor();
        parent.setLocation(this.windowPoint_);
    }
}

