/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.windoid;

import gov.nasa.giss.ui.windoid.WindoidHeaderMouseAdapter;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.lang.invoke.MethodHandles;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindoidHeader
extends JComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int HDR_HEIGHT = 18;
    private static final int BTN_SIZE = 8;
    private static final int BTN_GAP = 4;
    private static final int LEFT_MARGIN = 8;
    private static final int TOP_MARGIN = 5;
    private static final Color CLOSE_COLOR = new Color(247, 70, 69);
    private static final Color HIDE_COLOR = new Color(251, 175, 21);
    private static final Color RESIZE_COLOR = new Color(57, 198, 41);
    private static final Color LIGHT_BKGD_TOP = new Color(193, 194, 194);
    private static final Color LIGHT_BKGD_BOTTOM = new Color(165, 166, 166);
    private static final Color LIGHT_TEXT_COLOR = new Color(51, 51, 51);
    private static final Color LIGHT_INACTIVE_COLOR = new Color(199, 199, 199);
    private static final Color LIGHT_BORDER_COLOR = new Color(124, 125, 125);
    private static final Color DARK_BKGD_TOP = new Color(61, 62, 62);
    private static final Color DARK_BKGD_BOTTOM = new Color(51, 51, 51);
    private static final Color DARK_TEXT_COLOR = new Color(255, 255, 255);
    private static final Color DARK_INACTIVE_COLOR = new Color(76, 75, 72);
    private static final Color DARK_BORDER_COLOR = new Color(34, 33, 30);
    private static final Stroke BORDER_STROKE = new BasicStroke(75.0f, 2, 0);
    private String title_;
    private int titleWidth_;
    private int lineHeight_;
    private int lineAscent_;
    private boolean measured_;
    private int closeLeft_ = -1000;
    private int hideLeft_ = -1000;
    private int resizeLeft_ = -1000;
    private int titleLeft_ = -1000;
    private boolean closeable_;
    private boolean hideable_;
    private boolean resizeable_;
    private boolean closeHighlighted_;
    private boolean hideHighlighted_;
    private boolean resizeHighlighted_;
    private boolean resizeVisible_;
    private int minWidth_;

    public WindoidHeader(String title, boolean closeable) {
        this.title_ = title;
        this.setCloseable(closeable);
        this.closeLeft_ = 8;
        this.hideLeft_ = this.closeLeft_ + 8 + 4;
        this.resizeLeft_ = this.hideLeft_ + 8 + 4;
        this.titleLeft_ = this.resizeLeft_ + 8 + 8;
        if (PlatformUtils.isMacintosh()) {
            this.minWidth_ = 48;
            this.resizeVisible_ = true;
        } else {
            this.minWidth_ = 36;
            this.resizeVisible_ = false;
        }
        this.setBorder(null);
        this.setLayout(null);
        Font f = UIManager.getDefaults().getFont("Label.font");
        if (f != null) {
            f = f.deriveFont(10.75f);
            this.setFont(f);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.measured_) {
            this.measure();
        }
        if (this.titleWidth_ > 0) {
            int tw = Math.max(50, this.titleWidth_) + 8;
            return new Dimension(this.minWidth_ + tw, 18);
        }
        return new Dimension(this.minWidth_, 18);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension d = new Dimension(this.getPreferredSize());
        d.width = 4000;
        return d;
    }

    public void addStandardMouseAdapter() {
        this.addMouseAdapter(new WindoidHeaderMouseAdapter(this));
    }

    public void addMouseAdapter(WindoidHeaderMouseAdapter whma) {
        this.addMouseListener(whma);
        this.addMouseMotionListener(whma);
    }

    public boolean isCloseable() {
        return this.closeable_;
    }

    public void setCloseable(boolean closeable) {
        this.closeable_ = closeable;
    }

    public void setCloseHighlighted(boolean highlighted) {
        this.closeHighlighted_ = highlighted;
    }

    public boolean isResizeable() {
        return this.resizeable_;
    }

    public void setResizeable(boolean resizeable) {
        this.resizeable_ = resizeable;
    }

    public void setResizeHighlighted(boolean highlighted) {
        this.resizeHighlighted_ = highlighted;
    }

    @Override
    public void paintComponent(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        Graphics2D g2d = (Graphics2D)g.create();
        boolean t = false;
        int b = 18;
        GradientPaint paint = new GradientPaint(0.0f, 0.0f, DARK_BKGD_TOP, 0.0f, 18.0f, DARK_BKGD_BOTTOM);
        g2d.setPaint(paint);
        g2d.fillRect(0, 0, w, 18);
        g2d.setColor(DARK_BORDER_COLOR);
        g2d.setStroke(BORDER_STROKE);
        Line2D.Double line = new Line2D.Double(0.0, 17.5, w, 17.5);
        g2d.draw(line);
        if (this.closeHighlighted_) {
            this.drawButton(g2d, this.closeLeft_, CLOSE_COLOR);
            LOGGER.trace("closeHighlighted");
        } else if (this.closeable_) {
            this.drawButton(g2d, this.closeLeft_, CLOSE_COLOR);
        } else {
            this.drawButton(g2d, this.closeLeft_, DARK_INACTIVE_COLOR);
        }
        if (this.hideHighlighted_) {
            this.drawButton(g2d, this.hideLeft_, HIDE_COLOR);
            LOGGER.trace("hideHighlighted");
        } else if (this.hideable_) {
            this.drawButton(g2d, this.hideLeft_, HIDE_COLOR);
        } else {
            this.drawButton(g2d, this.hideLeft_, DARK_INACTIVE_COLOR);
        }
        if (this.resizeVisible_) {
            if (this.resizeHighlighted_) {
                this.drawButton(g2d, this.resizeLeft_, RESIZE_COLOR);
                LOGGER.trace("resizeHighlighted");
            } else if (this.resizeable_) {
                this.drawButton(g2d, this.resizeLeft_, RESIZE_COLOR);
            } else {
                this.drawButton(g2d, this.resizeLeft_, DARK_INACTIVE_COLOR);
            }
        }
        if (this.titleWidth_ > 0) {
            g2d.setColor(DARK_TEXT_COLOR);
            int x = this.titleLeft_;
            int y = (18 - this.lineHeight_) / 2 + this.lineAscent_;
            g2d.drawString(this.title_, x, y);
        }
        g2d.dispose();
    }

    private void measure() {
        if (this.title_ == null || this.title_.length() == 0) {
            this.titleWidth_ = 0;
        } else {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            this.lineHeight_ = fm.getHeight();
            this.lineAscent_ = fm.getAscent();
            this.titleWidth_ = fm.stringWidth(this.title_);
        }
        this.measured_ = true;
    }

    public boolean inCloseButton(Point p) {
        if (!this.closeable_) {
            return false;
        }
        return p.x >= this.closeLeft_ && p.x < this.closeLeft_ + 8;
    }

    public boolean inHideButton(Point p) {
        if (!this.hideable_) {
            return false;
        }
        return p.x >= this.hideLeft_ && p.x < this.hideLeft_ + 8;
    }

    public boolean inResizeButton(Point p) {
        if (!this.resizeVisible_ || !this.resizeable_) {
            return false;
        }
        return p.x >= this.resizeLeft_ && p.x < this.resizeLeft_ + 8;
    }

    private void drawButton(Graphics2D g2d, int left, Color c) {
        Ellipse2D.Float button = new Ellipse2D.Float(left, 5.0f, 8.0f, 8.0f);
        g2d.setColor(c);
        g2d.fill(button);
    }
}

