/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.treetable;

import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TreeTableModel
extends AbstractTableModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ArrayList<NodeInfo> nodeList_ = new ArrayList(200);
    private TreeTableNode root_;
    private NodeInfo rootInfo_;
    private boolean rootVisible_;

    public TreeTableModel(TreeTableNode root) {
        this.setRoot(root);
    }

    public abstract int getColumnAlignment(int var1);

    public abstract Object getValueAt(TreeTableNode var1, int var2);

    @Override
    public void setValueAt(Object value, int row, int col) {
        TreeTableNode node = this.getNodeForRow(row);
        if (node == null) {
            return;
        }
        this.setValueAt(value, node, col);
    }

    public abstract void setValueAt(Object var1, TreeTableNode var2, int var3);

    @Override
    public int getRowCount() {
        return this.nodeList_.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        TreeTableNode node = this.getNodeForRow(row);
        if (node == null) {
            return false;
        }
        return this.getValueAt(node, col);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        TreeTableNode node = this.getNodeForRow(row);
        if (node == null) {
            return false;
        }
        return this.isCellEditable(node, col);
    }

    public boolean isCellEditable(TreeTableNode node, int col) {
        if (node == null) {
            return false;
        }
        return this.getColumnClass(col) == TreeTableModel.class;
    }

    public boolean isRoot(TreeTableNode node) {
        return node == this.root_;
    }

    public TreeTableNode getRoot() {
        return this.root_;
    }

    public void setRoot(TreeTableNode node) {
        if (node == this.root_) {
            return;
        }
        this.nodeList_.clear();
        this.root_ = node;
        if (node != null) {
            TreeTableNode[] startingNodes;
            this.rootInfo_ = new NodeInfo(node);
            this.rootInfo_.setExpanded(true);
            if (this.rootVisible_) {
                this.nodeList_.add(this.rootInfo_);
            }
            for (TreeTableNode cnode : startingNodes = this.root_.getChildren()) {
                this.nodeList_.add(new NodeInfo(cnode));
            }
        } else {
            this.rootInfo_ = null;
        }
        this.fireTableDataChanged();
    }

    public boolean isRootVisible() {
        return this.rootVisible_;
    }

    public void setRootVisible(boolean visible) {
        if (visible == this.rootVisible_) {
            return;
        }
        this.rootVisible_ = visible;
        if (this.rootInfo_ == null) {
            return;
        }
        if (visible) {
            this.nodeList_.add(0, this.rootInfo_);
            this.fireTableRowsInserted(0, 0);
        } else {
            this.nodeList_.remove(0);
            this.fireTableRowsDeleted(0, 0);
        }
    }

    public int getRowForNode(TreeTableNode node) {
        if (node == null) {
            return -1;
        }
        int isize = this.getRowCount();
        for (int i = 0; i < isize; ++i) {
            NodeInfo info = this.nodeList_.get(i);
            TreeTableNode vnode = info.getNode();
            if (vnode != node) continue;
            return i;
        }
        return -1;
    }

    public TreeTableNode getNodeForRow(int row) {
        if (row < 0) {
            return null;
        }
        NodeInfo info = this.nodeList_.get(row);
        if (info == null) {
            return null;
        }
        return info.getNode();
    }

    public TreeTableNode[] getPathForRow(int row) {
        TreeTableNode node = this.getNodeForRow(row);
        if (node == null) {
            return null;
        }
        return node.getPath();
    }

    public int getRowForPath(TreeTableNode[] path) {
        int isize = this.getRowCount();
        for (int i = 0; i < isize; ++i) {
            NodeInfo info = this.nodeList_.get(i);
            TreeTableNode node = info.getNode();
            TreeTableNode[] xpath = node.getPath();
            if (xpath.length != path.length) continue;
            boolean matched = true;
            for (int j = 0; j < path.length; ++j) {
                if (xpath[j] == path[j]) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            return i;
        }
        return -1;
    }

    public boolean isExpanded(TreeTableNode[] path) {
        int row = this.getRowForPath(path);
        if (row == -1) {
            return false;
        }
        return this.isExpanded(row);
    }

    public boolean isExpanded(TreeTableNode node) {
        int row = this.getRowForNode(node);
        if (row == -1) {
            return false;
        }
        return this.isExpanded(row);
    }

    public boolean isExpanded(int row) {
        return this.nodeList_.get(row).isExpanded();
    }

    public void toggleNode(TreeTableNode node) {
        int row = this.getRowForNode(node);
        if (row < 0) {
            return;
        }
        NodeInfo info = this.nodeList_.get(row);
        if (info.isExpanded()) {
            this.collapseNodeAtRow(row);
        } else {
            this.expandNodeAtRow(row);
        }
    }

    public void expandNode(TreeTableNode node) {
        LOGGER.trace("node {}", (Object)node);
        int row = this.getRowForNode(node);
        this.expandNodeAtRow(row);
    }

    public void collapseNode(TreeTableNode node) {
        int row = this.getRowForNode(node);
        this.collapseNodeAtRow(row);
    }

    public synchronized void expandNodeAtRow(int row) {
        LOGGER.trace("row {}", (Object)row);
        if (row < 0 || row >= this.getRowCount()) {
            return;
        }
        NodeInfo info = this.nodeList_.get(row);
        if (info == null) {
            return;
        }
        if (!info.isExpandable()) {
            return;
        }
        if (info.isExpanded()) {
            return;
        }
        TreeTableNode node = info.getNode();
        TreeTableNode[] children = node.getChildren();
        LOGGER.trace("children {}", (Object)children.length);
        for (int i = children.length - 1; i >= 0; --i) {
            NodeInfo childInfo = new NodeInfo(children[i]);
            this.nodeList_.add(row + 1, childInfo);
        }
        info.setExpanded(true);
        this.fireTableRowsInserted(row + 1, row + children.length);
    }

    public void collapseNodeAtRow(int row) {
        int rowP;
        if (row < 0 || row >= this.getRowCount()) {
            return;
        }
        NodeInfo info = this.nodeList_.get(row);
        if (info == null) {
            return;
        }
        if (!info.isExpandable()) {
            return;
        }
        if (!info.isExpanded()) {
            return;
        }
        TreeTableNode node = info.getNode();
        TreeTableNode parent = node.getParent();
        int depth = this.getPathForRow(row).length;
        int isize = this.getRowCount();
        int nextToKeep = -1;
        for (int i = row + 1; i < isize; ++i) {
            NodeInfo xinfo = null;
            try {
                xinfo = this.nodeList_.get(i);
            }
            catch (Exception exc) {
                nextToKeep = i;
                break;
            }
            if (xinfo == null) break;
            TreeTableNode xnode = xinfo.getNode();
            TreeTableNode xparent = xnode.getParent();
            if (xparent == node) {
                if (!xnode.getAllowsChildren() || !xinfo.isExpanded()) continue;
                this.collapseNodeAtRow(i);
                continue;
            }
            if (xparent == parent) {
                nextToKeep = i;
                break;
            }
            int xdepth = this.getPathForRow(i).length;
            if (xdepth < depth) {
                nextToKeep = i;
                break;
            }
            throw new RuntimeException("ERROR: Hit node which is not sibling or child at row " + i);
        }
        if (nextToKeep == -1) {
            nextToKeep = isize;
        }
        for (int i = rowP = row + 1; i < nextToKeep; ++i) {
            this.nodeList_.remove(rowP);
        }
        info.setExpanded(false);
        this.fireTableRowsDeleted(rowP, nextToKeep - 1);
    }

    public void nodeInserted(TreeTableNode parent, int atIndex, TreeTableNode child) {
        boolean expanded;
        if (parent == null) {
            return;
        }
        if (parent == this.root_ && !this.isRootVisible()) {
            expanded = true;
        } else {
            int row = this.getRowForNode(parent);
            if (row < 0) {
                return;
            }
            expanded = this.isExpanded(row);
        }
        if (!expanded) {
            return;
        }
        TreeTableNode[] children = this.getVisibleChildren(parent);
        NodeInfo nodeInfo = new NodeInfo(child);
        if (atIndex < children.length) {
            int nrow = this.getRowForNode(children[atIndex]);
            this.nodeList_.add(nrow, nodeInfo);
            this.fireTableRowsInserted(nrow, nrow);
            return;
        }
        if (parent == this.root_) {
            this.nodeList_.add(nodeInfo);
            this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
            return;
        }
        TreeTableNode[] ppath = parent.getPath();
        for (int ii = ppath.length - 1; ii > 0; --ii) {
            TreeTableNode pnode = ppath[ii];
            TreeTableNode pparent = ppath[ii - 1];
            TreeTableNode[] psibs = pparent.getChildren();
            int ppos = -1;
            for (int i = 0; i < psibs.length; ++i) {
                if (!psibs[i].equals(pnode)) continue;
                ppos = i;
                break;
            }
            if (ppos == -1) {
                return;
            }
            if (ppos >= psibs.length - 1) continue;
            TreeTableNode before = psibs[ppos + 1];
            int nrow = this.getRowForNode(before);
            this.nodeList_.add(nrow, nodeInfo);
            this.fireTableRowsInserted(nrow, nrow);
            return;
        }
        this.nodeList_.add(nodeInfo);
        this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
    }

    public void nodeRemoved(TreeTableNode parent, int atIndex, TreeTableNode node) {
        int row = this.getRowForNode(node);
        if (row < 0) {
            return;
        }
        this.collapseNodeAtRow(row);
        this.nodeList_.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    public void nodeStructureChanged(TreeTableNode node) {
        if (node == null) {
            return;
        }
        if (!this.isExpanded(node)) {
            return;
        }
        TreeTableNode[] oldKids = this.getVisibleChildren(node);
        TreeTableNode[] newKids = node.getChildren();
        for (int i = oldKids.length - 1; i >= 0; --i) {
            boolean removed = true;
            for (int j = 0; j < newKids.length; ++j) {
                if (!oldKids[i].equals(newKids[j])) continue;
                removed = false;
                break;
            }
            if (!removed) continue;
            this.nodeRemoved(node, i, oldKids[i]);
            oldKids[i] = null;
        }
        for (int j = 0; j < newKids.length; ++j) {
            boolean isNew = true;
            for (int i = 0; i < oldKids.length; ++i) {
                if (oldKids[i] == null || !oldKids[i].equals(newKids[j])) continue;
                isNew = false;
                break;
            }
            if (!isNew) continue;
            this.nodeInserted(node, j, newKids[j]);
        }
        this.fireTableDataChanged();
    }

    private TreeTableNode[] getVisibleChildren(TreeTableNode node) {
        NodeInfo cinfo;
        TreeTableNode cnode;
        TreeTableNode[] cpath;
        int row;
        if (node == this.root_ && !this.isRootVisible()) {
            row = -1;
        } else {
            row = this.getRowForNode(node);
            if (row < 0) {
                return null;
            }
        }
        TreeTableNode[] path = node.getPath();
        int isize = this.getRowCount();
        ArrayList<TreeTableNode> tempList = new ArrayList<TreeTableNode>(isize);
        for (int i = row + 1; i < isize && (cpath = (cnode = (cinfo = this.nodeList_.get(i)).getNode()).getPath()).length > path.length; ++i) {
            if (cpath.length != path.length + 1) continue;
            tempList.add(cnode);
        }
        TreeTableNode[] result = tempList.toArray(new TreeTableNode[0]);
        return result;
    }

    private class NodeInfo {
        private TreeTableNode node_;
        private boolean expanded_;

        NodeInfo(TreeTableNode node) {
            this.node_ = node;
        }

        TreeTableNode getNode() {
            return this.node_;
        }

        TreeTableNode getParent() {
            return this.node_.getParent();
        }

        boolean isExpandable() {
            return this.node_.getAllowsChildren();
        }

        boolean isExpanded() {
            return this.expanded_;
        }

        void setExpanded(boolean expanded) {
            if (!this.isExpandable()) {
                throw new RuntimeException("Cannot mark a leaf node as expanded.");
            }
            this.expanded_ = expanded;
        }
    }
}

