/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.table;

import gov.nasa.giss.ui.table.GissTable;
import gov.nasa.giss.ui.table.TableTheme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;

public class GissTableCellBorder
extends AbstractBorder {
    private GissTable table_;
    private int row_;
    private boolean selected_;

    public GissTableCellBorder(GissTable table, int row, int col, boolean selected, boolean focused) {
        this.table_ = table;
        this.row_ = row;
        this.selected_ = selected;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int w = width;
        int h = this.table_.getRowHeight();
        Color gc = this.table_.getGridColor();
        if (!this.selected_) {
            g.setColor(gc);
            if (this.table_.getShowHorizontalLines()) {
                g.drawLine(x, y + h, x + w, y + h);
            }
            if (this.table_.getShowVerticalLines()) {
                g.drawLine(x + w - 1, y, x + w - 1, y + h);
            }
            return;
        }
        TableTheme theme = this.table_.getTheme();
        Color hc = theme == null ? UIManager.getColor("Table.background") : theme.getBackground(this.row_);
        g.setColor(hc);
        g.drawLine(x, y + h, x + w, y + h);
        if (this.table_.getShowVerticalLines()) {
            int rr = gc.getRed();
            int gg = gc.getGreen();
            int bb = gc.getBlue();
            g.setColor(new Color(rr, gg, bb, 128));
            g.drawLine(x + w - 1, y, x + w - 1, y + h);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        Insets result = new Insets(0, 0, 0, 0);
        return this.getBorderInsets(c, result);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        if (!(c instanceof JButton)) {
            insets.right = 3;
            insets.left = 3;
            insets.bottom = 1;
            insets.top = 1;
        }
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

