/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.table;

import gov.nasa.giss.graphics.AbstractColorTable;
import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.graphics.clut.SimpleColorTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class ColorTableCellRenderer
extends JComponent
implements TableCellRenderer {
    private static final int SAMPLE_WIDTH = 96;
    private static AbstractColorTable badTable_;
    private AbstractColorTable ctable_;

    public ColorTableCellRenderer() {
        this.setOpaque(false);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(104, 4);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(112, 12);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = GraphicUtils.createAntialiasedGfx(g);
        Dimension size = this.getSize();
        Color fgcolor = this.getForeground();
        Color bgcolor = this.getBackground();
        g2d.setColor(bgcolor);
        g2d.fillRect(0, 0, size.width, size.height);
        if (this.ctable_ != null) {
            int colorCount = this.ctable_.getColorCount();
            float binWidth = 96.0f / (float)colorCount;
            int barHeight = this.getFont().getSize() - 2;
            int barTop = (size.height - barHeight) / 2;
            int barLeft = (size.width - 96) / 2;
            g2d.setColor(fgcolor);
            g2d.fillRect(barLeft - 1, barTop - 1, 98, barHeight + 2);
            for (int i = 0; i < colorCount; ++i) {
                Color c2;
                float binOffset = binWidth * (float)i;
                float binLeft = (float)barLeft + binOffset;
                Color c1 = this.ctable_.getColorAt(i);
                int cbins = 1;
                for (int j = i + 1; j < colorCount && (c2 = this.ctable_.getColorAt(j)).equals(c1); ++j) {
                    ++cbins;
                }
                float colorWidth = binWidth * (float)cbins;
                i += cbins - 1;
                if (binOffset + (colorWidth += 0.5f) > 96.0f) {
                    colorWidth = 96.0f - binOffset;
                }
                if (this.isEnabled()) {
                    g2d.setColor(c1);
                } else {
                    g2d.setColor(new Color((c1.getRed() + 9 * bgcolor.getRed()) / 10, (c1.getGreen() + 9 * bgcolor.getGreen()) / 10, (c1.getBlue() + 9 * bgcolor.getBlue()) / 10));
                }
                GraphicUtils.fillRect(g2d, binLeft, barTop, colorWidth, barHeight);
            }
        }
        g2d.dispose();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Object vval = value;
        if (vval == null) {
            if (badTable_ == null) {
                badTable_ = new SimpleColorTable();
            }
            vval = badTable_;
        }
        if (!(value instanceof AbstractColorTable)) {
            throw new IllegalArgumentException("Passed value is not a color table");
        }
        this.ctable_ = (AbstractColorTable)vval;
        return this;
    }
}

