/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.tabbedpane;

import gov.nasa.giss.graphics.GraphicUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HudTabbedPane
extends JComponent {
    private static final Color TEXT_COLOR = Color.WHITE;
    private static final Color TEXT_SHADOW_COLOR = Color.BLACK;
    private static final Color BAR_BACKGROUND_1 = new Color(0, 0, 0, 175);
    private static final Color BAR_BACKGROUND_2 = new Color(0, 0, 0, 195);
    private static final Color BAR_BACKGROUND_3 = new Color(0, 0, 0, 208);
    private static final Color BAR_TOP_1 = new Color(0, 0, 0, 180);
    private static final Color BAR_TOP_2 = new Color(0, 0, 0, 65);
    private static final Color BAR_TOP_3 = new Color(0, 0, 0, 15);
    private static final Color BAR_BOTTOM_1 = new Color(255, 255, 255, 9);
    private static final Color BAR_BOTTOM_2 = new Color(255, 255, 255, 24);
    private static final Color BAR_BOTTOM_3 = new Color(0, 0, 0, 115);
    private static final Color SELECTED_BACKGROUND_1 = new Color(28, 28, 28);
    private static final Color SELECTED_BACKGROUND_2 = new Color(40, 40, 40);
    private static final Color SELECTED_TOP_BORDER = new Color(5, 5, 5);
    private static final Color SELECTED_BOTTOM_BORDER = new Color(48, 48, 48);
    private static final Color SELECTED_SIDE_BORDER_1 = new Color(0, 0, 0, 68);
    private static final Color SELECTED_SIDE_BORDER_2 = new Color(0, 0, 0, 34);
    private static final Color SELECTED_SIDE_BORDER_3 = new Color(0, 0, 0, 0);
    private static final Color LEFT_BORDER = new Color(255, 255, 255, 21);
    private static final Color RIGHT_BORDER = new Color(0, 0, 0, 125);
    private static final int TAB_BAR_HEIGHT = 25;
    private final Object lock_ = new Object();
    private DefaultSingleSelectionModel model_;
    private ArrayList<TabPage> tabPages_;
    private TabPlacement tabPlacement_;
    private Border innerBorder_;
    private Font buttonFont_;
    private int buttonPressed_ = -1;
    private boolean tooManyTabs_;
    private int firstVisibleTab_ = -1;
    private int lastVisibleTab_ = -1;
    private boolean leftButtonEnabled_;
    private boolean rightButtonEnabled_;
    private Rectangle leftButtonRect_;
    private Rectangle rightButtonRect_;

    public HudTabbedPane() {
        this(TabPlacement.TOP);
    }

    private HudTabbedPane(TabPlacement placement) {
        this.tabPlacement_ = placement;
        this.model_ = new DefaultSingleSelectionModel();
        this.model_.addChangeListener(new ModelListener());
        this.tabPages_ = new ArrayList(20);
        this.setInnerBorder(null);
        this.addMouseListener(new TabButtonMouseListener());
        this.buttonFont_ = UIManager.getDefaults().getFont("Label.font").deriveFont(1, 10.0f);
    }

    @Override
    public Font getFont() {
        return this.buttonFont_;
    }

    @Override
    public void setFont(Font f) {
        this.buttonFont_ = f;
    }

    public int getTabCount() {
        return this.tabPages_.size();
    }

    @Override
    public Component add(Component c) {
        return this.addTab(c.getName(), c);
    }

    public Component addTab(String title, Component c) {
        return this.addTab(title, c, this.tabPages_.size());
    }

    public Component addTab(String title, Component c, int index) {
        Objects.requireNonNull(title, "Title cannot be null.");
        Objects.requireNonNull(c, "Component cannot be null.");
        this.tabPages_.add(index, new TabPage(title, c));
        super.add(c);
        if (this.tabPages_.size() == 1) {
            this.setSelectedIndex(0);
        }
        return c;
    }

    public void insertTab(String title, Icon icon, Component c, String tip, int index) {
        Component oldc;
        Objects.requireNonNull(title, "Title cannot be null.");
        Objects.requireNonNull(c, "Component cannot be null.");
        if (index < 0 || index > this.tabPages_.size()) {
            throw new IndexOutOfBoundsException("Tab index out of range");
        }
        int oldNum = this.indexOfTab(title);
        if (oldNum >= 0 && (oldc = this.tabPages_.get(oldNum).getComponent()) == c) {
            this.removeTabAt(oldNum);
        }
        this.tabPages_.add(index, new TabPage(title, c));
        super.add(c);
    }

    public int getSelectedIndex() {
        return this.model_.getSelectedIndex();
    }

    public void setSelectedIndex(int index) {
        if (index == -1) {
            index = 0;
        }
        this.verifyIndex(index);
        this.model_.setSelectedIndex(index);
        this.doLayout();
        this.repaint();
    }

    public Component getSelectedComponent() {
        int index = this.getSelectedIndex();
        try {
            return index != -1 ? this.getComponentAt(index) : null;
        }
        catch (Exception exc) {
            return null;
        }
    }

    public void setSelectedComponent(Component c) {
        if (c == null) {
            return;
        }
        int isize = this.tabPages_.size();
        for (int i = 0; i < isize; ++i) {
            Component tc = this.tabPages_.get(i).getComponent();
            if (c != tc) continue;
            this.setSelectedIndex(i);
            return;
        }
    }

    public void removeTabAt(int index) {
        if (index < 0 || index >= this.tabPages_.size()) {
            return;
        }
        int sindex = this.getSelectedIndex();
        super.remove(this.getComponentAt(index));
        this.tabPages_.remove(index);
        if (sindex > index) {
            --sindex;
        } else if (sindex == index && ++sindex >= this.tabPages_.size()) {
            --sindex;
        }
        this.setSelectedIndex(sindex);
        this.repaint();
    }

    public Component getComponentAt(int index) {
        this.verifyIndex(index);
        return this.tabPages_.get(index).getComponent();
    }

    public void setComponentAt(int index, Component component) {
        Component old = this.getComponentAt(index);
        this.remove(old);
        this.add(component);
        this.tabPages_.get(index).setComponent(component);
        this.repaint();
    }

    public void setTitleAt(int index, String title) {
        this.verifyIndex(index);
        this.tabPages_.get(index).setTitle(title);
        this.repaint();
    }

    public int indexOfComponent(Component c) {
        if (c == null) {
            return -1;
        }
        int isize = this.tabPages_.size();
        for (int i = 0; i < isize; ++i) {
            Component tc = this.tabPages_.get(i).getComponent();
            if (c != tc) continue;
            return i;
        }
        return -1;
    }

    public int indexOfTab(String title) {
        if (title == null) {
            return -1;
        }
        int isize = this.tabPages_.size();
        for (int i = 0; i < isize; ++i) {
            String tt = this.tabPages_.get(i).getTitle();
            if (tt == null || !tt.equals(title)) continue;
            return i;
        }
        return -1;
    }

    public Border getInnerBorder() {
        return this.innerBorder_;
    }

    public void setInnerBorder(Border border) {
        this.innerBorder_ = border;
        this.doLayout();
        this.repaint();
    }

    private void verifyIndex(int index) {
        if (index < 0 || index >= this.tabPages_.size()) {
            throw new IndexOutOfBoundsException("There is no tab at index " + index);
        }
    }

    @Override
    public void setLayout(LayoutManager ignored) {
    }

    @Override
    public LayoutManager getLayout() {
        return null;
    }

    @Override
    public void doLayout() {
        this.placeSelectedComponent();
        this.calculateTabRects();
        super.doLayout();
    }

    private void placeSelectedComponent() {
        Insets outerIns = this.getInsets();
        Insets innerIns = this.innerBorder_ != null ? this.innerBorder_.getBorderInsets(this) : new Insets(0, 0, 0, 0);
        int w = this.getWidth();
        int h = this.getHeight();
        int iw = w - outerIns.left - outerIns.right - innerIns.left - innerIns.right;
        int ih = h - outerIns.top - outerIns.bottom - innerIns.top - innerIns.bottom - 25;
        int cTop = this.tabPlacement_ == TabPlacement.TOP ? outerIns.top + 25 : outerIns.top;
        Component sc = this.getSelectedComponent();
        for (TabPage tab : this.tabPages_) {
            Component c = tab.getComponent();
            if (c == sc) {
                c.setBounds(outerIns.left + innerIns.left, cTop + innerIns.top, iw, ih);
            } else {
                c.setBounds(0, 0, 0, 0);
            }
            c.invalidate();
            c.validate();
        }
    }

    private void calculateTabRects() {
        int i;
        int isize = this.tabPages_.size();
        Insets outerIns = this.getInsets();
        int tabTop = this.tabPlacement_ == TabPlacement.TOP ? outerIns.top : this.getHeight() - outerIns.bottom - 25;
        int iw = this.getWidth() - outerIns.left - outerIns.right;
        int boffset = 0;
        for (TabPage tab : this.tabPages_) {
            Dimension d = this.getButtonSize(tab.getTitle());
            tab.setTabBounds(outerIns.left + boffset, tabTop, d.width, 25);
            boffset += d.width;
        }
        boolean bl = this.tooManyTabs_ = boffset > iw;
        if (!this.tooManyTabs_) {
            this.firstVisibleTab_ = 0;
            this.lastVisibleTab_ = isize - 1;
            this.leftButtonEnabled_ = false;
            this.rightButtonEnabled_ = false;
            boffset = (iw - boffset) / 2;
            for (TabPage tab : this.tabPages_) {
                Point p = tab.getTabLocation();
                p.x += boffset;
                tab.setTabLocation(p);
            }
        }
        int available = iw - 50;
        if (this.firstVisibleTab_ < 1) {
            this.firstVisibleTab_ = 0;
        }
        for (int i2 = 0; i2 < this.firstVisibleTab_; ++i2) {
            this.tabPages_.get(i2).setTabBounds(-1, -1, 0, 0);
        }
        boffset = 0;
        int firstOverflow = -1;
        for (i = this.firstVisibleTab_; i < isize; ++i) {
            Dimension d = this.tabPages_.get(i).getTabSize();
            if (boffset + d.width < available) {
                boffset += d.width;
                continue;
            }
            firstOverflow = i;
            break;
        }
        if (firstOverflow == -1) {
            firstOverflow = isize;
        }
        this.lastVisibleTab_ = firstOverflow - 1;
        boffset = 25 + (available - boffset) / 2;
        for (i = this.firstVisibleTab_; i < firstOverflow; ++i) {
            TabPage tab = this.tabPages_.get(i);
            Point p = tab.getTabLocation();
            Dimension d = tab.getTabSize();
            p.x = boffset;
            tab.setTabLocation(p);
            boffset += d.width;
        }
        for (i = firstOverflow; i < isize; ++i) {
            this.tabPages_.get(i).setTabBounds(-1, -1, 0, 0);
        }
        this.leftButtonEnabled_ = this.firstVisibleTab_ > 0;
        boolean bl2 = this.rightButtonEnabled_ = firstOverflow < isize;
        if (this.leftButtonRect_ == null) {
            this.leftButtonRect_ = new Rectangle(0, 0, 25, 25);
        }
        if (this.rightButtonRect_ == null) {
            this.rightButtonRect_ = new Rectangle(0, 0, 25, 25);
        }
        this.leftButtonRect_.x = outerIns.left;
        this.leftButtonRect_.y = tabTop;
        this.rightButtonRect_.x = this.getWidth() - outerIns.right - 25;
        this.rightButtonRect_.y = tabTop;
    }

    private Dimension getButtonSize(String s) {
        FontMetrics fm = this.getFontMetrics(this.buttonFont_);
        int w = 19 + fm.stringWidth(s) + 19;
        return new Dimension(w, 25);
    }

    @Override
    public Dimension getPreferredSize() {
        int w = 0;
        int h = 0;
        for (TabPage tab : this.tabPages_) {
            Component c = tab.getComponent();
            Dimension d = c.getPreferredSize();
            w = Math.max(w, d.width);
            h = Math.max(h, d.height);
        }
        h += 25;
        Insets outerIns = this.getInsets();
        Insets innerIns = this.innerBorder_ != null ? this.innerBorder_.getBorderInsets(this) : new Insets(0, 0, 0, 0);
        w += outerIns.left + outerIns.right;
        h += outerIns.top + outerIns.bottom;
        return new Dimension(w += innerIns.left + innerIns.right, h += innerIns.top + innerIns.bottom);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = GraphicUtils.createAntialiasedGfx(g);
        Insets outerIns = this.getInsets();
        int x = outerIns.left;
        int y = this.tabPlacement_ == TabPlacement.TOP ? outerIns.top : this.getHeight() - outerIns.bottom - 25;
        int iw = this.getWidth() - outerIns.left - outerIns.right;
        int ih = this.getHeight() - outerIns.top - outerIns.bottom;
        if (this.isOpaque()) {
            g2d.setColor(this.getBackground());
            g2d.fillRect(outerIns.left, outerIns.top, iw, ih);
        }
        int theight = 12;
        int bheight = 13;
        g2d.setColor(Color.WHITE);
        g2d.fillRect(x, y, iw, 25);
        GradientPaint tPaint = new GradientPaint(0.0f, 0.0f, BAR_BACKGROUND_1, 0.0f, 11.0f, BAR_BACKGROUND_2);
        g2d.setPaint(tPaint);
        g2d.fillRect(x, y, iw, 12);
        GradientPaint bPaint = new GradientPaint(0.0f, y + 12, BAR_BACKGROUND_3, 0.0f, y + 25, BAR_BACKGROUND_3);
        g2d.setPaint(bPaint);
        g2d.fillRect(x, y + 12, iw, 13);
        g2d.setColor(BAR_TOP_1);
        g2d.drawLine(x, y, x + iw - 1, y);
        g2d.setColor(BAR_TOP_2);
        g2d.drawLine(x, y + 1, x + iw - 1, y + 1);
        g2d.setColor(BAR_TOP_3);
        g2d.drawLine(x, y + 2, x + iw - 1, y + 2);
        g2d.setColor(BAR_BOTTOM_1);
        g2d.drawLine(x, y + 25 - 3, x + iw - 1, y + 25 - 3);
        g2d.setColor(BAR_BOTTOM_2);
        g2d.drawLine(x, y + 25 - 2, x + iw - 1, y + 25 - 2);
        g2d.setColor(BAR_BOTTOM_3);
        g2d.drawLine(x, y + 25 - 1, x + iw - 1, y + 25 - 1);
        if (this.innerBorder_ != null) {
            this.innerBorder_.paintBorder(this, g, outerIns.left, outerIns.top + 25, iw, ih - 25);
        }
        int selIndex = this.model_.getSelectedIndex();
        for (int i = this.firstVisibleTab_; i <= this.lastVisibleTab_; ++i) {
            TabPage tab = this.tabPages_.get(i);
            Rectangle r = tab.getTabBounds();
            this.paintTabButton(g2d, r, tab.getTitle(), i == selIndex || i == this.buttonPressed_);
        }
        if (this.tooManyTabs_) {
            int l = this.leftButtonRect_.x;
            int r = this.rightButtonRect_.x + this.rightButtonRect_.width;
            int m = this.leftButtonRect_.y + 12;
            this.paintTabButtonBackground(g2d, this.leftButtonRect_, this.buttonPressed_ == -101);
            this.paintTabButtonBackground(g2d, this.rightButtonRect_, this.buttonPressed_ == -102);
            GeneralPath path = new GeneralPath();
            path.moveTo(l + 5, m);
            path.lineTo(l + 5 + 10, m - 5);
            path.lineTo(l + 5 + 10, m + 5);
            path.closePath();
            if (this.leftButtonEnabled_) {
                g2d.setColor(Color.WHITE);
            } else {
                g2d.setColor(new Color(255, 255, 255, 51));
            }
            g2d.fill(path);
            path.reset();
            path.moveTo(r - 5, m);
            path.lineTo(r - 5 - 10, m - 5);
            path.lineTo(r - 5 - 10, m + 5);
            path.closePath();
            if (this.rightButtonEnabled_) {
                g2d.setColor(Color.WHITE);
            } else {
                g2d.setColor(new Color(255, 255, 255, 51));
            }
            g2d.fill(path);
        }
        Rectangle bRect = this.tabPages_.get(this.firstVisibleTab_).getTabBounds();
        Rectangle pRect = new Rectangle();
        pRect.x = x + (this.tooManyTabs_ ? 25 : 0);
        pRect.y = bRect.y;
        pRect.width = bRect.x - pRect.x;
        pRect.height = 25;
        this.paintTabButtonBackground(g2d, pRect, false);
        bRect = this.tabPages_.get(this.lastVisibleTab_).getTabBounds();
        pRect.x = bRect.x + bRect.width;
        pRect.width = this.tooManyTabs_ ? this.rightButtonRect_.x - pRect.x : this.getWidth() - outerIns.right - pRect.x;
        this.paintTabButtonBackground(g2d, pRect, false);
    }

    private void paintTabButton(Graphics2D g2d, Rectangle rect, String text, boolean isSelected) {
        this.paintTabButtonBackground(g2d, rect, isSelected);
        int w = rect.width;
        int h = rect.height;
        FontMetrics fm = g2d.getFontMetrics(this.buttonFont_);
        int x = rect.x + (w - fm.stringWidth(text)) / 2;
        int y = rect.y + (h - fm.getHeight()) / 2;
        g2d.setFont(this.buttonFont_);
        g2d.setColor(TEXT_SHADOW_COLOR);
        g2d.drawString(text, x, y + fm.getAscent());
        g2d.setColor(TEXT_COLOR);
        g2d.drawString(text, x, y + fm.getAscent() + 1);
    }

    private void paintTabButtonBackground(Graphics2D g2d, Rectangle rect, boolean isSelected) {
        g2d.translate(rect.x, rect.y);
        int w = rect.width;
        int h = rect.height;
        if (isSelected) {
            GradientPaint paint = new GradientPaint(0.0f, 0.0f, SELECTED_BACKGROUND_1, 0.0f, h, SELECTED_BACKGROUND_2);
            g2d.setPaint(paint);
            g2d.fillRect(0, 0, w, h);
            g2d.setColor(SELECTED_TOP_BORDER);
            g2d.drawLine(0, 0, w - 1, 0);
            g2d.setColor(SELECTED_BOTTOM_BORDER);
            g2d.drawLine(0, h - 1, w - 1, h - 1);
            g2d.setColor(SELECTED_SIDE_BORDER_1);
            g2d.drawLine(0, 1, w - 1, 1);
            g2d.setColor(SELECTED_SIDE_BORDER_2);
            g2d.drawLine(0, 2, w - 1, 2);
            paint = new GradientPaint(0.0f, 0.0f, SELECTED_SIDE_BORDER_1, 7.0f, 0.0f, SELECTED_SIDE_BORDER_3);
            g2d.setPaint(paint);
            g2d.fillRect(0, 3, 7, h - 3);
            paint = new GradientPaint(w - 7, 0.0f, SELECTED_SIDE_BORDER_3, w, 0.0f, SELECTED_SIDE_BORDER_1);
            g2d.setPaint(paint);
            g2d.fillRect(w - 7, 3, 7, h - 3);
        } else {
            g2d.setColor(LEFT_BORDER);
            g2d.drawLine(0, 1, 0, h - 1);
            g2d.setColor(RIGHT_BORDER);
            g2d.drawLine(w - 1, 1, w - 1, h - 1);
        }
        g2d.translate(-rect.x, -rect.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener l) {
        Object object = this.lock_;
        synchronized (object) {
            this.listenerList.add(ChangeListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener l) {
        Object object = this.lock_;
        synchronized (object) {
            this.listenerList.remove(ChangeListener.class, l);
        }
    }

    protected void fireChangeEvent() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ChangeEvent e = new ChangeEvent(this);
            ((ChangeListener)listeners[i + 1]).stateChanged(e);
        }
    }

    private int getTabButtonAtPoint(Point p) {
        for (int i = this.firstVisibleTab_; i <= this.lastVisibleTab_; ++i) {
            TabPage tab = this.tabPages_.get(i);
            Rectangle r = tab.getTabBounds();
            if (p.x < r.x || p.x >= r.x + r.width || p.y < r.y || p.y >= r.y + r.height) continue;
            return i;
        }
        if (this.leftButtonEnabled_ && p.x >= this.leftButtonRect_.x && p.x < this.leftButtonRect_.x + this.leftButtonRect_.width && p.y >= this.leftButtonRect_.y && p.y < this.leftButtonRect_.y + this.leftButtonRect_.height) {
            return -101;
        }
        if (this.rightButtonEnabled_ && p.x >= this.rightButtonRect_.x && p.x < this.rightButtonRect_.x + this.rightButtonRect_.width && p.y >= this.rightButtonRect_.y && p.y < this.rightButtonRect_.y + this.rightButtonRect_.height) {
            return -102;
        }
        return -1;
    }

    class TabPage {
        private String title_;
        private Component component_;
        private Rectangle tabRect_;

        public TabPage(String title, Component c) {
            this.title_ = title;
            this.component_ = c;
            this.tabRect_ = new Rectangle(0, 0, 0, 0);
        }

        public String getTitle() {
            return this.title_;
        }

        public void setTitle(String title) {
            this.title_ = title;
        }

        public Component getComponent() {
            return this.component_;
        }

        public void setComponent(Component c) {
            this.component_ = c;
        }

        public void setTabLocation(Point p) {
            this.tabRect_.x = p.x;
            this.tabRect_.y = p.y;
        }

        public void setTabSize(Dimension d) {
            this.tabRect_.width = d.width;
            this.tabRect_.height = d.height;
        }

        public void setTabBounds(int x, int y, int w, int h) {
            this.tabRect_.x = x;
            this.tabRect_.y = y;
            this.tabRect_.width = w;
            this.tabRect_.height = h;
        }

        public void setTabBounds(Rectangle rect) {
            this.tabRect_.x = rect.x;
            this.tabRect_.y = rect.y;
            this.tabRect_.width = rect.width;
            this.tabRect_.height = rect.height;
        }

        public Point getTabLocation() {
            return new Point(this.tabRect_.x, this.tabRect_.y);
        }

        public Dimension getTabSize() {
            return new Dimension(this.tabRect_.width, this.tabRect_.height);
        }

        public Rectangle getTabBounds() {
            return this.tabRect_;
        }
    }

    protected class ModelListener
    implements ChangeListener {
        protected ModelListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            HudTabbedPane.this.fireChangeEvent();
        }
    }

    class TabButtonMouseListener
    extends MouseAdapter {
        TabButtonMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                HudTabbedPane.this.buttonPressed_ = -1;
            } else {
                HudTabbedPane.this.buttonPressed_ = HudTabbedPane.this.getTabButtonAtPoint(e.getPoint());
                HudTabbedPane.this.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (HudTabbedPane.this.buttonPressed_ == -1) {
                return;
            }
            int buttonReleased = HudTabbedPane.this.getTabButtonAtPoint(e.getPoint());
            if (buttonReleased != -1 && buttonReleased == HudTabbedPane.this.buttonPressed_) {
                if (HudTabbedPane.this.buttonPressed_ == -101) {
                    --HudTabbedPane.this.firstVisibleTab_;
                } else if (HudTabbedPane.this.buttonPressed_ == -102) {
                    ++HudTabbedPane.this.firstVisibleTab_;
                } else if (buttonReleased != HudTabbedPane.this.getSelectedIndex()) {
                    HudTabbedPane.this.setSelectedIndex(buttonReleased);
                }
                HudTabbedPane.this.doLayout();
            }
            HudTabbedPane.this.repaint();
            HudTabbedPane.this.buttonPressed_ = -1;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }
    }

    public static enum TabPlacement {
        TOP,
        BOTTOM;

    }
}

