/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.menu;

import gov.nasa.giss.ui.menu.GissCheckBoxMenuItem;
import gov.nasa.giss.ui.menu.GissMenuItem;
import gov.nasa.giss.ui.menu.GissRadioButtonMenuItem;
import gov.nasa.giss.util.PlatformUtils;
import gov.nasa.giss.util.PropertyList;
import java.awt.Component;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class GissMenu
extends JMenu {
    protected PropertyList menuProperties_;

    public GissMenu() {
    }

    public GissMenu(Action a) {
        super(a);
    }

    public GissMenu(String text, String name) {
        super(text);
        this.setName(name);
    }

    public GissMenu(PropertyList plist) {
        this.setProperties(plist);
    }

    public GissMenu(PropertyList plist, String name) {
        this(plist);
        this.setText(this.menuProperties_.getString(name));
        this.setName(name);
    }

    public void setProperties(PropertyList props) {
        this.menuProperties_ = props;
    }

    protected GissMenuItem makeItemFromProperties(String pname, AbstractAction a) {
        if (this.menuProperties_ == null) {
            throw new IllegalArgumentException("Properties were not specified");
        }
        String text = this.menuProperties_.getString(pname);
        if (text == null) {
            throw new IllegalArgumentException("No properties item by that name");
        }
        GissMenuItem mi = new GissMenuItem(a);
        mi.setName(pname);
        mi.setText(text);
        KeyStroke ks = this.makeKeystrokeFromProperties(pname);
        if (ks != null) {
            mi.setAccelerator(ks);
        }
        return mi;
    }

    protected GissCheckBoxMenuItem makeCheckBoxItem(String text, AbstractAction a) {
        GissCheckBoxMenuItem mi = GissCheckBoxMenuItem.createItem(text, a);
        mi.setName("_" + text);
        return mi;
    }

    protected GissCheckBoxMenuItem makeCheckBoxItemFromProperties(String pname, AbstractAction a) {
        if (this.menuProperties_ == null) {
            throw new IllegalArgumentException("Properties have not specified");
        }
        String text = this.menuProperties_.getString(pname);
        if (text == null) {
            throw new IllegalArgumentException("No property named " + pname);
        }
        GissCheckBoxMenuItem mi = GissCheckBoxMenuItem.createItem(text, a);
        mi.setName(pname);
        KeyStroke ks = this.makeKeystrokeFromProperties(pname);
        if (ks != null) {
            mi.setAccelerator(ks);
        }
        return mi;
    }

    protected GissRadioButtonMenuItem makeRadioButtonItemFromProperties(String pname, AbstractAction a) {
        if (this.menuProperties_ == null) {
            throw new IllegalArgumentException("Properties have not been specified");
        }
        String text = this.menuProperties_.getString(pname);
        if (text == null) {
            throw new IllegalArgumentException("No property by that name");
        }
        GissRadioButtonMenuItem mi = GissRadioButtonMenuItem.createItem(text, a);
        mi.setName(pname);
        KeyStroke ks = this.makeKeystrokeFromProperties(pname);
        if (ks != null) {
            mi.setAccelerator(ks);
        }
        return mi;
    }

    protected KeyStroke makeKeystrokeFromProperties(String pname) {
        String desc;
        String text = this.menuProperties_.getString(pname);
        if (text == null) {
            return null;
        }
        String string = desc = PlatformUtils.isMacintosh() ? this.menuProperties_.getAttribute(pname, "mackeystroke") : this.menuProperties_.getAttribute(pname, "keystroke");
        if (desc == null) {
            return null;
        }
        return KeyStroke.getKeyStroke(desc);
    }

    public JMenuItem getItemByName(String name) {
        int isize = this.getMenuComponentCount();
        for (int i = 0; i < isize; ++i) {
            JMenuItem mi;
            String iname;
            Component c = this.getMenuComponent(i);
            if (!(c instanceof JMenuItem) || (iname = (mi = (JMenuItem)c).getName()) == null || !iname.equals(name)) continue;
            return mi;
        }
        return null;
    }

    public JMenuItem getItemByText(String text) {
        int isize = this.getMenuComponentCount();
        for (int i = 0; i < isize; ++i) {
            JMenuItem mi;
            String itext;
            Component c = this.getMenuComponent(i);
            if (!(c instanceof JMenuItem) || (itext = (mi = (JMenuItem)c).getText()) == null || !itext.equals(text)) continue;
            return mi;
        }
        return null;
    }

    public JMenuItem getItemByKeyStroke(KeyStroke ks) {
        int isize = this.getMenuComponentCount();
        for (int i = 0; i < isize; ++i) {
            JMenuItem mi;
            KeyStroke iks;
            Component c = this.getMenuComponent(i);
            if (!(c instanceof JMenuItem) || (iks = (mi = (JMenuItem)c).getAccelerator()) == null || !iks.equals(ks)) continue;
            return mi;
        }
        return null;
    }

    public Action getItemActionByName(String itemName) {
        JMenuItem jmi = this.getItemByName(itemName);
        if (jmi == null) {
            return null;
        }
        return jmi.getAction();
    }

    public void refresh() {
        int isize = this.getMenuComponentCount();
        for (int i = 0; i < isize; ++i) {
            Component c = this.getMenuComponent(i);
            if (!(c instanceof JMenuItem) || !(c instanceof GissMenu)) continue;
            ((GissMenu)c).refresh();
        }
        this.setSize(this.getPreferredSize());
    }
}

