/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.label;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.ui.label.LabelSizeVariantListener;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class VerticalLabel
extends JComponent {
    public static final int LEFT = 2;
    public static final int CENTER = 0;
    public static final int RIGHT = 4;
    public static final int TOP = 1;
    public static final int BOTTOM = 3;
    public static final int UP = 0;
    public static final int DOWN = 1;
    private static final double HALF_PI = 1.5707963267948966;
    protected String text_;
    protected int direction_ = 0;
    protected int hAlignment_ = 0;
    protected int vAlignment_ = 0;
    protected int textWidth_;
    protected int lineHeight_;
    protected int lineAscent_;
    protected boolean measured_;

    public VerticalLabel() {
        this("");
    }

    public VerticalLabel(String text) {
        this(text, 0);
    }

    public VerticalLabel(String text, int direction) {
        this.setText(text);
        this.setDirection(direction);
        Font f = UIManager.getDefaults().getFont("Label.font");
        if (f != null) {
            this.setFont(f);
        }
        if (PlatformUtils.isMacintosh()) {
            this.addPropertyChangeListener(new LabelSizeVariantListener(this));
        }
    }

    public String getText() {
        return this.text_;
    }

    public void setText(String s) {
        this.text_ = s;
        this.measured_ = false;
        this.repaint();
    }

    public int getDirection() {
        return this.direction_;
    }

    public void setDirection(int direction) {
        this.direction_ = direction == 1 ? 1 : 0;
        this.measured_ = false;
        this.repaint();
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.measured_ = false;
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.measured_) {
            this.measure();
        }
        Insets ins = this.getInsets();
        return new Dimension(this.lineHeight_ + ins.left + ins.right, this.textWidth_ + ins.top + ins.bottom);
    }

    protected synchronized void measure() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        this.lineHeight_ = fm.getHeight();
        this.lineAscent_ = fm.getAscent();
        this.textWidth_ = fm.stringWidth(this.text_);
        this.measured_ = true;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.measured_) {
            this.measure();
        }
        Dimension size = this.getSize();
        Insets ins = this.getInsets();
        int x = this.hAlignment_ == 0 ? (size.width - this.lineHeight_) / 2 : (this.hAlignment_ == 4 ? size.width - ins.right - this.lineHeight_ : ins.left);
        if (this.direction_ == 0) {
            x += this.lineAscent_;
        }
        int y = this.vAlignment_ == 0 ? (size.height - this.textWidth_) / 2 : (this.vAlignment_ == 3 ? size.height - ins.bottom - this.textWidth_ : ins.top);
        if (this.direction_ == 0) {
            y += this.textWidth_;
        }
        double rotate = this.direction_ == 0 ? -1.5707963267948966 : 1.5707963267948966;
        Graphics2D g2d = GraphicUtils.createAntialiasedGfx(g);
        g2d.translate(x, y);
        g2d.rotate(rotate);
        g2d.drawString(this.text_, 0, 0);
        g2d.rotate(-rotate);
        g2d.translate(-x, -y);
        g2d.dispose();
    }
}

