/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.color.chooser;

import gov.nasa.giss.ui.color.chooser.ColorChooserPanel;
import gov.nasa.giss.ui.color.chooser.ColorChooserPreview;
import gov.nasa.giss.ui.color.chooser.ColorComponentID;
import gov.nasa.giss.ui.color.chooser.HsbSlider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.colorchooser.ColorSelectionModel;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class HsbSliderPanel
extends ColorChooserPanel {
    private HsbTextField hField_;
    private HsbTextField sField_;
    private HsbTextField bField_;
    private JLabel hexLabel_;

    @Override
    void setComponent(ColorComponentID compID, int value) {
        switch (compID) {
            case HUE: {
                this.setComponent(ColorComponentID.HUE, (float)value / 360.0f);
                break;
            }
            case SATURATION: 
            case BRIGHTNESS: {
                this.setComponent(compID, (float)value / 100.0f);
            }
        }
    }

    @Override
    void setComponent(ColorComponentID compID, float value) {
        if (value < 0.0f || value > 1.0f) {
            return;
        }
        Color c = this.getColorSelectionModel().getSelectedColor();
        float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        try {
            switch (compID) {
                case HUE: {
                    c = Color.getHSBColor(value, hsb[1], hsb[2]);
                    break;
                }
                case SATURATION: {
                    c = Color.getHSBColor(hsb[0], value, hsb[2]);
                    break;
                }
                case BRIGHTNESS: {
                    c = Color.getHSBColor(hsb[0], hsb[1], value);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setColor(c);
    }

    @Override
    public void buildChooser() {
        ColorSelectionModel csmodel = this.getColorSelectionModel();
        ColorChooserPreview colorbox = new ColorChooserPreview(csmodel);
        JLabel hLabel = new JLabel("H", 4);
        JLabel sLabel = new JLabel("S", 4);
        JLabel bLabel = new JLabel("B", 4);
        JLabel hUnits = new JLabel("\u00b0", 2);
        JLabel sUnits = new JLabel("%", 2);
        JLabel bUnits = new JLabel("%", 2);
        hLabel.setFont(hLabel.getFont().deriveFont((float)((double)hLabel.getFont().getSize() - 3.0)));
        sLabel.setFont(hLabel.getFont());
        bLabel.setFont(hLabel.getFont());
        hUnits.setFont(hLabel.getFont());
        sUnits.setFont(hLabel.getFont());
        bUnits.setFont(hLabel.getFont());
        this.hField_ = new HsbTextField(ColorComponentID.HUE);
        this.sField_ = new HsbTextField(ColorComponentID.SATURATION);
        this.bField_ = new HsbTextField(ColorComponentID.BRIGHTNESS);
        this.hexLabel_ = new JLabel("#FFFFFF", 0);
        FlexingGridLayout fgl = new FlexingGridLayout(new Dimension(8, 5), 2, 4);
        fgl.setColumnWeight(0, 9999.0f);
        fgl.setColumnWeight(2, 9999.0f);
        fgl.setColumnWeight(7, 9999.0f);
        fgl.setRowWeight(4, 9999.0f);
        this.setLayout(fgl);
        this.add((Component)colorbox, new FGConstraint(1, 0, 1, 3, 0.5, 0.0));
        this.add((Component)hLabel, new FGConstraint(3, 0, 1, 1));
        this.add((Component)new HsbSlider(this, ColorComponentID.HUE), new FGConstraint(4, 0, 1, 1));
        this.add((Component)this.hField_, new FGConstraint(5, 0, 1, 1));
        this.add((Component)hUnits, new FGConstraint(6, 0, 1, 1));
        this.add((Component)sLabel, new FGConstraint(3, 1, 1, 1));
        this.add((Component)new HsbSlider(this, ColorComponentID.SATURATION), new FGConstraint(4, 1, 1, 1));
        this.add((Component)this.sField_, new FGConstraint(5, 1, 1, 1));
        this.add((Component)sUnits, new FGConstraint(6, 1, 1, 1));
        this.add((Component)bLabel, new FGConstraint(3, 2, 1, 1));
        this.add((Component)new HsbSlider(this, ColorComponentID.BRIGHTNESS), new FGConstraint(4, 2, 1, 1));
        this.add((Component)this.bField_, new FGConstraint(5, 2, 1, 1));
        this.add((Component)bUnits, new FGConstraint(6, 2, 1, 1));
        this.add((Component)this.hexLabel_, new FGConstraint(1, 3, 6, 1, 0.5, 0.5));
        this.add(Box.createGlue(), new Rectangle(0, 0, 1, 1));
        this.add(Box.createGlue(), new Rectangle(2, 0, 1, 1));
        this.add(Box.createGlue(), new Rectangle(7, 4, 1, 1));
    }

    @Override
    public void updateChooser() {
        this.hField_.refresh();
        this.sField_.refresh();
        this.bField_.refresh();
        Color c = this.getColorSelectionModel().getSelectedColor();
        String hex = String.format("#%02x%02x%02x", c.getRed(), c.getGreen(), c.getBlue());
        this.hexLabel_.setText(hex);
        this.repaint();
    }

    @Override
    public String getDisplayName() {
        return "HSB";
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    private class HsbTextField
    extends JTextField {
        private ColorComponentID compID_;

        HsbTextField(ColorComponentID compID) {
            super(4);
            this.setHorizontalAlignment(4);
            this.setFont(this.getFont().deriveFont((float)((double)this.getFont().getSize() - 2.0)));
            this.compID_ = compID;
            switch (compID) {
                case HUE: {
                    this.setText("359");
                    break;
                }
                default: {
                    this.setText("100");
                }
            }
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    HsbTextField.this.respond();
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            this.addActionListener(e -> this.respond());
        }

        private void refresh() {
            ColorSelectionModel csm = HsbSliderPanel.this.getColorSelectionModel();
            if (csm == null) {
                return;
            }
            Color c = csm.getSelectedColor();
            float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
            switch (this.compID_) {
                case HUE: {
                    this.setText(Integer.toString((int)(hsb[0] * 360.0f)));
                    break;
                }
                case SATURATION: {
                    this.setText(Integer.toString((int)(hsb[1] * 100.0f)));
                    break;
                }
                case BRIGHTNESS: {
                    this.setText(Integer.toString((int)(hsb[2] * 100.0f)));
                    break;
                }
            }
        }

        private void respond() {
            try {
                HsbSliderPanel.this.setComponent(this.compID_, Integer.parseInt(this.getText()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.refresh();
        }
    }
}

