/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.color.chooser;

import gov.nasa.giss.ui.color.chooser.ColorChooserPanel;
import gov.nasa.giss.ui.color.chooser.ColorComponentID;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.MouseInputAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ColorChooserSlider
extends JComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Color SHADOW = new Color(51, 51, 51);
    private static final Color HIGHLIGHT = new Color(153, 153, 153);
    private static ImageIcon tickIcon_ = new ImageIcon(ColorChooserSlider.class.getResource("resources/slidertick.png"));
    private static Image tickImage_ = tickIcon_.getImage();
    protected ColorSelectionModel csmodel_;
    protected ColorComponentID compID_;
    private ColorChooserPanel chooserPanel_;
    private MouseInputAdapter mouseListener_;
    private int barWidth_ = 128;
    private int barHeight_ = 5;
    private int barLeft_;
    private int barTop_;
    private int barBottom_;
    private int pad_ = 6;
    private int tickWidth2_;
    private int tickHeight2_;

    ColorChooserSlider(ColorChooserPanel panel, ColorComponentID compID) {
        this.chooserPanel_ = panel;
        this.csmodel_ = panel.getColorSelectionModel();
        this.compID_ = compID;
        this.setOpaque(false);
        Dimension size = new Dimension(this.barWidth_ + 2 * this.barLeft_, this.barHeight_ + 8);
        this.setPreferredSize(size);
        this.mouseListener_ = new SliderMouseHandler();
        this.addMouseListener(this.mouseListener_);
        this.addMouseMotionListener(this.mouseListener_);
    }

    @Override
    public void paintComponent(Graphics g) {
        int h = this.getHeight();
        int w = this.getWidth();
        this.barHeight_ = h / 3;
        this.tickHeight2_ = 12;
        this.tickWidth2_ = 12;
        this.barWidth_ = w - 2 * (this.pad_ + 1);
        this.barLeft_ = this.pad_ + 1;
        this.barTop_ = (h - 16) / 2 + this.barHeight_;
        this.barBottom_ = this.barTop_ + this.barHeight_ + 1;
        Color c = this.csmodel_.getSelectedColor();
        for (int i = 0; i < this.barWidth_; ++i) {
            float pct = (float)i / (float)this.barWidth_;
            Color cc = this.getColorAt(c, pct);
            g.setColor(cc);
            g.drawLine(this.barLeft_ + i, this.barTop_ + 1, this.barLeft_ + i, this.barTop_ + this.barHeight_);
        }
        g.setColor(SHADOW);
        g.drawLine(this.pad_ + 0, this.barTop_, this.barLeft_ + this.barWidth_, this.barTop_);
        g.drawLine(this.pad_ + 0, this.barTop_, this.pad_ + 0, this.barBottom_);
        g.setColor(HIGHLIGHT);
        g.drawLine(this.barLeft_, this.barBottom_, this.barLeft_ + this.barWidth_, this.barBottom_);
        g.drawLine(this.barLeft_ + this.barWidth_, this.barTop_ + 1, this.barLeft_ + this.barWidth_, this.barBottom_);
        g.drawImage(tickImage_, this.barLeft_ + this.getTickX() - this.tickWidth2_ / 2, (this.barTop_ + this.barBottom_ - this.tickHeight2_) / 2, this.tickWidth2_, this.tickHeight2_, new Color(0, 0, 0, 0), this);
    }

    abstract Color getColorAt(Color var1, float var2);

    abstract float getTickXPct(Color var1);

    private int getTickX() {
        Color c = this.csmodel_.getSelectedColor();
        float pct = this.getTickXPct(c);
        return (int)((float)this.barWidth_ * pct);
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    private class SliderMouseHandler
    extends MouseInputAdapter {
        private boolean dragInProgress;

        SliderMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int tick = ColorChooserSlider.this.getTickX();
            int x = e.getX() - ColorChooserSlider.this.pad_;
            if (x < tick - ColorChooserSlider.this.tickWidth2_ / 2 || x > tick + ColorChooserSlider.this.tickWidth2_ / 2 || x < 0 || x > ColorChooserSlider.this.barWidth_) {
                return;
            }
            this.handleMouse(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.mouseClicked(e);
            this.dragInProgress = true;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.dragInProgress) {
                return;
            }
            this.handleMouse(e);
            this.dragInProgress = false;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!this.dragInProgress) {
                return;
            }
            this.handleMouse(e);
        }

        public void handleMouse(MouseEvent e) {
            int x = e.getX() - ColorChooserSlider.this.pad_ - 1;
            float pct = (float)x / (float)ColorChooserSlider.this.barWidth_;
            if ((double)pct < 0.0 || (double)pct > 1.0) {
                LOGGER.warn("pct {}", (Object)Float.valueOf(pct));
            }
            ColorChooserSlider.this.chooserPanel_.setComponent(ColorChooserSlider.this.compID_, pct);
        }
    }
}

