/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.color;

import gov.nasa.giss.graphics.AbstractColorTable;
import gov.nasa.giss.graphics.GraphicUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.MouseInputAdapter;

public class ColorTableBinPanel
extends JComponent {
    private static final String NO_OUTLIERS = "No special outlier colors";
    private static final String LT_MIN = "min.<";
    private static final String GT_MAX = ">max.";
    private static final Color FOCUS_COLOR = UIManager.getColor("Table.focusCellForeground").darker();
    private static final Border SIMPLE_OUTLINE_BORDER = new CompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), new CompoundBorder(BorderFactory.createLineBorder(Color.GRAY, 1), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
    private static final Border HILITE_OUTLINE_BORDER = new CompoundBorder(BorderFactory.createLineBorder(FOCUS_COLOR, 1), new CompoundBorder(BorderFactory.createLineBorder(Color.GRAY, 1), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
    private static final Font DEFAULT_FONT = new Font("Lucida Sans", 0, 8);
    private static final int PANEL_WIDTH = 600;
    private int binInside_ = 20;
    private int binSize_ = this.binInside_ + 2;
    private int binGap_ = 4;
    private int cellSize_ = this.binSize_ + this.binGap_;
    private int binsPerRow_ = 16;
    private AbstractColorTable colortable_;
    private int colorCount_;
    private Point[] binLoci_;
    private boolean binIdsVisible_;

    public ColorTableBinPanel(AbstractColorTable ct) {
        this.setFont(DEFAULT_FONT);
        this.colortable_ = ct;
        this.setOpaque(false);
        this.setBorder(SIMPLE_OUTLINE_BORDER);
        this.measure();
        BinMouseHandler mouseAdapter = new BinMouseHandler();
        this.addMouseListener(mouseAdapter);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                ColorTableBinPanel.this.setBorder(SIMPLE_OUTLINE_BORDER);
            }

            @Override
            public void focusGained(FocusEvent e) {
                ColorTableBinPanel.this.setBorder(HILITE_OUTLINE_BORDER);
            }
        });
        this.attachAction(new ToggleLabelsAction(), "SPACE");
    }

    private void attachAction(AbstractAction action, String keyStroke) {
        InputMap im = this.getInputMap(2);
        ActionMap am = this.getActionMap();
        im.put(KeyStroke.getKeyStroke(keyStroke), action.getValue("Name"));
        am.put(action.getValue("Name"), action);
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    private void measure() {
        this.colorCount_ = this.colortable_.getColorCount();
        this.binLoci_ = this.colortable_.hasOutlierColors() ? new Point[this.colorCount_ + 2] : new Point[this.colorCount_];
        this.binsPerRow_ = (int)Math.sqrt(this.colorCount_);
        if (this.binsPerRow_ % 2 > 0) {
            --this.binsPerRow_;
        }
        this.binsPerRow_ = Math.max(16, this.binsPerRow_);
        this.binsPerRow_ = Math.min(50, this.binsPerRow_);
        this.binGap_ = 4;
        this.binInside_ = Math.min(22, 600 / this.binsPerRow_ - this.binGap_ - 2);
        this.binInside_ = Math.max(12, this.binInside_);
        this.binsPerRow_ = 600 / (this.binInside_ + 2 + this.binGap_);
        this.binsPerRow_ = Math.max(16, this.binsPerRow_);
        this.binSize_ = this.binInside_ + 2;
        this.cellSize_ = this.binSize_ + this.binGap_;
        int numRows = this.colorCount_ / this.binsPerRow_;
        if (this.colorCount_ % this.binsPerRow_ > 0) {
            ++numRows;
        }
        Insets ins = this.getInsets();
        int w = Math.max(600, this.binsPerRow_ * this.cellSize_);
        int h = this.colortable_.hasOutlierColors() ? (numRows + 1) * this.cellSize_ + 2 * this.binGap_ : numRows * this.cellSize_ + 2 * this.binGap_ + this.getFont().getSize();
        int extrax = Math.max(0, 600 - this.binsPerRow_ * this.cellSize_) / 2;
        Dimension size = new Dimension(w += ins.left + ins.right, h += ins.top + ins.bottom);
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        this.setMaximumSize(size);
        int bin = 0;
        for (int row = 0; row < numRows; ++row) {
            for (int col = 0; col < this.binsPerRow_ && (bin = row * this.binsPerRow_ + col) < this.colorCount_; ++col) {
                int x = ins.left + extrax + col * this.cellSize_ + this.binGap_ / 2;
                int y = ins.top + row * this.cellSize_ + this.binGap_ / 2;
                if (row == numRows - 1 && this.colorCount_ % this.binsPerRow_ != 0) {
                    x += this.cellSize_ * (this.binsPerRow_ - this.colorCount_ % this.binsPerRow_) / 2;
                }
                this.binLoci_[bin] = new Point(x + 1, y + 1);
            }
            if (bin >= this.colorCount_) break;
        }
        if (this.colortable_.hasOutlierColors()) {
            int xTop = ins.top + numRows * this.cellSize_ + 2 * this.binGap_;
            this.binLoci_[this.colorCount_] = new Point(w / 2 - 12 + 1 - this.binSize_, xTop);
            this.binLoci_[this.colorCount_ + 1] = new Point(w / 2 + 12 + 1, xTop);
        }
    }

    public AbstractColorTable getColorTable() {
        return this.colortable_;
    }

    public void setColorTable(AbstractColorTable cb) {
        this.colortable_ = cb;
        this.measure();
        this.invalidate();
        if (this.getTopLevelAncestor() != null) {
            ((JFrame)this.getTopLevelAncestor()).pack();
        }
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = GraphicUtils.createAntialiasedGfx(g);
        g2d.setFont(this.getFont());
        FontMetrics fm = g2d.getFontMetrics();
        for (int i = 0; i < this.colorCount_; ++i) {
            Color c = this.colortable_.getColorAt(i);
            this.drawBin(g2d, i, c);
            if (!this.binIdsVisible_) continue;
            int lum = (c.getRed() + c.getGreen() + c.getBlue()) / 2;
            if (lum < 142) {
                g2d.setColor(Color.WHITE);
            } else {
                g2d.setColor(Color.BLACK);
            }
            String s = Integer.toString(i + 1);
            GraphicUtils.drawString(g2d, (Object)s, this.binLoci_[i].x + (this.binInside_ - fm.stringWidth(s)) / 2, this.binLoci_[i].y + this.getFont().getSize() + 2);
        }
        g2d.setColor(Color.BLACK);
        if (this.colortable_.hasOutlierColors()) {
            int tTop = this.binLoci_[this.colorCount_].y + (this.binInside_ + fm.getAscent()) / 2;
            GraphicUtils.drawString(g2d, (Object)LT_MIN, this.binLoci_[this.colorCount_].x - 5 - fm.stringWidth(LT_MIN), tTop);
            GraphicUtils.drawString(g2d, (Object)GT_MAX, this.binLoci_[this.colorCount_ + 1].x + this.binInside_ + 5, tTop);
            this.drawBin(g2d, this.colorCount_, this.colortable_.getMinOutlierColor());
            this.drawBin(g2d, this.colorCount_ + 1, this.colortable_.getMaxOutlierColor());
        } else {
            int xTop = this.binLoci_[this.colorCount_ - 1].y + this.cellSize_ + fm.getAscent();
            GraphicUtils.drawString(g2d, (Object)NO_OUTLIERS, (this.getWidth() - fm.stringWidth(NO_OUTLIERS)) / 2, xTop);
        }
        g2d.dispose();
    }

    private void drawBin(Graphics2D g2d, int bin, Color c) {
        if (bin < 0 || bin >= this.binLoci_.length) {
            return;
        }
        Point p = this.binLoci_[bin];
        g2d.setColor(Color.DARK_GRAY);
        g2d.fillRect(p.x - 1, p.y - 1, this.binInside_ + 2, this.binInside_ + 2);
        g2d.setColor(c);
        g2d.fillRect(p.x, p.y, this.binInside_, this.binInside_);
    }

    class ToggleLabelsAction
    extends AbstractAction {
        ToggleLabelsAction() {
            super("toggle bin labels");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColorTableBinPanel.this.binIdsVisible_ = !ColorTableBinPanel.this.binIdsVisible_;
            ColorTableBinPanel.this.repaint();
        }
    }

    private class BinMouseHandler
    extends MouseInputAdapter {
        BinMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ColorTableBinPanel.this.grabFocus();
            ColorTableBinPanel.this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            ColorTableBinPanel.this.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            ColorTableBinPanel.this.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ColorTableBinPanel.this.grabFocus();
            ColorTableBinPanel.this.repaint();
        }
    }
}

