/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.color;

import gov.nasa.giss.ui.color.ColorComboPopupListener;
import gov.nasa.giss.ui.color.PaletteType;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class ColorComboPopup
extends JPopupMenu {
    private static final int BIN_MARGIN = 3;
    private static final Color GRAPHITE_FOCUS_COLOR = new Color(94, 107, 121);
    private static final Color SELECTED_GRADIENT_COLOR_1;
    private static final Color SELECTED_GRADIENT_COLOR_2;
    private static final Color SELECTED_LINE_COLOR_1;
    private static final Color SELECTED_LINE_COLOR_2;
    private ColorComboPopupListener parent_;
    private ColorPanel cpanel_;
    private PaletteType ptype_;
    private Color[] colors_;
    private Color selColor_ = Color.BLACK;
    private int selBin_;
    private int overBin_ = -1;
    private int columns_ = 32;
    private int rows_ = 9;
    private int binCount_ = this.columns_ * this.rows_;
    private int binSize_ = 12;
    private int fullBinSize_ = this.binSize_ + 6;

    public ColorComboPopup(ColorComboPopupListener parent, PaletteType ptype) {
        this.parent_ = parent;
        this.ptype_ = ptype;
        if (this.ptype_ == PaletteType.GRAYSCALE) {
            this.columns_ = 2;
            this.rows_ = 9;
            this.binSize_ = 14;
        } else if (this.ptype_ == PaletteType.BLACK_WHITE) {
            this.columns_ = 2;
            this.rows_ = 1;
            this.binSize_ = 18;
        } else {
            this.columns_ = 32;
            this.rows_ = 9;
            this.binSize_ = 12;
        }
        this.fullBinSize_ = this.binSize_ + 6;
        this.binCount_ = this.columns_ * this.rows_;
        this.colors_ = new Color[this.binCount_];
        this.cpanel_ = new ColorPanel();
        this.add(this.cpanel_);
        Insets ins = this.getInsets();
        int imax = Math.max(Math.max(ins.left, ins.top), Math.max(ins.right, ins.bottom));
        if (imax > 0) {
            Border inner = BorderFactory.createEmptyBorder(imax - ins.top, imax - ins.left, imax - ins.bottom, imax - ins.right);
            Border outer = this.getBorder();
            this.setBorder(BorderFactory.createCompoundBorder(outer, inner));
        }
        this.selBin_ = 0;
        this.selColor_ = this.getColorForBin(0);
        this.setFocusable(false);
        this.addKeyListener(new KeyResponder(1));
    }

    Point getSelectedPoint() {
        Point p = this.cpanel_.getPointForBin(this.selBin_);
        p.x += this.fullBinSize_ / 2;
        p.y += this.fullBinSize_ / 2;
        return p;
    }

    int getItemCount() {
        return this.binCount_;
    }

    int getSelectedIndex() {
        return this.selBin_;
    }

    public void setSelectedIndex(int index) {
        if (index < 0 || index >= this.binCount_) {
            throw new IndexOutOfBoundsException("ColorCombo item index out of range");
        }
        int oldBin = this.selBin_;
        Color oldColor = this.selColor_;
        this.selBin_ = index;
        this.selColor_ = this.getColorForBin(index);
        this.setVisible(false);
        if (this.parent_ != null) {
            this.parent_.colorChanged(oldBin, oldColor, this.selBin_, this.selColor_);
        }
    }

    public Color getSelectedColor() {
        return this.selColor_;
    }

    public void setSelectedColor(Color c) {
        for (int i = 0; i < this.binCount_; ++i) {
            Color bc = this.getColorForBin(i);
            if (!bc.equals(c)) continue;
            this.setSelectedIndex(i);
            return;
        }
    }

    void shiftBin(int keyCode) {
        if (!this.isVisible()) {
            return;
        }
        if ((keyCode == 10 || keyCode == 32) && this.overBin_ >= 0) {
            this.setSelectedIndex(this.overBin_);
        }
        if (keyCode != 40 && keyCode != 38 && keyCode != 37 && keyCode != 39) {
            return;
        }
        if (this.overBin_ < 0) {
            this.overBin_ = keyCode == 40 || keyCode == 39 ? 0 : this.binCount_ - 1;
        } else {
            int current = this.overBin_;
            int row = current / this.columns_;
            int col = current % this.columns_;
            if (keyCode == 40) {
                ++row;
            } else if (keyCode == 38) {
                --row;
            } else {
                col = keyCode == 39 ? ++col : --col;
            }
            if (row < 0) {
                row = 0;
            }
            if (col < 0) {
                col = 0;
            }
            if (row >= this.rows_) {
                row = this.rows_ - 1;
            }
            if (col >= this.columns_) {
                col = this.columns_ - 1;
            }
            this.overBin_ = row * this.columns_ + col;
        }
        this.repaint();
    }

    Color getColorForBin(int bin) {
        if (bin < 0 || bin > this.colors_.length) {
            return null;
        }
        if (this.colors_[bin] != null) {
            return this.colors_[bin];
        }
        int row = bin / this.columns_;
        int col = bin % this.columns_;
        return this.getColorForBin(col, row);
    }

    Color getColorForBin(int col, int row) {
        int bin = row * this.columns_ + col;
        if (this.colors_[bin] != null) {
            return this.colors_[bin];
        }
        if (col == 0) {
            int rgb = row * 16;
            this.colors_[bin] = new Color(rgb, rgb, rgb);
        } else if (col == 1) {
            int rgb = 255 - row * 16;
            this.colors_[bin] = new Color(rgb, rgb, rgb);
        } else {
            int gg = (col - 2) / 5;
            int ggc = (col - 2) % 5;
            int ggp1 = gg + 1;
            int ggr1 = gg < 2 || gg > 4 ? 255 : 0;
            int ggg1 = gg > 0 && gg < 4 ? 255 : 0;
            int ggb1 = gg > 2 ? 255 : 0;
            int ggr2 = ggp1 < 2 || ggp1 > 4 ? 255 : 0;
            int ggg2 = ggp1 > 0 && ggp1 < 4 ? 255 : 0;
            int ggb2 = ggp1 > 2 && ggp1 < 6 ? 255 : 0;
            int ggr1a = ggr1;
            int ggg1a = ggg1;
            int ggb1a = ggb1;
            int ggr2a = ggr2;
            int ggg2a = ggg2;
            int ggb2a = ggb2;
            if (row != 4) {
                ggr1a = Math.max(0, Math.min(255, ggr1 + 51 * (4 - row)));
                ggg1a = Math.max(0, Math.min(255, ggg1 + 51 * (4 - row)));
                ggb1a = Math.max(0, Math.min(255, ggb1 + 51 * (4 - row)));
                ggr2a = Math.max(0, Math.min(255, ggr2 + 51 * (4 - row)));
                ggg2a = Math.max(0, Math.min(255, ggg2 + 51 * (4 - row)));
                ggb2a = Math.max(0, Math.min(255, ggb2 + 51 * (4 - row)));
            }
            int dir = (ggr2a - ggr1a) / 5;
            int dig = (ggg2a - ggg1a) / 5;
            int dib = (ggb2a - ggb1a) / 5;
            int r = ggr1a + ggc * dir;
            int g = ggg1a + ggc * dig;
            int b = ggb1a + ggc * dib;
            this.colors_[bin] = new Color(r, g, b);
        }
        return this.colors_[bin];
    }

    @Override
    public void setVisible(boolean b) {
        this.overBin_ = this.selBin_;
        super.setVisible(b);
    }

    private static void fillSelectionBackground(Graphics g, int x, int y, int width, int height) {
        if (PlatformUtils.isMacintosh()) {
            Graphics2D g2d = (Graphics2D)g;
            GradientPaint paint = new GradientPaint(x + 1, y, SELECTED_GRADIENT_COLOR_1, x + 1, y + height, SELECTED_GRADIENT_COLOR_2);
            g2d.setPaint(paint);
            g2d.fillRect(x, y, width, height);
            g.setColor(SELECTED_LINE_COLOR_1);
            g.drawLine(x, y, x + width - 1, y);
            g.setColor(SELECTED_LINE_COLOR_2);
            g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
        } else {
            Color selBg = UIManager.getColor("PopupMenu.selectionBackground");
            if (selBg == null) {
                selBg = UIManager.getColor("MenuItem.selectionBackground");
            }
            g.setColor(selBg);
            g.fillRect(x, y, width, height);
        }
    }

    static {
        Color focusColor = UIManager.getColor("Focus.color");
        if (focusColor != null && focusColor.equals(GRAPHITE_FOCUS_COLOR)) {
            SELECTED_GRADIENT_COLOR_1 = new Color(129, 136, 143);
            SELECTED_GRADIENT_COLOR_2 = new Color(110, 118, 129);
            SELECTED_LINE_COLOR_1 = new Color(117, 124, 132);
            SELECTED_LINE_COLOR_2 = new Color(93, 103, 114);
        } else {
            SELECTED_GRADIENT_COLOR_1 = new Color(112, 133, 247);
            SELECTED_GRADIENT_COLOR_2 = new Color(67, 88, 244);
            SELECTED_LINE_COLOR_1 = new Color(102, 122, 237);
            SELECTED_LINE_COLOR_2 = new Color(58, 75, 236);
        }
    }

    class KeyResponder
    extends KeyAdapter {
        final int which_;

        KeyResponder(int which) {
            this.which_ = which;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            e.consume();
        }

        @Override
        public void keyReleased(KeyEvent e) {
            e.consume();
        }

        @Override
        public void keyTyped(KeyEvent e) {
            e.consume();
        }
    }

    class ColorPanel
    extends JComponent
    implements MouseListener,
    MouseMotionListener {
        public ColorPanel() {
            this.setBorder(null);
            this.setOpaque(false);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addKeyListener(new KeyResponder(2));
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(ColorComboPopup.this.columns_ * ColorComboPopup.this.fullBinSize_, ColorComboPopup.this.rows_ * ColorComboPopup.this.fullBinSize_);
        }

        @Override
        public void paintComponent(Graphics g) {
            Color fg = UIManager.getColor("PopupMenu.foreground");
            Color selBg = UIManager.getColor("PopupMenu.selectionBackground");
            Color selFg = UIManager.getColor("PopupMenu.selectionForeground");
            if (selBg == null) {
                fg = UIManager.getColor("MenuItem.foreground");
                selBg = UIManager.getColor("MenuItem.selectionBackground");
                selFg = UIManager.getColor("MenuItem.selectionForeground");
            }
            if (ColorComboPopup.this.overBin_ > -1) {
                Point p = this.getPointForBin(ColorComboPopup.this.overBin_);
                ColorComboPopup.fillSelectionBackground(g, p.x, p.y, ColorComboPopup.this.fullBinSize_, ColorComboPopup.this.fullBinSize_);
            }
            for (int i = 0; i < ColorComboPopup.this.binCount_; ++i) {
                Color c = ColorComboPopup.this.getColorForBin(i);
                Point p = this.getPointForBin(i);
                p.x += 3;
                p.y += 3;
                g.setColor(i == ColorComboPopup.this.overBin_ ? selFg : fg);
                g.fillRect(p.x, p.y, ColorComboPopup.this.binSize_, ColorComboPopup.this.binSize_);
                g.setColor(c);
                g.fillRect(p.x + 1, p.y + 1, ColorComboPopup.this.binSize_ - 2, ColorComboPopup.this.binSize_ - 2);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Point p = e.getPoint();
            int bin = this.getBinForPoint(p);
            if (bin > -1) {
                ColorComboPopup.this.setSelectedIndex(bin);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point p = e.getPoint();
            ColorComboPopup.this.overBin_ = this.getBinForPoint(p);
            this.repaint();
        }

        private int getBinForPoint(Point p) {
            for (int iiy = 0; iiy < ColorComboPopup.this.rows_; ++iiy) {
                for (int iix = 0; iix < ColorComboPopup.this.columns_; ++iix) {
                    Point pbin = this.getPointForBin(iix, iiy);
                    if (p.x < pbin.x || p.x > pbin.x + ColorComboPopup.this.fullBinSize_ || p.y < pbin.y || p.y > pbin.y + ColorComboPopup.this.fullBinSize_) continue;
                    return iiy * ColorComboPopup.this.columns_ + iix;
                }
            }
            return -1;
        }

        private Point getPointForBin(int bin) {
            int row = bin / ColorComboPopup.this.columns_;
            int col = bin % ColorComboPopup.this.columns_;
            return this.getPointForBin(col, row);
        }

        private Point getPointForBin(int col, int row) {
            int px = col * ColorComboPopup.this.fullBinSize_;
            int py = row * ColorComboPopup.this.fullBinSize_;
            return new Point(px, py);
        }
    }
}

