/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class ScaledIconComponent
extends JComponent {
    private final ImageIcon icon_;
    private final float scaling_;

    public ScaledIconComponent(ImageIcon icon, float scaling) {
        this.icon_ = icon;
        this.scaling_ = scaling;
    }

    @Override
    public Dimension getPreferredSize() {
        Insets ins = this.getInsets();
        int ww = this.icon_.getIconWidth();
        int hh = this.icon_.getIconHeight();
        return new Dimension((int)((float)ww * this.scaling_) + ins.left + ins.right, (int)((float)hh * this.scaling_) + ins.top + ins.bottom);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g.create();
        Insets ins = this.getInsets();
        g2d.translate(ins.left, ins.top);
        g2d.scale(this.scaling_, this.scaling_);
        this.icon_.paintIcon(this, g2d, 0, 0);
        g2d.dispose();
    }
}

