/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time.mission;

import gov.nasa.giss.time.ClockType;
import gov.nasa.giss.time.JDCalendar;
import gov.nasa.giss.time.UTParser;
import gov.nasa.giss.time.mission.MarsLanderTime;
import gov.nasa.giss.time.mission.MissionStatus;
import gov.nasa.giss.time.planet.MarsTime;
import java.util.Date;

public class MarsPathfinder
extends MarsLanderTime {
    private static final String LAUNCH_STRING = "1996-12-04 06:58:07";
    private static final String SOL1_STRING = "1997-07-04 13:53:16";
    private static final String LANDING_STRING = "1997-07-04 16:56:55";
    private static final double LONPC_FOR_CALCULATION = 326.7555;
    private static long launchMillis_;
    private static long sol1Millis_;
    private static long landingMillis_;

    public MarsPathfinder() {
        super("Mars Pathfinder");
        if (launchMillis_ == 0L) {
            this.initialize();
        }
    }

    public MarsPathfinder(MarsTime marsTime) {
        this();
        this.setPlanetTime(marsTime);
    }

    private void initialize() {
        Date launchDate = UTParser.parse(LAUNCH_STRING);
        Date sol1Date = UTParser.parse(SOL1_STRING);
        Date landingDate = UTParser.parse(LANDING_STRING);
        JDCalendar jdc = new JDCalendar();
        jdc.setTime(launchDate);
        launchMillis_ = jdc.getTimeInMillis();
        jdc.setTime(sol1Date);
        sol1Millis_ = jdc.getTimeInMillis();
        jdc.setTime(landingDate);
        landingMillis_ = jdc.getTimeInMillis();
    }

    @Override
    protected void update() {
        long millis = this.mTime_.getMillis();
        if (millis < launchMillis_) {
            this.status_ = MissionStatus.NOT_LAUNCHED;
            this.sol_ = -1L;
            this.fraction_ = 0.0;
            return;
        }
        double lmstSec = (double)(millis - sol1Millis_) * 0.001 * 0.9732442960905843;
        double lmst = lmstSec * 1.1574074074074073E-5;
        this.sol_ = (long)Math.floor(lmst);
        double lmstFraction = lmst - (double)this.sol_;
        this.fraction_ = this.mTime_.getTimeSolFraction(33.244500000000016, ClockType.TRUE_SOLAR);
        if (this.fraction_ > 0.9166666666666666 && lmstFraction < 0.08333333333333333) {
            --this.sol_;
        } else if (this.fraction_ < 0.08333333333333333 && lmstFraction > 0.9166666666666666) {
            ++this.sol_;
        }
        if (this.sol_ >= 0L) {
            ++this.sol_;
        }
        this.status_ = millis < landingMillis_ ? MissionStatus.IN_FLIGHT : MissionStatus.ACTIVE;
        this.needsUpdate_ = false;
    }
}

