/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time.mission;

import gov.nasa.giss.time.mission.MissionTime;
import gov.nasa.giss.time.planet.AbstractPlanetTime;
import gov.nasa.giss.time.planet.MarsTime;

public abstract class MarsLanderTime
extends MissionTime {
    protected static final double SOL_PER_MARSEC = 1.1574074074074073E-5;
    private boolean externalTime_;
    protected MarsTime mTime_;

    public MarsLanderTime(String name) {
        super(name);
        this.setPlanetTime(null);
    }

    public MarsLanderTime(String name, MarsTime marsTime) {
        super(name);
        this.setPlanetTime(marsTime);
    }

    @Override
    public void setMillis(long millis) {
        if (this.externalTime_) {
            throw new IllegalArgumentException("Cannot set millis for externally set MarsTime object");
        }
        this.mTime_.setMillis(millis);
    }

    @Override
    public void setPlanetTime(AbstractPlanetTime ptime) {
        if (ptime == null) {
            if (this.mTime_ != null) {
                this.mTime_.removeTimeListener(this);
            }
            this.mTime_ = new MarsTime();
            this.externalTime_ = false;
        } else if (ptime instanceof MarsTime) {
            this.mTime_ = (MarsTime)ptime;
            this.externalTime_ = true;
            this.mTime_.addTimeListener(this);
        } else {
            throw new IllegalArgumentException("Must specify a MarsTime object");
        }
        this.needsUpdate_ = true;
    }

    public int getYear() {
        int year = (int)((double)this.sol_ / 668.5991);
        return ++year;
    }

    public int getYearSol() {
        int subtract = (int)(668.5991 * (double)((int)((double)this.sol_ / 668.5991)));
        return (int)(this.sol_ - (long)subtract);
    }
}

