/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.text;

import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class PrintfFormat {
    public static final PrintfFormat PFORMAT_0 = new PrintfFormat("%.0f");
    public static final PrintfFormat PFORMAT_1 = new PrintfFormat("%.1f");
    public static final PrintfFormat PFORMAT_2 = new PrintfFormat("%.2f");
    public static final PrintfFormat PFORMAT_3 = new PrintfFormat("%.3f");
    public static final PrintfFormat PFORMAT_2E = new PrintfFormat("%.2E");
    public static final PrintfFormat PFORMAT_3G = new PrintfFormat("%.3g");
    public static final PrintfFormat PFORMAT_4G = new PrintfFormat("%.4g");
    public static final PrintfFormat PFORMAT_5G = new PrintfFormat("%.5g");
    public static final PrintfFormat PFORMAT_6G = new PrintfFormat("%.6g");
    public static final PrintfFormat PFORMAT_7G = new PrintfFormat("%.7g");
    public static final PrintfFormat PFORMAT_9G = new PrintfFormat("%.9g");
    public static final PrintfFormat PFORMAT_10G = new PrintfFormat("%.10g");
    private Locale locale_;
    private String format_;
    private boolean isSimpleF_;
    private boolean isSimpleG_;
    private char minusChar_;
    private char decimalChar_;
    private String minus0_;
    private String minus0Decimal_;
    private String lcExponentStr_;

    public PrintfFormat(String format) {
        this(Locale.getDefault(), format);
    }

    public PrintfFormat(Locale l, String format) {
        this.locale_ = l;
        this.format_ = format;
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        this.minusChar_ = dfs.getMinusSign();
        this.decimalChar_ = dfs.getDecimalSeparator();
        this.minus0_ = this.minusChar_ + "0";
        this.minus0Decimal_ = this.minus0_ + this.decimalChar_;
        String exponentStr = dfs.getExponentSeparator();
        this.lcExponentStr_ = exponentStr.toLowerCase();
        this.isSimpleF_ = this.format_.matches("%\\d*\\.\\d+f") || this.format_.matches("%\\d*\\.\\d+F");
        this.isSimpleG_ = this.format_.matches("%\\d*\\.\\d+g") || this.format_.matches("%\\d*\\.\\d+G");
    }

    public String getFormat() {
        return this.format_;
    }

    public String sprintf(Object arg) {
        if (this.locale_ != null) {
            return String.format(this.locale_, this.format_, arg);
        }
        return String.format(this.format_, arg);
    }

    public String sprintf(Object ... args) {
        if (this.locale_ != null) {
            return String.format(this.locale_, this.format_, args);
        }
        return String.format(this.format_, args);
    }

    public String sprintfx(Object arg) {
        String sval = this.sprintf(arg);
        if (this.isSimpleG_) {
            sval = this.trimSimpleG(sval);
        } else if (this.isSimpleF_) {
            sval = this.trimSimpleF(sval);
        }
        return sval;
    }

    private String trimSimpleF(String str) {
        String sval = str;
        if (!sval.startsWith(this.minus0_)) {
            return sval;
        }
        if (sval.equals(this.minus0_)) {
            return "0";
        }
        if (sval.startsWith(this.minus0Decimal_)) {
            if (sval.length() > 3) {
                String decimals = sval.substring(3);
                if (decimals.matches("0*")) {
                    return sval.substring(1);
                }
            } else {
                return sval.substring(1);
            }
        }
        return sval;
    }

    private String trimSimpleG(String str) {
        Object sval = str;
        int decimalIndex = ((String)sval).indexOf(this.decimalChar_);
        int expIndex = ((String)sval).toLowerCase().indexOf(this.lcExponentStr_);
        if (decimalIndex < 0) {
            return sval;
        }
        String expString = null;
        if (expIndex > 0) {
            expString = ((String)sval).substring(expIndex);
            sval = ((String)sval).substring(0, expIndex);
        }
        if (((String)sval).endsWith("0")) {
            while (((String)sval).endsWith("00")) {
                sval = ((String)sval).substring(0, ((String)sval).length() - 1);
            }
            if (!((String)sval).endsWith(this.decimalChar_ + "0") && ((String)sval).endsWith("0")) {
                sval = ((String)sval).substring(0, ((String)sval).length() - 1);
            }
        }
        if (expString != null) {
            sval = (String)sval + expString;
        }
        return sval;
    }

    public char getDecimalChar() {
        return this.decimalChar_;
    }
}

