/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.graphics.AbstractColorTable;
import gov.nasa.giss.graphics.ColorTableResourceList;
import gov.nasa.giss.map.OverlayFactory;
import gov.nasa.giss.map.kml.KMLData;
import gov.nasa.giss.map.kml.KMLDataResourceList;
import gov.nasa.giss.map.overlay.MapOverlay;
import gov.nasa.giss.map.overlay.OverlayResourceList;
import gov.nasa.giss.panoply.Panoply;
import gov.nasa.giss.panoply.overlay.PanMaskOverlay;
import gov.nasa.giss.panoply.util.PanProperties;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Object LOCK = new Object();
    private static String userAgent_;
    private static ColorTableResourceList colorTableSet_;
    private static OverlayResourceList overlaySet_;
    private static KMLDataResourceList kmlSet_;

    public static void initMiscProperties() {
        System.setProperty("awt.useSystemAAFontSettings", "lcd");
        System.setProperty("sun.java2d.cmm", "sun.java2d.cmm.kcms.KcmsServiceProvider");
        System.setProperty("http.agent", PanUtils.getUserAgent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUserAgent() {
        Object object = LOCK;
        synchronized (object) {
            if (userAgent_ == null) {
                StringBuilder sb = new StringBuilder("Panoply/").append(PanProperties.VERSION_PROPS.getString("version")).append(" (").append(System.getProperty("os.name")).append(" ").append(System.getProperty("os.version")).append("; ").append("Java ").append(System.getProperty("java.version")).append(")");
                userAgent_ = sb.toString();
            }
            return userAgent_;
        }
    }

    public static String getDefaultColorTableName() {
        return "panoply.act";
    }

    public static AbstractColorTable getDefaultColorTable() {
        return PanUtils.getColorTable(PanUtils.getDefaultColorTableName());
    }

    public static AbstractColorTable getColorTable(String name) {
        return (AbstractColorTable)PanUtils.getColorTableResourceList().getBackingObject(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ColorTableResourceList getColorTableResourceList() {
        Object object = LOCK;
        synchronized (object) {
            if (colorTableSet_ == null) {
                colorTableSet_ = new ColorTableResourceList();
                colorTableSet_.scanJarDirectory(Panoply.class, "resources/colorbars");
            }
            return colorTableSet_;
        }
    }

    public static String getDefaultOverlayName() {
        return "Earth.cno";
    }

    public static MapOverlay getDefaultOverlay() {
        return PanUtils.getOverlay(PanUtils.getDefaultOverlayName());
    }

    public static MapOverlay getOverlay(String name) {
        if (name == null) {
            LOGGER.trace("name is null");
            return null;
        }
        if ("none".equalsIgnoreCase(name) || "<null>".equalsIgnoreCase(name) || "".equals(name)) {
            return null;
        }
        return (MapOverlay)PanUtils.getOverlayResourceList().getBackingObject(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OverlayResourceList getOverlayResourceList() {
        Object object = LOCK;
        synchronized (object) {
            if (overlaySet_ == null) {
                OverlayFactory.registerOverlayExt("gif", PanMaskOverlay.class);
                OverlayFactory.registerOverlayExt("png", PanMaskOverlay.class);
                overlaySet_ = new OverlayResourceList();
                overlaySet_.scanJarDirectory(Panoply.class, "resources/overlays");
            }
            return overlaySet_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KMLDataResourceList getUnderlayResourceList() {
        Object object = LOCK;
        synchronized (object) {
            if (kmlSet_ == null) {
                kmlSet_ = new KMLDataResourceList();
                kmlSet_.scanJarDirectory(Panoply.class, "resources/underlays");
            }
            return kmlSet_;
        }
    }

    public static KMLData getUnderlay(String name) {
        if (name == null) {
            LOGGER.trace("name is null");
            return null;
        }
        if ("none".equalsIgnoreCase(name) || "<null>".equalsIgnoreCase(name) || "".equals(name)) {
            return null;
        }
        if (kmlSet_ == null) {
            PanUtils.getUnderlayResourceList();
        }
        return (KMLData)kmlSet_.getBackingObject(name);
    }

    private PanUtils() {
    }
}

