/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.text.PrintfFormat;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.lang.invoke.MethodHandles;
import java.text.AttributedString;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanStringUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static AttributedString convertENotationToSuperscript(String numstr, Graphics2D g2d) {
        return PanStringUtils.convertENotationToSuperscript(numstr, g2d.getFont());
    }

    public static AttributedString convertENotationToSuperscript(String numstr, Font font) {
        Object outstr;
        Objects.requireNonNull(numstr, "Numeric string cannot be null.");
        if (numstr.length() < 1) {
            return new AttributedString("");
        }
        boolean negExp = false;
        int eindex = numstr.indexOf("E+");
        if (eindex < 0) {
            eindex = numstr.indexOf("e+");
        }
        if (eindex < 0) {
            eindex = numstr.indexOf("E-");
            negExp = true;
        }
        if (eindex < 0) {
            eindex = numstr.indexOf("e-");
            negExp = true;
        }
        int superBegins = -1;
        if (eindex < 0) {
            outstr = numstr;
            superBegins = -1;
        } else {
            String numstr1 = numstr.substring(0, eindex);
            String numstr2 = numstr.substring(eindex + 2);
            if (numstr2.charAt(0) == '0') {
                numstr2 = numstr2.substring(1);
            }
            if ("0".equals(numstr2) || "".equals(numstr2)) {
                outstr = numstr1;
                superBegins = -1;
            } else if (negExp) {
                outstr = numstr1 + "\u00d710-" + numstr2;
                superBegins = numstr1.length() + 3;
            } else if ("1".equals(numstr2)) {
                outstr = numstr1 + "\u00d710";
                superBegins = -1;
            } else {
                outstr = numstr1 + "\u00d710" + numstr2;
                superBegins = numstr1.length() + 3;
            }
        }
        if (((String)outstr).indexOf("1\u00d7") == 0) {
            outstr = ((String)outstr).substring(2);
            superBegins -= 2;
        }
        AttributedString astr = new AttributedString((String)outstr);
        astr.addAttribute(TextAttribute.FAMILY, font.getFontName());
        astr.addAttribute(TextAttribute.SIZE, Float.valueOf(font.getSize2D()));
        if (superBegins > 0) {
            astr.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER, superBegins, ((String)outstr).length());
        }
        return astr;
    }

    public static AttributedString convertCaretNotationToSuperscript(String str, Graphics2D g2d) {
        return PanStringUtils.convertCaretNotationToSuperscript(str, g2d.getFont());
    }

    public static AttributedString convertCaretNotationToSuperscript(String str, Font font) {
        Object outstr;
        Objects.requireNonNull(str, "String cannot be null.");
        if (str.length() < 1) {
            return new AttributedString("");
        }
        int eindex = str.indexOf("^");
        int superBegins = -1;
        int superLength = -1;
        if (eindex < 0) {
            outstr = str;
            superBegins = -1;
        } else {
            String str2;
            boolean negExp = false;
            if (str.indexOf("^-") == eindex) {
                negExp = true;
            }
            String str1 = str.substring(0, eindex);
            String string = str2 = negExp ? str.substring(eindex + 2) : str.substring(eindex + 1);
            if (str2.matches("\\d\\d\\d.*")) {
                superLength = 3;
            } else if (str2.matches("\\d\\d.*")) {
                superLength = 2;
            } else if (str2.matches("\\d.*")) {
                superLength = 1;
            }
            if (superLength > 0) {
                superBegins = eindex;
                if (negExp) {
                    outstr = str1 + "-" + str2;
                    ++superLength;
                } else {
                    outstr = str1 + str2;
                }
            } else {
                outstr = str;
                superBegins = -1;
                superLength = -1;
            }
        }
        AttributedString astr = new AttributedString((String)outstr);
        astr.addAttribute(TextAttribute.FAMILY, font.getFontName());
        astr.addAttribute(TextAttribute.SIZE, Float.valueOf(font.getSize2D()));
        if (superBegins > 0 && superLength > 0) {
            astr.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER, superBegins, superBegins + superLength);
        }
        return astr;
    }

    public static AttributedString getSuperscriptedE(double power, Graphics2D g2d) {
        return PanStringUtils.getSuperscriptedE(power, g2d.getFont());
    }

    public static AttributedString getSuperscriptedE(double power, Font font) {
        String expo = PrintfFormat.PFORMAT_7G.sprintfx(power);
        if (expo.endsWith(".0") || expo.endsWith(",0")) {
            expo = expo.substring(0, expo.length() - 2);
        }
        if ("0".equals(expo)) {
            return new AttributedString("1");
        }
        if ("1".equals(expo)) {
            return new AttributedString("\u212f");
        }
        Object estr = "\u212f" + expo;
        estr = ((String)estr).replaceAll("\\b", "");
        AttributedString astr = new AttributedString((String)estr);
        int strLen = ((String)estr).length();
        if (strLen > 1) {
            astr.addAttribute(TextAttribute.FAMILY, font.getFontName());
            astr.addAttribute(TextAttribute.SIZE, Float.valueOf(font.getSize2D()));
            astr.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER, 1, strLen);
        }
        return astr;
    }

    private PanStringUtils() {
    }
}

