/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.util.DescribedItem;

public enum PanPlotOutputFormat implements DescribedItem
{
    GIF("GIF"),
    JPEG("JPEG", "JPG"),
    PDF("PDF"),
    PNG("PNG"),
    PS("PS"),
    TIFF("TIFF", "TIF");

    private String[] extensions_;

    private PanPlotOutputFormat(String ... extensions) {
        this.extensions_ = extensions;
    }

    @Override
    public String getDescription() {
        return this.name();
    }

    public String toString() {
        return this.name();
    }

    @Override
    public boolean matches(String text) {
        for (int i = 0; i < this.extensions_.length; ++i) {
            if (!this.extensions_[i].equalsIgnoreCase(text)) continue;
            return true;
        }
        return false;
    }

    public static PanPlotOutputFormat matching(String str) {
        for (PanPlotOutputFormat value : PanPlotOutputFormat.values()) {
            if (!value.matches(str)) continue;
            return value;
        }
        return null;
    }
}

