/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.io.FileUtils;
import gov.nasa.giss.panoply.Panoply;
import gov.nasa.giss.panoply.util.PanDevoMode;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanLoggingUtils {
    private static final String LOG_FILE = "panoply.log";
    private static boolean initted_;
    private static PrintStream loggerps_;

    public static void initLogging() {
        boolean useLogfile = PanDevoMode.isUsingLogfile();
        PanLoggingUtils.initLogging(useLogfile);
    }

    public static void initLogging(boolean useLogfile) {
        block18: {
            if (initted_) {
                PanLoggingUtils.getClassLogger().warn("Logging previously initialized.");
                return;
            }
            try (InputStream is = Panoply.class.getResourceAsStream("resources/logging.properties");){
                if (is == null) {
                    throw new RuntimeException("Got null loading logging.properties");
                }
                LogManager.getLogManager().readConfiguration(is);
            }
            catch (Exception exc) {
                System.err.println("initLogging - Error reading logging properties.");
                Logger logger = PanLoggingUtils.getClassLogger();
                logger.error("Error reading logging properties.");
                if (!logger.isTraceEnabled()) break block18;
                exc.printStackTrace();
            }
        }
        PanLoggingUtils.getClassLogger().info("Use logfile {}", (Object)useLogfile);
        if (useLogfile) {
            PanLoggingUtils.redirectToLogfile();
            PanLoggingUtils.getClassLogger().info("All subsequent log msgs should be written to logfile.");
        } else {
            PanLoggingUtils.getClassLogger().info("Logging to Console");
        }
        initted_ = true;
    }

    public static void redirectToLogfile() {
        Logger logger = PanLoggingUtils.getClassLogger();
        logger.info("REDIRECTING!");
        File logsDir = FileUtils.getGISSLogsDirectory();
        try {
            if (!logsDir.exists()) {
                logger.info("Creating logs directory");
                logsDir.mkdirs();
            }
        }
        catch (Exception exc) {
            logger.warn("Logging dir {} could not be created.", (Object)logsDir.getPath());
            logger.warn("Exception reported was: {}", (Object)exc.toString());
            logger.warn("Logging will continue on STDOUT/STDERR.");
            return;
        }
        File ff = new File(logsDir, LOG_FILE);
        logger.info("Logfile is located at {}", (Object)ff);
        try {
            logger.info("Setting up and redirecting to logfile PrintStream");
            loggerps_ = new PrintStream(ff);
            System.setOut(loggerps_);
            System.setErr(loggerps_);
        }
        catch (Exception exc) {
            logger.warn("Could not redirect STDOUT/STDERR to log file: {}", (Object)ff);
            logger.warn("Exception reported was: {}", (Object)exc.toString());
            logger.warn("Logging will continue on STDOUT/STDERR.");
            return;
        }
    }

    public static void closeLogfile() {
        if (loggerps_ == null) {
            return;
        }
        Logger logger = PanLoggingUtils.getClassLogger();
        try {
            loggerps_.close();
            loggerps_ = null;
        }
        catch (Exception exc) {
            logger.warn("Failed to close custom log PrintStream.");
        }
    }

    public static void setLogLevel(String level) {
        String[] pkgnames;
        Objects.requireNonNull(level, "Log level cannot be null.");
        Logger logger = PanLoggingUtils.getClassLogger();
        logger.trace("level '{}'", (Object)level);
        if (level.isEmpty()) {
            logger.info("Passed logging level is empty; no change will be made,");
            return;
        }
        logger.info("Attempting to change log level to {}", (Object)level);
        for (String pkgname : pkgnames = new String[]{"gov.nasa.giss.panoply", "gov.nasa.giss.data.nc"}) {
            java.util.logging.Logger pkglogger = java.util.logging.Logger.getLogger(pkgname);
            try {
                Level newLevel = Level.parse(level.toUpperCase());
                pkglogger.setLevel(newLevel);
                logger.info("Changed {} log level to {}", (Object)pkgname, (Object)newLevel);
            }
            catch (Exception exc) {
                logger.warn("Setting {} log level {} failed.", (Object)pkgname, (Object)level);
            }
        }
    }

    private static Logger getClassLogger() {
        return LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    }

    private PanLoggingUtils() {
    }
}

