/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.ui;

import gov.nasa.giss.panoply.ui.PanGuiSize;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.util.PanDevoMode;
import gov.nasa.giss.panoply.util.PanScaleMethod;
import javax.swing.JComboBox;

public final class PanScaleMethodComboBox
extends JComboBox<PanScaleMethod> {
    private PanScaleMethodComboBox(PanGuiSize size, String name) {
        this.addItem(PanScaleMethod.SCALAR);
        this.addItem(PanScaleMethod.LOG10);
        if (PanDevoMode.isLogEScaleEnabled()) {
            this.addItem(PanScaleMethod.LOG_E);
        }
        if (name != null) {
            this.setName(name);
        }
        PanGuiUtils.applyComboBoxUI(size, this);
    }

    public static PanScaleMethodComboBox create(String name) {
        return new PanScaleMethodComboBox(PanGuiSize.REGULAR, name);
    }

    public static PanScaleMethodComboBox small(String name) {
        return new PanScaleMethodComboBox(PanGuiSize.SMALL, name);
    }

    public PanScaleMethod getSelectedMethod() {
        int idx = this.getSelectedIndex();
        return (PanScaleMethod)this.getItemAt(idx);
    }

    public String getStringValue() {
        int idx = this.getSelectedIndex();
        PanScaleMethod item = (PanScaleMethod)this.getItemAt(idx);
        return item.name();
    }

    public void setSelectedItem(String s) {
        int isize = this.getItemCount();
        for (int i = 0; i < isize; ++i) {
            PanScaleMethod pam = (PanScaleMethod)this.getItemAt(i);
            if (!pam.matches(s)) continue;
            this.setSelectedIndex(i);
            break;
        }
    }
}

