/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.ui;

import gov.nasa.giss.panoply.prefs.PanFavoritesEvent;
import gov.nasa.giss.panoply.prefs.PanFavoritesListener;
import gov.nasa.giss.panoply.prefs.PanProjectionInfo;
import gov.nasa.giss.panoply.prefs.PanProjectionPrefs;
import gov.nasa.giss.panoply.ui.PanGuiSize;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import javax.swing.JComboBox;

public final class PanProjectionComboBox
extends JComboBox<String>
implements PanFavoritesListener {
    private final boolean hiliteFaves_;
    private boolean refreshing_;

    private PanProjectionComboBox(PanGuiSize size, String name, boolean hiliteFaves) {
        this.hiliteFaves_ = hiliteFaves;
        this.refresh();
        if (name != null) {
            this.setName(name);
        }
        PanGuiUtils.applyComboBoxUI(size, this);
        PanProjectionPrefs pprefs = PanProjectionPrefs.getSharedInstance();
        pprefs.addFavoritesListener(this);
    }

    public boolean isRefreshing() {
        return this.refreshing_;
    }

    public void refresh() {
        PanProjectionInfo[] piArray;
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        String selName = (String)this.getSelectedItem();
        boolean selFound = false;
        this.removeAllItems();
        PanProjectionPrefs pprefs = PanProjectionPrefs.getSharedInstance();
        for (PanProjectionInfo projInfo : piArray = pprefs.getInfoArray()) {
            if (this.hiliteFaves_ && !projInfo.isFavorite()) continue;
            String newItem = projInfo.getName();
            this.addItem(newItem);
            if (selName == null || !newItem.equals(selName)) continue;
            this.setSelectedItem(newItem);
            selFound = true;
        }
        if (selFound) {
            this.setSelectedItem(selName);
            this.refreshing_ = false;
            return;
        }
        this.refreshing_ = false;
        this.setSelectedItem("Equirectangular");
    }

    @Override
    public void statusChanged(PanFavoritesEvent e) {
        this.refresh();
    }

    public static PanProjectionComboBox create(String name, boolean hiliteFaves) {
        return new PanProjectionComboBox(PanGuiSize.REGULAR, name, hiliteFaves);
    }

    public static PanProjectionComboBox small(String name, boolean hiliteFaves) {
        return new PanProjectionComboBox(PanGuiSize.SMALL, name, hiliteFaves);
    }
}

