/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.ui;

import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.ui.PanGuiSize;
import gov.nasa.giss.panoply.ui.PanStringComboBox;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.plaf.GissComboBoxUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public final class PanGuiUtils {
    public static final int STD_MARGIN = 8;
    public static final int STD_SPACING = 4;
    public static final int STD_GAP = 2;
    public static final int GUTTER_GAP = 12;
    public static final Color FOCUS_COLOR = new Color(173, 173, 173);
    private static final int FOCUS_THICKNESS = 1;
    public static final Border NO_BORDER = BorderFactory.createEmptyBorder();
    public static final Border STD_BORDER = BorderFactory.createEmptyBorder(8, 8, 8, 8);
    public static final Border STD2_BORDER = BorderFactory.createEmptyBorder(16, 16, 16, 16);
    public static final Border THIN_UNFOCUSED_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    public static final Border THIN_FOCUSED_BORDER = BorderFactory.createLineBorder(FOCUS_COLOR, 1);
    public static final Border PADDED_UNFOCUSED_BORDER = STD_BORDER;
    public static final Border PADDED_FOCUSED_BORDER = new CompoundBorder(THIN_FOCUSED_BORDER, BorderFactory.createEmptyBorder(7, 7, 7, 7));
    public static final Border SIMPLE_OUTLINE_BORDER = new CompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), new CompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
    public static final Border DEBUG_BORDER = BorderFactory.createLineBorder(Color.RED, 1);

    public static Component gutterGap() {
        return Box.createHorizontalStrut(12);
    }

    public static void setSizeVariant(PanGuiSize size, JComponent jc) {
        jc.setOpaque(false);
        for (Component c : jc.getComponents()) {
            if (!(c instanceof JComponent)) continue;
            PanGuiUtils.setSizeVariant(size, (JComponent)c);
        }
        if (size == PanGuiSize.SMALL) {
            GuiUtils.setSizeSmall(jc);
        } else if (size == PanGuiSize.REGULAR) {
            GuiUtils.setSizeRegular(jc);
        }
    }

    public static void setSizeSmall(JComponent jc) {
        jc.setOpaque(false);
        for (Component c : jc.getComponents()) {
            if (!(c instanceof JComponent)) continue;
            PanGuiUtils.setSizeSmall((JComponent)c);
        }
        GuiUtils.setSizeSmall(jc);
    }

    public static void setSizeRegular(JComponent jc) {
        jc.setOpaque(false);
        for (Component c : jc.getComponents()) {
            if (!(c instanceof JComponent)) continue;
            PanGuiUtils.setSizeRegular((JComponent)c);
        }
    }

    public static void applyComboBoxUI(PanGuiSize size, JComboBox<?> jcb) {
        jcb.setPreferredSize(null);
        if (size == PanGuiSize.SMALL) {
            PanGuiUtils.setSizeSmall(jcb);
        } else if (size == PanGuiSize.REGULAR) {
            PanGuiUtils.setSizeRegular(jcb);
        }
        jcb.setUI(new GissComboBoxUI());
    }

    public static void setMaxWidth(PanStringComboBox jcb, int width) {
        Dimension minsize = jcb.getPreferredSize();
        Dimension prefsize = jcb.getPreferredSize();
        if (prefsize.width > width) {
            prefsize.width = width;
            jcb.setPreferredSize(prefsize);
            jcb.setMaximumSize(prefsize);
        }
        if (minsize.width > width) {
            minsize.width = width;
            jcb.setMinimumSize(minsize);
        }
    }

    public static PanPlotFrame[] getPlotFrames() {
        ArrayList<PanPlotFrame> fList = new ArrayList<PanPlotFrame>(20);
        for (Frame frame : Frame.getFrames()) {
            if (!(frame instanceof PanPlotFrame) || !frame.isVisible()) continue;
            fList.add((PanPlotFrame)frame);
        }
        fList.sort((frame1, frame2) -> frame1.getTitle().compareTo(frame2.getTitle()));
        return fList.toArray(new PanPlotFrame[0]);
    }

    public static PanPlotFrame[] getListOf2DFrames() {
        ArrayList<PanPlotFrame> fList = new ArrayList<PanPlotFrame>(20);
        for (Frame frame : Frame.getFrames()) {
            PanPlotType ptype;
            if (!(frame instanceof PanPlotFrame) && !frame.isVisible() || (ptype = ((PanPlotFrame)frame).getMeta().getType()).isLinePlot()) continue;
            fList.add((PanPlotFrame)frame);
        }
        fList.sort((frame1, frame2) -> frame1.getTitle().compareTo(frame2.getTitle()));
        return fList.toArray(new PanPlotFrame[0]);
    }

    public static int countVisibleFrames() {
        int count = 0;
        for (Frame f : Frame.getFrames()) {
            if (!(f instanceof PanPlotFrame) || !f.isVisible()) continue;
            ++count;
        }
        return count;
    }

    private PanGuiUtils() {
    }
}

