/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.ui;

import gov.nasa.giss.panoply.ui.PanGuiSize;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.util.PanGridSpacing;
import javax.swing.JComboBox;

public final class PanGridSpacingComboBox
extends JComboBox<PanGridSpacing> {
    private static final PanGridSpacing NONE = new PanGridSpacing(0.0f);
    private static final PanGridSpacing[] CHOICES = new PanGridSpacing[]{NONE, new PanGridSpacing(90.0f), new PanGridSpacing(60.0f), new PanGridSpacing(45.0f), new PanGridSpacing(30.0f), new PanGridSpacing(20.0f), new PanGridSpacing(15.0f), new PanGridSpacing(10.0f), new PanGridSpacing(8.0f), new PanGridSpacing(6.0f), new PanGridSpacing(5.0f), new PanGridSpacing(4.0f), new PanGridSpacing(3.0f), new PanGridSpacing(2.5f), new PanGridSpacing(2.0f), new PanGridSpacing(1.0f), new PanGridSpacing(0.6666667f), new PanGridSpacing(0.5f), new PanGridSpacing(0.3333333f), new PanGridSpacing(0.25f), new PanGridSpacing(0.2f), new PanGridSpacing(0.1f)};

    private PanGridSpacingComboBox(PanGuiSize size, String name) {
        super(CHOICES);
        if (name != null) {
            this.setName(name);
        }
        PanGuiUtils.applyComboBoxUI(size, this);
    }

    public static PanGridSpacingComboBox create(String name) {
        return new PanGridSpacingComboBox(PanGuiSize.REGULAR, name);
    }

    public static PanGridSpacingComboBox small(String name) {
        return new PanGridSpacingComboBox(PanGuiSize.SMALL, name);
    }

    @Override
    public void setSelectedItem(Object item) {
        PanGridSpacing gs;
        int i;
        if (item == null) {
            super.setSelectedItem(NONE);
            return;
        }
        if (item instanceof PanGridSpacing) {
            super.setSelectedItem(item);
            return;
        }
        int isize = this.getItemCount();
        if (item instanceof Float) {
            float d = ((Float)item).floatValue();
            for (i = 0; i < isize; ++i) {
                gs = (PanGridSpacing)this.getItemAt(i);
                if (!((double)Math.abs(gs.getValue() - d) < 1.0E-5)) continue;
                super.setSelectedItem(gs);
                return;
            }
        }
        String s = item.toString();
        for (i = 0; i < isize; ++i) {
            gs = (PanGridSpacing)this.getItemAt(i);
            if (!gs.toString().equals(s)) continue;
            super.setSelectedItem(gs);
            return;
        }
    }

    public void setSelectedItem(float spacing) {
        this.setSpacing(spacing);
    }

    public void setSpacing(float spacing) {
        if (spacing <= 0.0f) {
            super.setSelectedItem(NONE);
            return;
        }
        this.setSelectedItem(Float.valueOf(spacing));
    }

    public float getSpacing() {
        PanGridSpacing gs = (PanGridSpacing)this.getItemAt(this.getSelectedIndex());
        return gs.getValue();
    }
}

