/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.ui;

import gov.nasa.giss.panoply.ui.PanGuiSize;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.ui.color.ColorCombo;
import gov.nasa.giss.ui.color.PaletteType;

public final class PanColorComboBox
extends ColorCombo {
    private PanColorComboBox(PanGuiSize size, String name, PaletteType ptype) {
        super(ptype);
        if (name != null) {
            this.setName(name);
        }
        PanGuiUtils.setSizeVariant(size, this);
    }

    public static PanColorComboBox create(PaletteType ptype) {
        return new PanColorComboBox(PanGuiSize.REGULAR, null, ptype);
    }

    public static PanColorComboBox create(String name, PaletteType ptype) {
        return new PanColorComboBox(PanGuiSize.REGULAR, name, ptype);
    }

    public static PanColorComboBox small(String name, PaletteType ptype) {
        return new PanColorComboBox(PanGuiSize.SMALL, name, ptype);
    }

    public static PanColorComboBox small(PaletteType ptype) {
        return new PanColorComboBox(PanGuiSize.SMALL, null, ptype);
    }

    public static PanColorComboBox createRainbow(String name) {
        return new PanColorComboBox(PanGuiSize.REGULAR, name, PaletteType.RAINBOW);
    }

    public static PanColorComboBox smallRainbow(String name) {
        return new PanColorComboBox(PanGuiSize.SMALL, name, PaletteType.RAINBOW);
    }

    public static PanColorComboBox createGrayscale(String name) {
        return new PanColorComboBox(PanGuiSize.REGULAR, name, PaletteType.GRAYSCALE);
    }

    public static PanColorComboBox smallGrayscale(String name) {
        return new PanColorComboBox(PanGuiSize.SMALL, name, PaletteType.GRAYSCALE);
    }
}

