/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.sources;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcDataNode;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcVarClass;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.panoply.action.PanCombinePlotAction;
import gov.nasa.giss.panoply.action.PanCreatePlotAction;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.prefs.PanHistoryList;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.sources.PanDnVPopup;
import gov.nasa.giss.panoply.sources.PanDnVTreeTablePanel;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.sources.PanSourcesPanel;
import gov.nasa.giss.panoply.ui.PanEnumComboBox;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.util.PanActionHash;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.event.TreeTableEvent;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanDnVPanel
extends PanSourcesPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanEnumComboBox varClassCombo_;
    protected PanDnVPopup popup_;
    private boolean enhancedMode_;
    private NcDataNode oldNode_;

    public PanDnVPanel(PanSourcesFrame parent) {
        super(parent, true);
        PanPreferences prefs = PanPreferences.getSharedInstance();
        prefs.setBoolean("sources:info.enhanced", this.enhancedMode_);
    }

    @Override
    protected JComponent makeTreeHolder() {
        PanPreferences prefs = PanPreferences.getSharedInstance();
        this.ttPanel_ = new PanDnVTreeTablePanel();
        this.ttPanel_.setOpaque(true);
        this.ttPanel_.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, Color.GRAY));
        PanLabel showLabel = PanLabel.small("Show:\u2009");
        this.varClassCombo_ = PanEnumComboBox.small(NcVarClass.class);
        this.varClassCombo_.setSelectedItem(prefs.getString("sources:datasets.varclass"));
        QuickBox vlBox = QuickBox.createCenterBox(showLabel, this.varClassCombo_);
        int h = vlBox.getPreferredSize().height;
        vlBox.setMaximumSize(new Dimension(32000, h));
        QuickBox ttBox = QuickBox.createVerticalBox(this.ttPanel_, Box.createVerticalStrut(2), vlBox);
        ttBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        ttBox.setOpaque(false);
        this.ttPanel_.addTreeTableListener(this);
        this.varClassCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            NcVarClass psv = (NcVarClass)this.varClassCombo_.getSelectedItem();
            this.setVisibleVarClass(psv);
            GuiUtils.refreshFrontFrameMenuBar();
        });
        return ttBox;
    }

    public void setVisibleVarClass(NcVarClass vclass) {
        PanPreferences prefs = PanPreferences.getSharedInstance();
        prefs.set("sources:datasets.varclass", vclass.name());
        PanDnVTreeTablePanel sttp = (PanDnVTreeTablePanel)this.ttPanel_;
        sttp.setVisibleVarClass(vclass);
        this.refreshActions();
        this.refreshInfoPane();
    }

    public void clearPopup() {
        if (this.popup_ != null) {
            this.popup_.setVisible(false);
        }
    }

    public boolean isDatasetOpen() {
        return this.ttPanel_.getModel().getRowCount() > 0;
    }

    @Override
    synchronized void refreshActions() {
        PanPreferences prefs = PanPreferences.getSharedInstance();
        if (this.ttPanel_ != null) {
            ((PanDnVTreeTablePanel)this.ttPanel_).setExpandNewNodes(prefs.getBoolean("sources:nodes.expanded"));
        }
        this.varClassCombo_.setSelectedItem(prefs.getString("sources:datasets.varclass"));
        if (GuiUtils.getParentFrame(this) == null) {
            return;
        }
        PanActionHash actionHash = this.parent_.getActionHash();
        actionHash.disableAll();
        actionHash.setEnabled("toggle-info", true);
        if (this.isDatasetOpen()) {
            actionHash.setEnabled("remove-all", !this.areAllDatasetsInUse());
            actionHash.setEnabled("find", true);
            actionHash.setEnabled("find-next", true);
        } else {
            actionHash.setEnabled("find", this.isFindVisible());
        }
        TreeTableNode node = this.getSelectedNode();
        if (node != null) {
            if (node instanceof NcDataset) {
                actionHash.setEnabled("remove-one", !this.isDatasetInUse((NcDataset)node));
                actionHash.setEnabled("export-cdl", true);
                actionHash.setEnabled("add-bookmark", true);
            } else if (node instanceof NcVariable) {
                NcVariable ncv = (NcVariable)node;
                actionHash.setEnabled("export-cdl", true);
                actionHash.setEnabled("export-csv", true);
                actionHash.setEnabled("export-text", true);
                if (ncv.isGriddable()) {
                    PanCreatePlotAction a = (PanCreatePlotAction)actionHash.get("create-plot");
                    boolean enabled = !a.isBusy() && PanGuiUtils.countVisibleFrames() < 8;
                    actionHash.setEnabled("create-plot", enabled);
                }
                PanPlotFrame[] plotFrames = PanGuiUtils.getPlotFrames();
                PanCombinePlotAction a = (PanCombinePlotAction)actionHash.get("combine-plot");
                boolean enabled = plotFrames.length > 0 && !a.isBusy();
                actionHash.setEnabled("combine-plot", enabled);
            }
        }
    }

    @Override
    protected void refreshInfoPane() {
        TreeTableNode node = this.getSelectedNode();
        if (node == null) {
            this.infoPane_.setContentType("text/plain");
            this.infoPane_.setText("");
            this.oldNode_ = null;
        } else if (node != this.oldNode_) {
            String newText = ((NcDataNode)node).getDetail(this.enhancedMode_);
            if (newText == null) {
                this.infoPane_.setContentType("text/plain");
                this.infoPane_.setText("");
            } else {
                String newType = ((NcDataNode)node).getDetailType();
                this.infoPane_.setContentType(newType);
                this.infoPane_.setText(newText);
                this.infoPane_.setCaretPosition(0);
            }
            this.oldNode_ = (NcDataNode)node;
        }
    }

    @Override
    public void clear() {
        for (Object o : ((PanDnVTreeTablePanel)this.ttPanel_).getDatasets()) {
            if (!(o instanceof NcDataset)) continue;
            this.removeNode((NcDataNode)o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDatasetCount() {
        PanDnVPanel panDnVPanel = this;
        synchronized (panDnVPanel) {
            return ((PanDnVTreeTablePanel)this.ttPanel_).getDatasetCount();
        }
    }

    public NcDataset addDataset(NcDataset ncd) throws IOException {
        if (ncd == null) {
            return null;
        }
        PanDnVTreeTablePanel sttp = (PanDnVTreeTablePanel)this.ttPanel_;
        sttp.addDataset(ncd);
        return ncd;
    }

    @Override
    public void removeNode(TreeTableNode node) {
        if (node == null) {
            return;
        }
        if (!(node instanceof NcDataset)) {
            throw new IllegalArgumentException("I can only remove an NcDataset");
        }
        NcDataset ncd = (NcDataset)node;
        if (!this.isDatasetInUse(ncd)) {
            try {
                ncd.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((PanDnVTreeTablePanel)this.ttPanel_).removeDataset(ncd);
        }
        this.refreshActions();
        this.refreshInfoPane();
    }

    private boolean isDatasetInUse(NcDataset ncd) {
        for (PanPlotFrame pframe : PanGuiUtils.getPlotFrames()) {
            for (NcArray array : pframe.getData().getArrays()) {
                if (array == null || array.getDataset() != ncd) continue;
                return true;
            }
        }
        return false;
    }

    private boolean areAllDatasetsInUse() {
        Object[] nodes = ((PanDnVTreeTablePanel)this.ttPanel_).getDatasets();
        if (nodes.length == 0) {
            return true;
        }
        for (Object o : nodes) {
            if (!(o instanceof NcDataset) || this.isDatasetInUse((NcDataset)o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void selectionMade(TreeTableEvent e) {
        this.refreshActions();
        this.refreshInfoPane();
        NcDataNode node = (NcDataNode)e.getNode();
        if (node == null) {
            return;
        }
        int id = e.getID();
        Point pt = e.getPoint();
        if (id == 102 && node instanceof NcVariable) {
            PanActionHash actionHash = this.parent_.getActionHash();
            ((Action)actionHash.get("create-plot")).actionPerformed(null);
        } else if (id == 103 && pt != null) {
            if (this.popup_ == null) {
                this.popup_ = new PanDnVPopup(this.parent_);
            }
            this.popup_.refresh(node);
            this.popup_.show(this.ttPanel_, pt.x, pt.y);
        } else if (id == 101) {
            // empty if block
        }
    }

    @Override
    public void itemAdded(TreeTableEvent e) {
        this.refreshActions();
        this.refreshInfoPane();
        NcDataNode node = (NcDataNode)e.getNode();
        if (!(node instanceof NcDataset)) {
            return;
        }
        PanHistoryList.getSharedInstance().addBookmark((NcDataset)node);
        GuiUtils.refreshFrontFrameMenuBar();
    }

    public void setEnhanced(boolean enhanced) {
        this.oldNode_ = null;
        this.enhancedMode_ = enhanced;
        this.refreshInfoPane();
    }
}

