/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.sources;

import gov.nasa.giss.panoply.prefs.PanBookmark;
import gov.nasa.giss.panoply.prefs.PanBookmarksFolder;
import gov.nasa.giss.panoply.prefs.PanBookmarksList;
import gov.nasa.giss.panoply.prefs.PanBookmarksNode;
import gov.nasa.giss.panoply.sources.PanBookmarkTreeTableModel;
import gov.nasa.giss.panoply.sources.PanBookmarksNodeSelection;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.ui.DragGhost;
import gov.nasa.giss.ui.treetable.SearchableTreeTablePanel;
import gov.nasa.giss.ui.treetable.TreeTable;
import gov.nasa.giss.ui.treetable.TreeTableCellRenderer;
import gov.nasa.giss.ui.treetable.TreeTableModel;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import gov.nasa.giss.ui.treetable.TreeTablePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanBookmarkTreeTablePanel
extends SearchableTreeTablePanel
implements DragGestureListener,
DragSourceListener,
DropTargetListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public PanBookmarkTreeTablePanel() {
        super(new PanBookmarkTreeTableModel(PanBookmarksList.getSharedInstance()));
        URL url;
        try {
            url = PanSourcesFrame.class.getResource("resources/ttbookmark.png");
            this.getTreeTable().setLeafIcon(new ImageIcon(url));
        }
        catch (Exception exc) {
            LOGGER.warn("Could not load TT bookmark icon.");
        }
        try {
            url = PanSourcesFrame.class.getResource("resources/ttfolder.png");
            ImageIcon icon = new ImageIcon(url);
            this.getTreeTable().setClosedIcon(icon);
        }
        catch (Exception exc) {
            LOGGER.warn("Could not load TT folder icon.");
        }
        this.initDragNDrop();
        this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY));
    }

    private void initDragNDrop() {
        TreeTable tt = this.getTreeTable();
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(tt, 1, this);
        new DropTarget(this, this);
        new DropTarget(tt, this);
        for (Component c : this.getComponents()) {
            new DropTarget(c, this);
        }
    }

    public synchronized PanBookmarksNode addNode(PanBookmarksNode node) {
        if (node == null) {
            return null;
        }
        ((PanBookmarkTreeTableModel)this.getModel()).addToRoot(node);
        EventQueue.invokeLater(() -> {
            this.getTreeTable().setSelectedNode(node);
            this.getTreeTable().makeNodeVisible(node);
            this.fireItemAdded(node);
        });
        return node;
    }

    public synchronized PanBookmarksNode addFolder(String name) {
        if (name == null) {
            return null;
        }
        PanBookmarksFolder folder = new PanBookmarksFolder(null, name);
        this.addNode(folder);
        return folder;
    }

    public void removeNode(TreeTableNode node) {
        if (node == null) {
            return;
        }
        if (!(node instanceof PanBookmark) && !(node instanceof PanBookmarksFolder)) {
            throw new IllegalArgumentException("Node must be a bookmark or bookmark folder");
        }
        PanBookmarkTreeTableModel model = (PanBookmarkTreeTableModel)this.getModel();
        model.removeNode((PanBookmarksNode)node);
    }

    public TreeTableNode getSelectedNode() {
        return this.getTreeTable().getSelectedNode();
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        TreeTable tt = this.getTreeTable();
        PanBookmarksNode node = (PanBookmarksNode)tt.getSelectedNode();
        if (node == null) {
            return;
        }
        int row = tt.getRowForNode(node);
        TreeTableCellRenderer ttcr = (TreeTableCellRenderer)tt.getCellRenderer(row, 0).getTableCellRendererComponent(tt, node, false, false, row, 0);
        ttcr.setSize(ttcr.getPreferredSize());
        ttcr.setLeftShift(ttcr.getIconX(tt, node, null));
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("copy {}, move {}", (Object)(dge.getDragAction() == 1 ? 1 : 0), (Object)(dge.getDragAction() == 2 ? 1 : 0));
        }
        if (dge.getDragAction() == 1) {
            dge.startDrag(DragSource.DefaultCopyDrop, new DragGhost(ttcr), new Point(5, 5), new PanBookmarksNodeSelection(node), this);
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent e) {
        if (!e.getDropSuccess()) {
            return;
        }
        this.repaint();
    }

    @Override
    public void dragEnter(DragSourceDragEvent e) {
        DragSourceContext dsc = e.getDragSourceContext();
        int da = e.getDropAction();
        if ((da & 1) != 0) {
            dsc.setCursor(DragSource.DefaultCopyDrop);
        } else if ((da & 2) != 0) {
            dsc.setCursor(DragSource.DefaultMoveNoDrop);
        } else {
            dsc.setCursor(DragSource.DefaultCopyNoDrop);
        }
    }

    @Override
    public void dragExit(DragSourceEvent e) {
    }

    @Override
    public void dragOver(DragSourceDragEvent e) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent e) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        if (this.isDragOK(e)) {
            e.acceptDrag(1);
            Point p = e.getLocation();
            int row = this.rowAtPoint(p);
            if (row == -99) {
                this.setDragHighlight(this.getTreeTable().getRowCount() - 1, TreeTablePanel.DragMode.END);
            } else {
                this.setDragHighlight(row, this.dragMode(p, row));
            }
            this.repaint();
        } else {
            this.setDragHighlight(-1, TreeTablePanel.DragMode.NONE);
            e.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        this.setDragHighlight(-1, TreeTablePanel.DragMode.NONE);
        this.repaint();
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        if (this.isDragOK(e)) {
            e.acceptDrag(1);
            Point p = e.getLocation();
            int row = this.rowAtPoint(p);
            if (row == -99) {
                this.setDragHighlight(this.getTreeTable().getRowCount() - 1, TreeTablePanel.DragMode.END);
            } else {
                this.setDragHighlight(row, this.dragMode(p, row));
            }
            this.repaint();
        } else {
            this.setDragHighlight(-1, TreeTablePanel.DragMode.NONE);
            e.rejectDrag();
        }
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        PanBookmarksNode newParent;
        boolean inSameTree;
        PanBookmarksNode srcNode;
        this.setDragHighlight(-1, TreeTablePanel.DragMode.NONE);
        if (e == null) {
            return;
        }
        TreeTable tt = this.getTreeTable();
        Transferable t = e.getTransferable();
        if (!t.isDataFlavorSupported(PanBookmarksNodeSelection.BOOKMARK_FLAVOR)) {
            e.rejectDrop();
            return;
        }
        int sa = e.getSourceActions();
        if ((sa & 1) == 0) {
            e.rejectDrop();
            return;
        }
        try {
            srcNode = (PanBookmarksNode)t.getTransferData(PanBookmarksNodeSelection.BOOKMARK_FLAVOR);
        }
        catch (Exception exc) {
            e.rejectDrop();
            return;
        }
        TreeTableModel ttModel = tt.getTreeTableModel();
        boolean bl = inSameTree = srcNode.getRoot() == ttModel.getRoot();
        if (!inSameTree) {
            e.rejectDrop();
            return;
        }
        Point p = e.getLocation();
        int row = tt.rowAtPoint(p);
        TreeTablePanel.DragMode mode = this.dragMode(p, row);
        int dropIndex = 0;
        if (row == -1) {
            newParent = (PanBookmarksNode)ttModel.getRoot();
            dropIndex = newParent.getChildCount();
            if (ttModel.isRoot(srcNode)) {
                e.rejectDrop();
                return;
            }
        } else {
            PanBookmarksNode targetNode = (PanBookmarksNode)tt.getNodeForRow(row);
            if (targetNode.isNodeAncestor(srcNode)) {
                e.rejectDrop();
                return;
            }
            if (mode == TreeTablePanel.DragMode.BEFORE) {
                newParent = (PanBookmarksNode)targetNode.getParent();
                dropIndex = newParent.getIndex(targetNode);
            } else if (mode == TreeTablePanel.DragMode.AFTER) {
                newParent = (PanBookmarksNode)targetNode.getParent();
                dropIndex = newParent.getIndex(targetNode) + 1;
            } else if (mode == TreeTablePanel.DragMode.ONTO) {
                newParent = targetNode;
                dropIndex = 0;
            } else {
                e.dropComplete(false);
                this.repaint();
                return;
            }
        }
        e.acceptDrop(1);
        try {
            int oldIndex;
            PanBookmarksNode oldParent = (PanBookmarksNode)srcNode.getParent();
            if (oldParent == newParent && dropIndex > (oldIndex = newParent.getIndex(srcNode)) && dropIndex > 0) {
                --dropIndex;
            }
            if ((oldIndex = oldParent.getIndex(srcNode)) > -1) {
                oldParent.remove(oldIndex);
                ttModel.nodeRemoved(oldParent, oldIndex, srcNode);
            }
            newParent.add(dropIndex, srcNode);
            ttModel.nodeInserted(newParent, dropIndex, srcNode);
            e.dropComplete(true);
        }
        catch (Exception exc) {
            e.dropComplete(false);
        }
        this.repaint();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
        this.repaint();
    }

    private boolean isDragOK(DropTargetDragEvent e) {
        if (e == null) {
            return false;
        }
        return e.isDataFlavorSupported(PanBookmarksNodeSelection.BOOKMARK_FLAVOR);
    }

    private int rowAtPoint(Point p) {
        int row = this.getTreeTable().rowAtPoint(p);
        if (row == -1) {
            Rectangle r = this.getTreeTable().getCellRect(this.getTreeTable().getRowCount() - 1, 0, true);
            if (p.y > r.y + r.height) {
                row = -99;
            }
        }
        return row;
    }

    private TreeTablePanel.DragMode dragMode(Point p, int row) {
        if (row < 0) {
            return TreeTablePanel.DragMode.BEFORE;
        }
        Rectangle r = this.getTreeTable().getCellRect(row, 0, true);
        float percent = (float)(p.y - r.y) / (float)r.height;
        PanBookmarksNode targetNode = (PanBookmarksNode)this.getTreeTable().getNodeForRow(row);
        if (targetNode instanceof PanBookmark) {
            if (percent < 0.5f) {
                return TreeTablePanel.DragMode.BEFORE;
            }
            return TreeTablePanel.DragMode.AFTER;
        }
        if (percent < 0.2f) {
            return TreeTablePanel.DragMode.BEFORE;
        }
        if (percent < 0.8f) {
            return TreeTablePanel.DragMode.ONTO;
        }
        if (row + 1 >= this.getTreeTable().getRowCount()) {
            return TreeTablePanel.DragMode.AFTER;
        }
        PanBookmarksNode nextNode = (PanBookmarksNode)this.getTreeTable().getNodeForRow(row + 1);
        if (nextNode.getParent().equals(targetNode)) {
            return TreeTablePanel.DragMode.ONTO;
        }
        return TreeTablePanel.DragMode.AFTER;
    }

    @Override
    protected boolean nodeMatches(TreeTableNode node, String sterm) {
        String lcterm = sterm.toLowerCase();
        PanBookmarksNode bnode = (PanBookmarksNode)node;
        return bnode.getName().toLowerCase().contains(lcterm) || bnode.getAddress().toLowerCase().contains(lcterm);
    }
}

