/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.sources;

import gov.nasa.giss.panoply.prefs.PanBookmark;
import gov.nasa.giss.panoply.prefs.PanBookmarkType;
import gov.nasa.giss.panoply.prefs.PanBookmarksFolder;
import gov.nasa.giss.panoply.prefs.PanBookmarksList;
import gov.nasa.giss.panoply.prefs.PanBookmarksNode;
import gov.nasa.giss.ui.treetable.TreeTableModel;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanBookmarkTreeTableModel
extends TreeTableModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String[] COLUMN_NAMES = new String[]{"Name", "Type", "Address"};
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{TreeTableModel.class, String.class, String.class};

    public PanBookmarkTreeTableModel(PanBookmarksList root) {
        super(root);
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int col) {
        return COLUMN_NAMES[col];
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return COLUMN_CLASSES[col];
    }

    @Override
    public int getColumnAlignment(int col) {
        return 2;
    }

    @Override
    public Object getValueAt(TreeTableNode node, int col) {
        if (node == null) {
            return "";
        }
        PanBookmarksNode bnode = (PanBookmarksNode)node;
        try {
            switch (col) {
                case 0: {
                    return bnode.getName();
                }
                case 1: {
                    if (bnode instanceof PanBookmark) {
                        PanBookmarkType btype = ((PanBookmark)bnode).getAccessType();
                        switch (btype) {
                            case LOCAL_DATASET: {
                                return "Local Dataset";
                            }
                            case REMOTE_DATASET: {
                                return "Remote Dataset";
                            }
                            case CATALOG: {
                                return "Remote Catalog";
                            }
                        }
                        return "\u2026";
                    }
                    return "\u2026";
                }
                case 2: {
                    return bnode.getAddress();
                }
            }
            return "\u2026";
        }
        catch (Exception ignore) {
            return "\u2026";
        }
    }

    @Override
    public void setValueAt(Object value, TreeTableNode node, int col) {
        if (col != 0) {
            return;
        }
        PanBookmarksNode bnode = (PanBookmarksNode)node;
        if (value != null) {
            bnode.setName(value.toString());
        } else {
            bnode.setName(null);
        }
    }

    public PanBookmarksNode addToRoot(PanBookmarksNode node) {
        PanBookmarksList root = (PanBookmarksList)this.getRoot();
        root.add(node);
        int index = root.getChildCount() - 1;
        this.nodeInserted(root, index, node);
        return node;
    }

    public void removeNode(PanBookmarksNode node) {
        block5: {
            if (!(node instanceof PanBookmark) && !(node instanceof PanBookmarksFolder)) {
                return;
            }
            TreeTableNode[] ancestry = node.getPath();
            int isize = ancestry.length;
            if (isize < 2) {
                LOGGER.warn("Apparently trying to remove root of bookmarks tree.");
                return;
            }
            if (!ancestry[0].equals(this.getRoot())) {
                LOGGER.warn("Apparently trying to remove PanBookmarksNode which is not visible in tree.");
                return;
            }
            TreeTableNode parent = ancestry[isize - 2];
            int index = parent.getIndex(node);
            try {
                parent.remove(index);
                this.nodeRemoved(parent, index, node);
            }
            catch (Exception exc) {
                LOGGER.error("PanBookmarkTreeTableModel.removeNode : {}", (Object)exc.toString());
                if (!LOGGER.isTraceEnabled()) break block5;
                exc.printStackTrace();
            }
        }
    }
}

