/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandles;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ArrayList<File> files_;
    private boolean serverFound_;
    private boolean success_;

    public void attachFiles(ArrayList<File> files) {
        this.files_ = files;
    }

    public void testForServer() throws IOException, UnknownHostException {
        Socket socket = new Socket((String)null, 2880);
        InputStreamReader isr = new InputStreamReader(socket.getInputStream());
        BufferedReader fromServer = new BufferedReader(isr);
        PrintWriter toServer = new PrintWriter(socket.getOutputStream(), true);
        this.serverFound_ = true;
        this.success_ = true;
        int isize = this.files_ != null ? this.files_.size() : 0;
        int sentCount = 0;
        if (isize > 0) {
            String readFromServer;
            while ((readFromServer = fromServer.readLine()) != null) {
                String sendToServer;
                LOGGER.trace("rcvd from server: '{}'", (Object)readFromServer);
                if ("Bye.".equalsIgnoreCase(readFromServer)) break;
                if ("panoply".equalsIgnoreCase(readFromServer)) {
                    sendToServer = "panoply";
                } else if ("version".equalsIgnoreCase(readFromServer)) {
                    sendToServer = "4.5";
                } else if ("userid".equalsIgnoreCase(readFromServer)) {
                    String userName = System.getProperty("user.name");
                    sendToServer = userName == null ? "unknown" : userName;
                } else if ("filepath".equalsIgnoreCase(readFromServer)) {
                    sendToServer = this.files_.get(sentCount).getAbsolutePath();
                    ++sentCount;
                } else if ("continue?".equalsIgnoreCase(readFromServer)) {
                    sendToServer = sentCount < isize ? "y" : "n";
                } else {
                    if (readFromServer.toLowerCase().startsWith("error")) {
                        LOGGER.warn("Server sent error '{}'", (Object)readFromServer);
                        if (sentCount > 0) {
                            this.success_ = true;
                            break;
                        }
                        this.success_ = false;
                        break;
                    }
                    LOGGER.warn("Server sent unknown query '{}'", (Object)readFromServer);
                    this.success_ = false;
                    break;
                }
                LOGGER.trace("send to server: '{}'", (Object)sendToServer);
                toServer.println(sendToServer);
            }
        }
        if (sentCount > 0) {
            LOGGER.trace("{} file(s) passed to PanServer", (Object)sentCount);
        }
        toServer.println("Bye.");
        toServer.close();
        fromServer.close();
        socket.close();
    }

    public boolean isServerFound() {
        return this.serverFound_;
    }

    public boolean isSuccessful() {
        return this.success_;
    }
}

