/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.BoxLayout;

public class PanVersionPrefsPanel
extends PanAbstractPrefsPanel {
    private PanCheckBox enabledCB_;
    private PanLabel lastText_;

    public PanVersionPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        this.enabledCB_ = PanCheckBox.create("Allow Panoply to automatically query the GISS website for updates");
        PanLabel lastText1 = PanLabel.small("Version info was last checked on ");
        this.lastText_ = PanLabel.small(prefs_.getString("app:version.last"));
        PanLabel lastText3 = PanLabel.small(".");
        PanCheckBox junkCB = PanCheckBox.create("");
        int cbwidth = junkCB.getMinimumSize().width;
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(GuiUtils.createPaddedTitleBorder("Software Update"));
        this.add((Component)QuickBox.createLeftBox(this.enabledCB_), (Object)Box.createHorizontalStrut(2));
        this.add(Box.createVerticalStrut(4));
        this.add(QuickBox.createLeftBox(Box.createHorizontalStrut(cbwidth), lastText1, this.lastText_, lastText3));
    }

    private void attachListeners() {
        this.enabledCB_.addItemListener(e -> prefs_.setBoolean("app:version.enabled", this.enabledCB_.isSelected()));
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        this.enabledCB_.setSelected(prefs_.getBoolean("app:version.enabled"));
        this.lastText_.setText(prefs_.getString("app:version.last"));
    }
}

