/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.map.SymbolID;
import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanColorComboBox;
import gov.nasa.giss.panoply.ui.PanEnumComboBox;
import gov.nasa.giss.panoply.ui.PanFloatComboBox;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.util.PanParamKeys;
import gov.nasa.giss.panoply.util.PanStrokePattern;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Component;
import javax.swing.Box;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanTrajectoryPrefsPanel
extends PanAbstractPrefsPanel {
    private PanColorComboBox[] strokeColorCombos_ = new PanColorComboBox[2];
    private PanEnumComboBox[] strokeStyleMenus_ = new PanEnumComboBox[2];
    private PanIntSpinner[] strokeWeightSpinners_ = new PanIntSpinner[2];
    private PanEnumComboBox[] ptSymbolMenus_ = new PanEnumComboBox[2];
    private PanFloatComboBox[] ptSymbolSizeCombos_ = new PanFloatComboBox[2];
    private PanColorComboBox backgroundCombo_;
    private PanCheckBox skipNaNsCB_;
    private boolean refreshing_;

    public PanTrajectoryPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        this.setBorder(GuiUtils.createPaddedTitleBorder("Lon-Lat Trajectory Plots"));
        this.setOpaque(false);
        PanLabel topText = PanLabel.create("When creating a trajectory map plot, set\u2026");
        PanLabel bgLabel1 = PanLabel.create("Background:\u2009");
        this.backgroundCombo_ = PanColorComboBox.createGrayscale("plot:feature.background");
        this.skipNaNsCB_ = PanCheckBox.create("plot:feature.nanskip", "Skip points with NaN value", prefs_.getBoolean("plot:feature.nanskip"));
        PanLabel t1Label = PanLabel.create("Trajectory 1:\u2009");
        PanLabel t2Label = PanLabel.create("Trajectory 2:\u2009");
        QuickBox[] strokeStyleBoxes = new QuickBox[2];
        QuickBox[] strokeColorBoxes = new QuickBox[2];
        QuickBox[] symbolBoxes = new QuickBox[2];
        for (int i = 0; i < 2; ++i) {
            PanLabel t1SymbolLabel1 = PanLabel.create("Point:\u2009");
            PanLabel t1SymbolLabel2 = PanLabel.create("Symbol:\u2009");
            PanLabel t1SymbolLabel3 = PanLabel.create(", Size:\u2009");
            this.ptSymbolMenus_[i] = PanEnumComboBox.create(PanParamKeys.P_FEATURE_SYMBOL_ID[i], SymbolID.class);
            this.ptSymbolSizeCombos_[i] = PanFloatComboBox.create(PanParamKeys.P_FEATURE_SYMBOL_SIZE[i], 1.0f, 12.0f);
            this.ptSymbolMenus_[i].setSelectedItem(prefs_.getString(PanParamKeys.P_FEATURE_SYMBOL_ID[i]));
            this.ptSymbolSizeCombos_[i].setValue(prefs_.getFloat(PanParamKeys.P_FEATURE_SYMBOL_SIZE[i]));
            symbolBoxes[i] = QuickBox.createLeftBox(t1SymbolLabel1, t1SymbolLabel2, this.ptSymbolMenus_[i], t1SymbolLabel3, this.ptSymbolSizeCombos_[i]);
            PanLabel t1StrokeLabel1 = PanLabel.create("Stroke:\u2009");
            PanLabel t1StrokeLabel2 = PanLabel.create("Style:\u2009");
            PanLabel t2StrokeLabel2 = PanLabel.create(" ");
            PanLabel t2StrokeLabel3 = PanLabel.create("Color:\u2009");
            PanLabel t2StrokeLabel4 = PanLabel.create(", Weight:\u2009");
            PanLabel t2StrokeLabel5 = PanLabel.create("%");
            this.strokeStyleMenus_[i] = PanEnumComboBox.create(PanParamKeys.P_TRAJ_STROKE_STYLE[i], PanStrokePattern.class);
            this.strokeStyleMenus_[i].setSelectedItem(prefs_.getString(PanParamKeys.P_TRAJ_STROKE_STYLE[i]));
            this.strokeColorCombos_[i] = PanColorComboBox.createRainbow(PanParamKeys.P_TRAJ_STROKE_COLOR[i]);
            this.strokeColorCombos_[i].setSelectedColor(prefs_.getColor(PanParamKeys.P_TRAJ_STROKE_COLOR[i]));
            this.strokeWeightSpinners_[i] = PanIntSpinner.createWeightX5(PanParamKeys.P_TRAJ_STROKE_WGT[i], prefs_.getInt(PanParamKeys.P_TRAJ_STROKE_WGT[i]), 500);
            strokeStyleBoxes[i] = QuickBox.createLeftBox(t1StrokeLabel1, t1StrokeLabel2, this.strokeStyleMenus_[i]);
            strokeColorBoxes[i] = QuickBox.createLeftBox(t2StrokeLabel2, t2StrokeLabel3, this.strokeColorCombos_[i], t2StrokeLabel4, this.strokeWeightSpinners_[i], t2StrokeLabel5, Box.createHorizontalStrut(12));
            GuiUtils.matchLabelWidths(t1StrokeLabel1, t2StrokeLabel2, t1SymbolLabel1);
            GuiUtils.matchLabelWidths(t1StrokeLabel2, t2StrokeLabel3, t1SymbolLabel2);
        }
        GuiUtils.matchLabelWidths(bgLabel1, t1Label, t2Label);
        FlexingGridLayout fgl = new FlexingGridLayout(3, 11, 0, 2);
        fgl.setColumnWeight(2, 9999.0f);
        fgl.setPadBottom(true);
        this.setLayout(fgl);
        this.add((Component)topText, new FGConstraint(0, 0, 2, 1));
        this.add(Box.createVerticalStrut(8), new FGConstraint(0, 1));
        this.add((Component)bgLabel1, new FGConstraint(0, 2));
        this.add((Component)this.backgroundCombo_, new FGConstraint(1, 2));
        this.add((Component)this.skipNaNsCB_, new FGConstraint(1, 3));
        this.add(Box.createVerticalStrut(8), new FGConstraint(0, 4));
        this.add((Component)t1Label, new FGConstraint(0, 5));
        this.add((Component)symbolBoxes[0], new FGConstraint(1, 5));
        this.add((Component)strokeStyleBoxes[0], new FGConstraint(1, 6));
        this.add((Component)strokeColorBoxes[0], new FGConstraint(1, 7));
        this.add((Component)t2Label, new FGConstraint(0, 8));
        this.add((Component)symbolBoxes[1], new FGConstraint(1, 8));
        this.add((Component)strokeStyleBoxes[1], new FGConstraint(1, 9));
        this.add((Component)strokeColorBoxes[1], new FGConstraint(1, 10));
        this.refreshPrivate();
    }

    private void attachListeners() {
        this.backgroundCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:feature.background", this.backgroundCombo_.getSelectedColor());
        });
        this.skipNaNsCB_.addItemListener(e -> {
            boolean checked = this.skipNaNsCB_.isSelected();
            prefs_.setBoolean("plot:feature.nanskip", checked);
        });
        int i = 0;
        while (i < 2) {
            int ii = i++;
            this.strokeStyleMenus_[ii].addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                prefs_.set(PanParamKeys.P_TRAJ_STROKE_STYLE[ii], this.strokeStyleMenus_[ii].getStringValue());
            });
            this.strokeColorCombos_[ii].addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (this.refreshing_) {
                    return;
                }
                prefs_.set(PanParamKeys.P_TRAJ_STROKE_COLOR[ii], this.strokeColorCombos_[ii].getSelectedColor());
            });
            this.strokeWeightSpinners_[ii].addChangeListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                prefs_.setInt(PanParamKeys.P_TRAJ_STROKE_WGT[ii], this.strokeWeightSpinners_[ii].getIntValue());
            });
            this.ptSymbolMenus_[ii].addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                prefs_.set(PanParamKeys.P_FEATURE_SYMBOL_ID[ii], this.ptSymbolMenus_[ii].getStringValue());
            });
            this.ptSymbolSizeCombos_[ii].addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                prefs_.setFloat(PanParamKeys.P_FEATURE_SYMBOL_SIZE[ii], this.ptSymbolSizeCombos_[ii].getValue());
            });
        }
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        for (int i = 0; i < 2; ++i) {
            this.strokeStyleMenus_[i].setSelectedItem(prefs_.getString(PanParamKeys.P_TRAJ_STROKE_STYLE[i]));
            this.strokeColorCombos_[i].setSelectedColor(prefs_.getColor(PanParamKeys.P_TRAJ_STROKE_COLOR[i]));
            this.strokeWeightSpinners_[i].setValue(prefs_.getInt(PanParamKeys.P_TRAJ_STROKE_WGT[i]));
            this.ptSymbolMenus_[i].setSelectedItem(prefs_.getString(PanParamKeys.P_FEATURE_SYMBOL_ID[i]));
            this.ptSymbolSizeCombos_[i].setValue(prefs_.getFloat(PanParamKeys.P_FEATURE_SYMBOL_SIZE[i]));
        }
        this.backgroundCombo_.setSelectedColor(prefs_.getColor("plot:feature.background"));
        this.refreshing_ = false;
    }
}

