/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanCommonPrefsTable;
import gov.nasa.giss.panoply.prefsui.PanPrefsTableScrollPane;
import gov.nasa.giss.panoply.prefsui.PanProjectionTableModel;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.label.MultiLineLabel;
import java.awt.Component;
import javax.swing.JButton;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanProjectionLibPrefsPanel
extends PanAbstractPrefsPanel {
    private PanProjectionTableModel tmodel_;
    private PanPrefsTableScrollPane tspane_;
    private JButton checkAllBtn_;
    private JButton checkMinBtn_;

    public PanProjectionLibPrefsPanel() {
        this.createLayout();
        this.attachListeners();
    }

    private void createLayout() {
        MultiLineLabel tText = new MultiLineLabel("Projections selected as favorites are included in the projection popup\nmenu in lon-lat map plot controls. Unchecked projections are omitted.", 0);
        this.tmodel_ = new PanProjectionTableModel();
        PanCommonPrefsTable table = new PanCommonPrefsTable(this.tmodel_);
        this.tspane_ = new PanPrefsTableScrollPane(table);
        this.checkMinBtn_ = new JButton("Check Minimal");
        this.checkAllBtn_ = new JButton("Check All");
        FlexingGridLayout fgl = new FlexingGridLayout(2, 5, 12, 2);
        fgl.setRowWeight(1, 9999.0f);
        this.setLayout(fgl);
        this.setBorder(GuiUtils.createPaddedTitleBorder("Map Projections"));
        this.add((Component)tText, new FGConstraint(0, 0, 2, 1, 0.5, 0.5));
        this.add((Component)this.tspane_, new FGConstraint(0, 1, 2, 1, true));
        this.add((Component)this.checkMinBtn_, new FGConstraint(0, 2, 1.0));
        this.add((Component)this.checkAllBtn_, new FGConstraint(1, 2));
    }

    private void attachListeners() {
        this.checkAllBtn_.addActionListener(e -> this.tmodel_.checkUncheckAll(true));
        this.checkMinBtn_.addActionListener(e -> this.tmodel_.checkUncheckAll(false));
    }

    @Override
    public void refresh() {
        this.tmodel_.fireTableDataChanged();
    }
}

