/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.prefsui.Pan1DGridPrefsPanel;
import gov.nasa.giss.panoply.prefsui.Pan2DGridPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanColorContourPlotPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanColorTableLibPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanColorbarPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanContourPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanGeneralPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanHistoryPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanLatTimePrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanLatVertPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanLaunchPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanLinePlotStrokePrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanLonLatOverlaysPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanLonLatProjectionPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanLonTimePrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanLonVertPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanOutputPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanOverlayLibPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanProjectionLibPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanScalePrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanShadingPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanTimeLatPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanTimeVertPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanTrajectoryPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanUnitsPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanVectorPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanVersionPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanZonalAveragePlotPrefsPanel;
import gov.nasa.giss.panoply.ui.PanContentPanel;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.ui.PanPanel;
import gov.nasa.giss.ui.QuickBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public final class PanPreferencesFrame
extends PanFrame {
    private DefaultListModel<PrefGroupContainer> pgcModel_;
    private JList<PrefGroupContainer> pgcList_;
    private JScrollPane scrollpane_;
    private JButton prevBtn_;
    private JButton nextBtn_;
    private JButton resetBtn_;
    private JPanel currentPanel_;
    private static boolean exists_;

    public static PanPreferencesFrame getSharedInstance() {
        PanPreferencesFrame instance = Singleton.INSTANCE;
        exists_ = true;
        return instance;
    }

    public static boolean instanceExists() {
        return exists_;
    }

    private PanPreferencesFrame() {
        super("Preferences");
        this.setName(this.getTitle());
        this.setResizable(false);
        this.setPanMenuBar(new PanMenuBar(this));
        this.createLayout();
        this.placeOnScreen();
        this.attachListeners();
    }

    private void createLayout() {
        String pname;
        PrefGroupContainer pgc;
        this.pgcModel_ = new DefaultListModel();
        this.pgcModel_.addElement(new PrefGroupContainer("General", new PanGeneralPrefsPanel()));
        this.pgcModel_.addElement(new PrefGroupContainer("Scale", new PanScalePrefsPanel(), new PanColorbarPrefsPanel()));
        this.pgcModel_.addElement(new PrefGroupContainer("Grid", new Pan2DGridPrefsPanel(), new Pan1DGridPrefsPanel()));
        this.pgcModel_.addElement(new PrefGroupContainer("Lon-Lat Map Projection", new PanLonLatProjectionPrefsPanel()));
        this.pgcModel_.addElement(new PrefGroupContainer("Lon-Lat Map Overlay", new PanLonLatOverlaysPrefsPanel()));
        this.pgcModel_.addElement(new PrefGroupContainer("Lon-Lat Map Shading", new PanShadingPrefsPanel()));
        this.pgcModel_.addElement(new PrefGroupContainer("Other Georef Plots", new PanLatVertPrefsPanel(), new PanLonVertPrefsPanel(), new PanTimeVertPrefsPanel(), new PanLatTimePrefsPanel(), new PanLonTimePrefsPanel(), new PanTimeLatPrefsPanel()));
        this.pgcModel_.addElement(new PrefGroupContainer("Other Color Contour Plots", new PanColorContourPlotPrefsPanel()));
        this.pgcModel_.addElement(new PrefGroupContainer("Line Plots", new PanLinePlotStrokePrefsPanel(), new PanZonalAveragePlotPrefsPanel()));
        this.pgcModel_.addElement(new PrefGroupContainer("Trajectories", new PanTrajectoryPrefsPanel()));
        this.pgcModel_.addElement(new PrefGroupContainer("Contours & Vectors", new PanContourPrefsPanel(), new PanVectorPrefsPanel()));
        this.pgcModel_.addElement(new PrefGroupContainer("Units", new PanUnitsPrefsPanel()));
        this.pgcModel_.addElement(new PrefGroupContainer("Files", new PanLaunchPrefsPanel(), new PanOutputPrefsPanel(), new PanHistoryPrefsPanel(), new PanVersionPrefsPanel()));
        this.pgcModel_.addElement(new PrefGroupContainer("Library: Color Tables", new PanColorTableLibPrefsPanel()));
        this.pgcModel_.addElement(new PrefGroupContainer("Library: Map Projections", new PanProjectionLibPrefsPanel()));
        this.pgcModel_.addElement(new PrefGroupContainer("Library: Map Overlays", new PanOverlayLibPrefsPanel()));
        Dimension asize = new Dimension();
        for (Object oo : this.pgcModel_.toArray()) {
            pgc = (PrefGroupContainer)oo;
            pname = pgc.toString();
            Dimension psize = pgc.getPanel().getPreferredSize();
            asize.width = Math.max(asize.width, psize.width);
            if (pname.contains("Lib") || pname.contains("Projections") || pname.contains("Beta")) continue;
            asize.height = Math.max(asize.height, psize.height);
        }
        asize.height += 40;
        asize.width = Math.min(720, asize.width);
        for (Object oo : this.pgcModel_.toArray()) {
            pgc = (PrefGroupContainer)oo;
            pname = pgc.toString();
            JPanel jp = pgc.getPanel();
            jp.setMaximumSize(asize);
            if (!pname.contains("Lib")) continue;
        }
        this.pgcList_ = new JList<PrefGroupContainer>(this.pgcModel_);
        this.scrollpane_ = new JScrollPane(this.pgcList_);
        Dimension bsize = this.scrollpane_.getPreferredSize();
        bsize.height = Math.max(bsize.height, asize.height);
        this.scrollpane_.setMinimumSize(bsize);
        this.scrollpane_.setPreferredSize(bsize);
        this.currentPanel_ = new PanPanel();
        this.currentPanel_.setLayout(new BorderLayout());
        this.currentPanel_.setMinimumSize(asize);
        this.currentPanel_.setPreferredSize(asize);
        this.pgcList_.setSelectedIndex(0);
        this.setCurrentPanel(0);
        this.prevBtn_ = new JButton("Prev");
        this.nextBtn_ = new JButton("Next");
        this.resetBtn_ = new JButton("Reset");
        QuickBox navbox = QuickBox.createTopBox(this.prevBtn_, this.nextBtn_);
        PanContentPanel contentPanel = new PanContentPanel(PanGuiUtils.STD_BORDER);
        FlexingGridLayout fgl = new FlexingGridLayout(3, 4, 8, 2);
        fgl.setRowWeight(2, 999999.0f);
        contentPanel.setLayout(fgl);
        contentPanel.add((Component)this.scrollpane_, new FGConstraint(0, 0, 1, 4, 1.0, 0.0));
        contentPanel.add((Component)this.currentPanel_, new FGConstraint(1, 0, 1, 4, 1.0, 0.0));
        contentPanel.add((Component)navbox, new FGConstraint(2, 0, 1, 1, 0.5, 0.0));
        contentPanel.add((Component)this.resetBtn_, new FGConstraint(2, 3, 1, 1, 0.5, 1.0));
        Container contentPane = this.getContentPane();
        contentPane.add(contentPanel);
        this.pack();
    }

    private void attachListeners() {
        this.pgcList_.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = PanPreferencesFrame.this.pgcList_.getSelectedIndex();
                PanPreferencesFrame.this.setCurrentPanel(index);
            }
        });
        this.prevBtn_.addActionListener(e -> {
            int index = this.pgcList_.getSelectedIndex() - 1;
            if (index >= 0) {
                this.pgcList_.setSelectedIndex(index);
            }
        });
        this.nextBtn_.addActionListener(e -> {
            int index = this.pgcList_.getSelectedIndex() + 1;
            if (index < this.pgcList_.getModel().getSize()) {
                this.pgcList_.setSelectedIndex(index);
            }
        });
        this.resetBtn_.addActionListener(e -> this.handleReset());
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 0) {
                    int index = PanPreferencesFrame.this.pgcList_.locationToIndex(e.getPoint());
                    PanPreferencesFrame.this.setCurrentPanel(index);
                }
            }
        };
        this.pgcList_.addMouseListener(ml);
    }

    private void setCurrentPanel(int index) {
        PrefGroupContainer item = this.pgcList_.getModel().getElementAt(index);
        item.refresh();
        JPanel panel = item.getPanel();
        panel.invalidate();
        this.currentPanel_.removeAll();
        this.currentPanel_.add((Component)panel, "North");
        this.currentPanel_.validate();
        this.repaint();
    }

    @Override
    public void refresh() {
        for (Object oo : this.pgcModel_.toArray()) {
            PrefGroupContainer pgc = (PrefGroupContainer)oo;
            pgc.refresh();
        }
    }

    private void handleReset() {
        Object[] options = new String[]{"Yes", "Cancel"};
        int choice = JOptionPane.showOptionDialog(this, "Are you sure want to reset all Panoply preferences to the \n'factory defaults'? This will not remove any color tables\nor overlays that you may have imported.", "Preferences", 0, 3, null, options, options[0]);
        if (choice == 0) {
            PanPreferences.getSharedInstance().restoreDefaults();
            this.refresh();
        }
    }

    class PrefGroupContainer {
        private String name_;
        private JPanel panel_;

        PrefGroupContainer(String name, JPanel ... subpanels) {
            this.name_ = name;
            this.panel_ = new PanPanel();
            this.panel_.setLayout(new BoxLayout(this.panel_, 1));
            this.panel_.setBorder(PanGuiUtils.NO_BORDER);
            for (JPanel jp : subpanels) {
                this.panel_.add(jp);
                this.panel_.add(Box.createVerticalStrut(2));
            }
            this.panel_.add(Box.createVerticalGlue());
            this.panel_.add(Box.createVerticalGlue());
            this.panel_.setOpaque(false);
        }

        public void refresh() {
            for (Component child : this.panel_.getComponents()) {
                if (!(child instanceof PanAbstractPrefsPanel)) continue;
                ((PanAbstractPrefsPanel)child).refresh();
            }
        }

        public String toString() {
            return this.name_;
        }

        public JPanel getPanel() {
            return this.panel_;
        }
    }

    private static class Singleton {
        private static final PanPreferencesFrame INSTANCE = new PanPreferencesFrame();

        private Singleton() {
        }
    }
}

