/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.io.FileUtils;
import gov.nasa.giss.map.overlay.MapOverlay;
import gov.nasa.giss.map.overlay.OverlayFilenameFilter;
import gov.nasa.giss.map.overlay.OverlayResourceList;
import gov.nasa.giss.panoply.io.PanFileUtils;
import gov.nasa.giss.panoply.overlay.PanOverlayFrame;
import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanCommonPrefsTable;
import gov.nasa.giss.panoply.prefsui.PanOverlayTableModel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.ui.GuiUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import net.schmunk.ui.PlusMinus;

public class PanOverlayLibPrefsPanel
extends PanAbstractPrefsPanel
implements DropTargetListener {
    private JScrollPane tspane_;
    private PlusMinus pmwidget_;
    private PanCommonPrefsTable table_;
    private PanCheckBox autoimportCB_;
    private KeyStroke cutKS_;
    private Border focusedTableBorder_;
    private Border unfocusedTableBorder_;
    private boolean refreshing_;

    public PanOverlayLibPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        this.setBorder(GuiUtils.createPaddedTitleBorder("Map Overlays Library"));
        this.setOpaque(false);
        this.tspane_ = this.createTable();
        Border ob = this.tspane_.getBorder();
        this.focusedTableBorder_ = new CompoundBorder(PanGuiUtils.THIN_FOCUSED_BORDER, ob);
        this.unfocusedTableBorder_ = new CompoundBorder(PanGuiUtils.THIN_UNFOCUSED_BORDER, ob);
        this.tspane_.setBorder(this.unfocusedTableBorder_);
        GuiUtils.makeRecursiveDropTarget(this.tspane_, this);
        this.pmwidget_ = new PlusMinus();
        this.pmwidget_.setMaximumSize(this.pmwidget_.getPreferredSize());
        this.pmwidget_.setMinusEnabled(false);
        PanLabel bText = PanLabel.small("Built-in overlays cannot be removed.");
        this.autoimportCB_ = PanCheckBox.create("Always import new overlays into support library", false);
        FlexingGridLayout fgl = new FlexingGridLayout(2, 3, 12, 2);
        fgl.setRowWeight(1, 9999.0f);
        fgl.setColumnWeight(1, 9999.0f);
        this.setLayout(fgl);
        this.add((Component)this.tspane_, new FGConstraint(0, 0, 2, 1, true));
        this.add((Component)this.pmwidget_, new FGConstraint(0, 1));
        this.add((Component)bText, new FGConstraint(1, 1, 1.0));
        this.add((Component)this.autoimportCB_, new FGConstraint(0, 2, 2, 1, 0.5, 0.5));
    }

    private JScrollPane createTable() {
        this.table_ = new PanCommonPrefsTable(new PanOverlayTableModel());
        JScrollPane jsp = new JScrollPane(this.table_);
        jsp.setOpaque(false);
        jsp.setMinimumSize(new Dimension(this.getPreferredSize().width / 2, 160));
        return jsp;
    }

    private void attachListeners() {
        this.autoimportCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setBoolean("files:autoimport.overlays", this.autoimportCB_.isSelected());
        });
        this.pmwidget_.addActionListener(e -> {
            if (e.getID() == 2000) {
                this.additionRequested();
            } else if (e.getID() == 2001) {
                int row = this.table_.getSelectedRow();
                this.deletionRequested(row);
            }
        });
        this.table_.getModel().addTableModelListener(e -> this.refreshPrivate());
        this.table_.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PanOverlayLibPrefsPanel.this.refresh();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                PanOverlayLibPrefsPanel.this.refresh();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() < 2) {
                    return;
                }
                Point p = e.getPoint();
                int row = PanOverlayLibPrefsPanel.this.table_.rowAtPoint(p);
                PanOverlayLibPrefsPanel.this.displaySelection(row);
            }
        });
        ActionMap am = this.table_.getActionMap();
        Object cutKey = GuiUtils.getCutKey(am);
        InputMap im = this.table_.getInputMap(1);
        this.cutKS_ = null;
        for (KeyStroke ks : im.allKeys()) {
            Object o = im.get(ks);
            if (!o.equals(cutKey)) continue;
            this.cutKS_ = ks;
            break;
        }
        this.table_.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row = PanOverlayLibPrefsPanel.this.table_.getSelectedRow();
                KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
                if (PanOverlayLibPrefsPanel.this.cutKS_ != null && ks.equals(PanOverlayLibPrefsPanel.this.cutKS_)) {
                    PanOverlayLibPrefsPanel.this.deletionRequested(row);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                int row = PanOverlayLibPrefsPanel.this.table_.getSelectedRow();
                KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
                if ((e.getKeyCode() == 8 || e.getKeyCode() == 127) && e.getModifiersEx() == 0) {
                    PanOverlayLibPrefsPanel.this.deletionRequested(row);
                } else if (PanOverlayLibPrefsPanel.this.cutKS_ != null && ks.equals(PanOverlayLibPrefsPanel.this.cutKS_)) {
                    PanOverlayLibPrefsPanel.this.deletionRequested(row);
                }
            }
        });
    }

    private void displaySelection(int index) {
        Object o = this.table_.getValueAt(index, 1);
        if (o instanceof String) {
            OverlayResourceList list = PanUtils.getOverlayResourceList();
            o = list.getBackingObject(index);
        }
        if (o instanceof MapOverlay) {
            MapOverlay oo = (MapOverlay)o;
            PanOverlayFrame.getSharedInstance().reveal();
            PanOverlayFrame.getSharedInstance().setOverlay(oo);
        }
    }

    private void additionRequested() {
        PanFrame pf = (PanFrame)this.getTopLevelAncestor();
        File[] ff = PanFileUtils.showOpenOverlayFileChooser(pf);
        if (ff != null) {
            PanUtils.getOverlayResourceList().addAlphabetic((Component)pf, ff);
        }
    }

    private void deletionRequested(int index) {
        this.table_.clearSelection();
        OverlayResourceList list = PanUtils.getOverlayResourceList();
        list.remove(index);
        this.refresh();
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
        this.table_.repaint();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.autoimportCB_.setSelected(prefs_.getBoolean("files:autoimport.overlays"));
        this.pmwidget_.setPlusEnabled(true);
        int row = this.table_.getSelectedRow();
        OverlayResourceList oset = PanUtils.getOverlayResourceList();
        if (row < 0 || row >= oset.getSize()) {
            this.pmwidget_.setMinusEnabled(false);
        } else {
            this.pmwidget_.setMinusEnabled(oset.canRemove(row));
        }
        this.refreshing_ = false;
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrag(1);
            this.tspane_.setBorder(this.focusedTableBorder_);
            this.repaint();
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        Transferable t = e.getTransferable();
        if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrop(1);
            List<File> droplist = FileUtils.getTransferredFileList(t);
            if (droplist != null) {
                ArrayList<File> addlist = new ArrayList<File>();
                for (File f : droplist) {
                    if (!OverlayFilenameFilter.isOverlayName(f)) continue;
                    addlist.add(f);
                }
                PanUtils.getOverlayResourceList().addAlphabetic((Component)this, addlist);
            }
            e.dropComplete(true);
            this.repaint();
        } else {
            e.rejectDrop();
        }
        this.tspane_.setBorder(this.unfocusedTableBorder_);
        this.tspane_.invalidate();
        this.validate();
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        this.tspane_.setBorder(this.unfocusedTableBorder_);
        this.repaint();
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrag(1);
            this.tspane_.setBorder(this.focusedTableBorder_);
            this.repaint();
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
        this.tspane_.setBorder(this.focusedTableBorder_);
        this.repaint();
    }
}

