/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.ui.PanTextField;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.text.StringUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.EventObject;
import javax.swing.Box;
import javax.swing.JLabel;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanLonTimePrefsPanel
extends PanAbstractPrefsPanel {
    private static final PrintfFormat PFORMAT_7G = PrintfFormat.PFORMAT_7G;
    private PanTextField lvalTF_;
    private PanTextField rvalTF_;

    public PanLonTimePrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        this.setBorder(GuiUtils.createPaddedTitleBorder("Lon-Time Plots"));
        this.setOpaque(false);
        PanLabel topText = PanLabel.create("When creating a lon-time plot, set\u2026");
        this.lvalTF_ = PanTextField.createDoubleField(null, -180.0);
        this.rvalTF_ = PanTextField.createDoubleField(null, 180.0);
        FlexingGridLayout fgl = new FlexingGridLayout(3, 5, 0, 2);
        fgl.setColumnWeight(2, 9999.0f);
        this.setLayout(fgl);
        this.add((Component)topText, new FGConstraint(0, 0, 3, 1));
        this.add(Box.createVerticalStrut(2), new FGConstraint(1, 1));
        this.add((Component)new JLabel("Lon Axis Left:\u2009"), new FGConstraint(0, 2, 1.0));
        this.add((Component)QuickBox.createLeftBox(this.lvalTF_, new JLabel("\u00b0E, Right:\u2009"), this.rvalTF_, new JLabel("\u00b0E")), new FGConstraint(1, 2));
    }

    private void attachListeners() {
        FocusAdapter xRangeFL = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PanLonTimePrefsPanel.this.handleXExtrema(e);
            }
        };
        ActionListener xRangeAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanLonTimePrefsPanel.this.handleXExtrema(e);
            }
        };
        this.lvalTF_.addFocusListener(xRangeFL);
        this.rvalTF_.addFocusListener(xRangeFL);
        this.lvalTF_.addActionListener(xRangeAL);
        this.rvalTF_.addActionListener(xRangeAL);
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        this.lvalTF_.setText(PFORMAT_7G.sprintfx(prefs_.getDouble("plot:lontime.xaxis.begin")));
        this.rvalTF_.setText(PFORMAT_7G.sprintfx(prefs_.getDouble("plot:lontime.xaxis.end")));
    }

    private void handleXExtrema(EventObject e) {
        double oldright;
        double oldleft;
        double left = oldleft = prefs_.getDouble("plot:lontime.xaxis.begin");
        try {
            left = StringUtils.parseDouble(this.lvalTF_.getText());
        }
        catch (Exception exc) {
            this.lvalTF_.setText(PFORMAT_7G.sprintfx(oldleft));
            return;
        }
        if (left < -360.0) {
            left = -360.0;
            this.lvalTF_.setText(PFORMAT_7G.sprintfx(left));
        } else if (left >= 360.0) {
            left = 360.0;
            this.lvalTF_.setText(PFORMAT_7G.sprintfx(left));
        }
        double right = oldright = prefs_.getDouble("plot:lontime.xaxis.end");
        try {
            right = StringUtils.parseDouble(this.rvalTF_.getText());
        }
        catch (Exception exc) {
            this.rvalTF_.setText(PFORMAT_7G.sprintfx(oldright));
            return;
        }
        if (right < -360.0) {
            right = -360.0;
            this.rvalTF_.setText(PFORMAT_7G.sprintfx(right));
        } else if (right >= 360.0) {
            right = 360.0;
            this.rvalTF_.setText(PFORMAT_7G.sprintfx(right));
        }
        if (left == right) {
            if (left <= 0.0) {
                this.rvalTF_.setText(PFORMAT_7G.sprintfx(right += -360.0));
            } else {
                this.lvalTF_.setText(PFORMAT_7G.sprintfx(left -= -360.0));
            }
        } else if (Math.abs(right - left) > 360.0) {
            boolean pright;
            boolean bl = pright = right - left > 0.0;
            if (e == null) {
                right = pright ? left + 360.0 : left - 360.0;
                this.rvalTF_.setText(PFORMAT_7G.sprintfx(right));
            } else if (e.getSource() == this.lvalTF_) {
                right = pright ? left + 360.0 : left - 360.0;
                this.rvalTF_.setText(PFORMAT_7G.sprintfx(right));
            } else if (e.getSource() == this.rvalTF_) {
                left = pright ? right - 360.0 : right + 360.0;
                this.lvalTF_.setText(PFORMAT_7G.sprintfx(left));
            }
        }
        prefs_.setDouble("plot:lontime.xaxis.begin", left);
        prefs_.setDouble("plot:lontime.xaxis.end", right);
    }
}

