/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.data.nc.NcConfig;
import gov.nasa.giss.data.nc.NcVarSorting;
import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import javax.swing.Box;
import javax.swing.BoxLayout;

public class PanLaunchPrefsPanel
extends PanAbstractPrefsPanel {
    private PanCheckBox fileDialogAtLaunchCB_;
    private PanCheckBox expandNodesCB_;
    private PanCheckBox sortAlphabeticCB_;
    private PanCheckBox strictGribCB_;
    private boolean refreshing_;

    public PanLaunchPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        this.fileDialogAtLaunchCB_ = PanCheckBox.create("Show open-file dialog at launch");
        this.expandNodesCB_ = PanCheckBox.create("Expand newly opened file nodes in datasets panel");
        this.sortAlphabeticCB_ = PanCheckBox.create("Sort datasets panel entries alphabetically (requires restart)");
        this.strictGribCB_ = PanCheckBox.create("Open GRIB-1 datasets in strict mode (requires restart)");
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(GuiUtils.createPaddedTitleBorder("Launch / Open"));
        this.add(QuickBox.createLeftBox(this.fileDialogAtLaunchCB_));
        this.add(Box.createVerticalStrut(2));
        this.add(QuickBox.createLeftBox(this.expandNodesCB_));
        this.add(Box.createVerticalStrut(2));
        this.add(QuickBox.createLeftBox(this.sortAlphabeticCB_));
        this.add(Box.createVerticalStrut(2));
        this.add(QuickBox.createLeftBox(this.strictGribCB_));
    }

    private void attachListeners() {
        this.fileDialogAtLaunchCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            boolean bb = this.fileDialogAtLaunchCB_.isSelected();
            prefs_.setBoolean("files:launch.dialog", bb);
        });
        this.expandNodesCB_.addItemListener(e -> {
            if (!this.refreshing_) {
                boolean bb = this.expandNodesCB_.isSelected();
                prefs_.setBoolean("sources:nodes.expanded", bb);
            }
            PanSourcesFrame.getSharedInstance().refresh();
        });
        this.sortAlphabeticCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            boolean bb = this.sortAlphabeticCB_.isSelected();
            if (bb) {
                prefs_.set("sources:datasets.sorting", NcVarSorting.ALPHA.name());
            } else {
                prefs_.set("sources:datasets.sorting", NcVarSorting.NONE.name());
            }
        });
        this.strictGribCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            boolean bb = this.strictGribCB_.isSelected();
            prefs_.setBoolean("files:grib.strict", bb);
            NcConfig.setGrib1Strict(bb);
        });
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.fileDialogAtLaunchCB_.setSelected(prefs_.getBoolean("files:launch.dialog"));
        this.expandNodesCB_.setSelected(prefs_.getBoolean("sources:nodes.expanded"));
        this.sortAlphabeticCB_.setSelected(NcVarSorting.ALPHA.matches(prefs_.getString("sources:datasets.sorting")));
        this.strictGribCB_.setSelected(prefs_.getBoolean("files:grib.strict"));
        this.refreshing_ = false;
    }
}

