/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanColorComboBox;
import gov.nasa.giss.panoply.ui.PanFontComboBox;
import gov.nasa.giss.panoply.ui.PanGuiSize;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.ui.PanPlotSizeComboBox;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.color.PaletteType;
import java.awt.Component;
import java.lang.invoke.MethodHandles;
import javax.swing.Box;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanGeneralPrefsPanel
extends PanAbstractPrefsPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanPlotSizeComboBox sizeCombo_;
    private PanCheckBox interpolateCB_;
    private PanColorComboBox bkgdCombo_;
    private PanFontComboBox fontCombo_;
    private PanCheckBox super10CB_;
    private boolean refreshing_;

    public PanGeneralPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        this.setBorder(GuiUtils.createPaddedTitleBorder("General"));
        this.setOpaque(false);
        PanLabel topText = PanLabel.create("When creating a plot, set\u2026");
        this.sizeCombo_ = new PanPlotSizeComboBox();
        PanGuiUtils.setSizeRegular(this.sizeCombo_);
        this.interpolateCB_ = PanCheckBox.create("On");
        this.bkgdCombo_ = PanColorComboBox.create(PaletteType.BLACK_WHITE);
        this.fontCombo_ = new PanFontComboBox(PanGuiSize.REGULAR, null);
        this.super10CB_ = PanCheckBox.create("Replace \"E\" notation with superscripted 10");
        FlexingGridLayout fgl = new FlexingGridLayout(3, 8, 0, 2);
        fgl.setColumnWeight(2, 9999.0f);
        this.setLayout(fgl);
        int row = 0;
        this.add((Component)topText, new FGConstraint(0, row, 3, 1));
        this.add(Box.createVerticalStrut(4), new FGConstraint(0, ++row));
        this.add((Component)PanLabel.create("Plot Size:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)this.sizeCombo_, new FGConstraint(1, row));
        this.add((Component)PanLabel.create("Interpolation:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)this.interpolateCB_, new FGConstraint(1, row));
        this.add((Component)PanLabel.create("Background:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(this.bkgdCombo_), new FGConstraint(1, row));
        this.add((Component)PanLabel.create("Labels:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(PanLabel.create("Typeface:\u2009"), this.fontCombo_), new FGConstraint(1, row));
        this.add((Component)PanLabel.create("Exponents:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(this.super10CB_), new FGConstraint(1, row));
    }

    private void attachListeners() {
        this.sizeCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.setInt("plot:size.factor", this.sizeCombo_.getSelectedSizeFactor());
        });
        this.interpolateCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setBoolean("plot:interpolate", this.interpolateCB_.isSelected());
        });
        this.bkgdCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:color.background", this.bkgdCombo_.getSelectedColor());
        });
        this.fontCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:labels.font", this.fontCombo_.getSelectedItem().toString());
        });
        this.super10CB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setBoolean("plot:labels.super10", this.super10CB_.isSelected());
        });
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.sizeCombo_.setSelectedSize(prefs_.getInt("plot:size.factor"));
        this.interpolateCB_.setSelected(prefs_.getBoolean("plot:interpolate"));
        this.bkgdCombo_.setSelectedColor(prefs_.getColor("plot:color.background"));
        this.fontCombo_.setSelectedItem(prefs_.getString("plot:labels.font"));
        this.super10CB_.setSelected(prefs_.getBoolean("plot:labels.super10"));
        this.refreshing_ = false;
    }
}

