/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.graphics.AbstractColorTable;
import gov.nasa.giss.ui.table.ColorTableCellRenderer;
import gov.nasa.giss.ui.table.GissTable;
import java.awt.Component;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class PanCommonPrefsTable
extends GissTable {
    public PanCommonPrefsTable(DefaultTableModel model) {
        super(model);
        JTableHeader jth = this.getTableHeader();
        jth.setReorderingAllowed(false);
        this.setAutoResizeMode(2);
        this.setCellSelectionEnabled(false);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        TableColumnModel tcm = this.getColumnModel();
        int icols = this.getColumnCount();
        int irows = this.getRowCount();
        for (int col = 0; col < icols; ++col) {
            TableCellRenderer tcr;
            TableColumn column = tcm.getColumn(col);
            Class<?> cc = model.getColumnClass(col);
            if (AbstractColorTable.class.isAssignableFrom(cc)) {
                column.setCellRenderer(new ColorTableCellRenderer());
            }
            if ((tcr = column.getHeaderRenderer()) == null) {
                tcr = jth.getDefaultRenderer();
            }
            if (tcr instanceof DefaultTableCellRenderer) {
                ((DefaultTableCellRenderer)tcr).setHorizontalAlignment(0);
            }
            Component c = tcr.getTableCellRendererComponent(this, column.getHeaderValue(), false, false, 0, 0);
            int width = c.getPreferredSize().width;
            for (int row = 0; row < irows; ++row) {
                tcr = this.getCellRenderer(row, col);
                Object value = this.getValueAt(row, col);
                if (value == null) continue;
                c = tcr.getTableCellRendererComponent(this, value, false, false, row, col);
                width = Math.max(width, c.getPreferredSize().width);
            }
            column.setPreferredWidth(width);
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        this.repaint();
    }
}

