/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.graphics.ColorTableOutlierShape;
import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanColorComboBox;
import gov.nasa.giss.panoply.ui.PanColorTableComboBox;
import gov.nasa.giss.panoply.ui.PanEnumComboBox;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.util.PanColorbarLabelLocation;
import gov.nasa.giss.panoply.util.PanColorbarOutlierGap;
import gov.nasa.giss.panoply.util.PanColorbarOutlierSide;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.color.PaletteType;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.invoke.MethodHandles;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanColorbarPrefsPanel
extends PanAbstractPrefsPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanColorTableComboBox clutCombo_;
    private PanCheckBox reversedCB_;
    private PanIntSpinner cbarLengthSpinner_;
    private PanEnumComboBox outlierShapeCombo_;
    private PanEnumComboBox outlierSideCombo_;
    private PanEnumComboBox outlierGapCombo_;
    private PanIntSpinner borderWgtSpinner_;
    private PanEnumComboBox cbarLabelPlaceCombo_;
    private PanColorComboBox invalidsCombo_;
    private boolean refreshing_;

    public PanColorbarPrefsPanel() {
        this.setBorder(GuiUtils.createPaddedTitleBorder("Scale Colorbar"));
        this.setOpaque(false);
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        PanLabel topText = PanLabel.create("When creating a color contour plot, set\u2026");
        this.clutCombo_ = PanColorTableComboBox.create(true);
        this.clutCombo_.setToolTipText("Select a default color table to apply to new plots");
        Dimension d = this.clutCombo_.getPreferredSize();
        if (d.width > 320) {
            d.width = 320;
            this.clutCombo_.setPreferredSize(d);
            this.clutCombo_.setMaximumSize(d);
        }
        this.reversedCB_ = PanCheckBox.create("Reverse colors");
        this.cbarLengthSpinner_ = PanIntSpinner.create(60, 50, 100, 5);
        this.outlierShapeCombo_ = PanEnumComboBox.create(ColorTableOutlierShape.class);
        this.outlierSideCombo_ = PanEnumComboBox.create(PanColorbarOutlierSide.class);
        this.outlierGapCombo_ = PanEnumComboBox.create(PanColorbarOutlierGap.class);
        this.borderWgtSpinner_ = PanIntSpinner.create(100, 0, 125, 1);
        this.cbarLabelPlaceCombo_ = PanEnumComboBox.create(PanColorbarLabelLocation.class);
        this.invalidsCombo_ = PanColorComboBox.create(PaletteType.GRAYSCALE);
        FlexingGridLayout fgl = new FlexingGridLayout(4, 11, 0, 2);
        fgl.setColumnWeight(3, 9999.0f);
        this.setLayout(fgl);
        int row = 0;
        this.add((Component)topText, new FGConstraint(0, row, 4, 1));
        this.add((Component)PanLabel.create("Color Table:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)this.clutCombo_, new FGConstraint(1, row));
        this.add((Component)this.reversedCB_, new FGConstraint(1, ++row));
        this.add((Component)PanLabel.create("Fill Color:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(this.invalidsCombo_), new FGConstraint(1, row));
        this.add((Component)PanLabel.create("Length:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(this.cbarLengthSpinner_, PanLabel.create("%")), new FGConstraint(1, row));
        this.add((Component)PanLabel.create("Border:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(PanLabel.create("Weight:\u2009"), this.borderWgtSpinner_), new FGConstraint(1, row));
        this.add((Component)PanLabel.create("Outliers:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(PanLabel.create("On:\u2009"), this.outlierSideCombo_), new FGConstraint(1, row));
        this.add((Component)QuickBox.createLeftBox(PanLabel.create("Shape:\u2009"), this.outlierShapeCombo_, PanLabel.create(", Gap:\u2009"), this.outlierGapCombo_), new FGConstraint(1, ++row));
        this.add((Component)PanLabel.create("Caption:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)this.cbarLabelPlaceCombo_, new FGConstraint(1, row));
        this.cbarLengthSpinner_.setMaximumSize(this.cbarLengthSpinner_.getPreferredSize());
        this.outlierShapeCombo_.setMaximumSize(this.outlierShapeCombo_.getPreferredSize());
        this.outlierGapCombo_.setMaximumSize(this.outlierGapCombo_.getPreferredSize());
    }

    private void attachListeners() {
        this.clutCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.setString("plot:colorbar.name", this.clutCombo_.getSelectedItem().toString());
        });
        this.reversedCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setBoolean("plot:colorbar.reverse", this.reversedCB_.isSelected());
        });
        this.cbarLengthSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setInt("plot:colorbar.length", this.cbarLengthSpinner_.getIntValue());
        });
        this.outlierSideCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:colorbar.outlier.side", this.outlierSideCombo_.getStringValue());
        });
        this.outlierShapeCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:colorbar.outlier.shape", this.outlierShapeCombo_.getStringValue());
        });
        this.outlierGapCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:colorbar.outlier.gap", this.outlierGapCombo_.getStringValue());
        });
        this.borderWgtSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setInt("plot:colorbar.border.weight", this.borderWgtSpinner_.getIntValue());
        });
        this.cbarLabelPlaceCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:scale.label.location", this.cbarLabelPlaceCombo_.getStringValue());
        });
        this.invalidsCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:colorbar.invalids", this.invalidsCombo_.getSelectedColor());
        });
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.clutCombo_.setSelectedItemByName(prefs_.getString("plot:colorbar.name"));
        this.reversedCB_.setSelected(prefs_.getBoolean("plot:colorbar.reverse"));
        this.cbarLengthSpinner_.setValue(prefs_.getInt("plot:colorbar.length"));
        this.borderWgtSpinner_.setValue(prefs_.getInt("plot:colorbar.border.weight"));
        this.invalidsCombo_.setSelectedColor(prefs_.getColor("plot:colorbar.invalids"));
        this.outlierShapeCombo_.setSelectedItem(prefs_.getString("plot:colorbar.outlier.shape"));
        this.outlierSideCombo_.setSelectedItem(prefs_.getString("plot:colorbar.outlier.side"));
        this.outlierGapCombo_.setSelectedItem(prefs_.getString("plot:colorbar.outlier.gap"));
        this.cbarLabelPlaceCombo_.setSelectedItem(prefs_.getString("plot:scale.label.location"));
        this.refreshing_ = false;
    }
}

