/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefs;

import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.prefs.PanPreferenceUtils;
import gov.nasa.giss.panoply.prefs.PanSavedSettings;
import gov.nasa.giss.text.StringUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.util.EasyXmlParser;
import gov.nasa.giss.util.PlatformUtils;
import gov.nasa.giss.util.ResourceListDataEvent;
import gov.nasa.giss.util.ResourceListDataListener;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import javax.swing.event.EventListenerList;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanSavedSettingsList {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String STYPE = "xsettings";
    private File settingsFile_;
    private final ArrayList<PanSavedSettings> internalList_ = new ArrayList(50);
    private EventListenerList listeners_;

    public static PanSavedSettingsList getSharedInstance() {
        return Singleton.INSTANCE;
    }

    private PanSavedSettingsList() {
        try {
            this.settingsFile_ = PanPreferenceUtils.findSavedSettingsFile(STYPE, 4);
            if (this.settingsFile_ == null) {
                LOGGER.warn("Got null constructing saved settings File object.");
            } else if (this.settingsFile_.exists()) {
                this.read();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.listeners_ = new EventListenerList();
    }

    private void read() {
        block7: {
            try (FileInputStream is = new FileInputStream(this.settingsFile_);){
                this.readStream(is);
            }
            catch (Exception exc) {
                LOGGER.warn("Exception reading {} file: {}", (Object)STYPE, (Object)exc.toString());
                if (!LOGGER.isDebugEnabled()) break block7;
                exc.printStackTrace();
            }
        }
    }

    private void readStream(InputStream istream) throws IOException, JDOMException {
        Document document = EasyXmlParser.parseDocument(istream);
        Element root = document.getRootElement();
        String rootName = root.getName();
        if (!"application".equals(rootName) && !"gissapp".equals(rootName)) {
            LOGGER.warn("Root of {} XML tree is not 'application' or 'gissapp'.", (Object)STYPE);
            LOGGER.warn("{} file content will be ignored.", (Object)StringUtils.ucfirst(STYPE));
            LOGGER.warn("{} file will be overwritten on exit.", (Object)StringUtils.ucfirst(STYPE));
            return;
        }
        try {
            String name = root.getAttribute("name").getValue();
            if (!"Panoply".equalsIgnoreCase(name)) {
                LOGGER.warn("Root of {} file XML tree has wrong 'application' value.", (Object)STYPE);
                LOGGER.warn("Undesired results will probably occur parsing the file.");
                LOGGER.warn("{} file will be overwritten on exit.", (Object)StringUtils.ucfirst(STYPE));
            }
        }
        catch (Exception exc) {
            LOGGER.warn("Could not read 'application' attribute in {} root element.", (Object)STYPE);
            LOGGER.warn("Undesired results will probably occur parsing the file.");
            LOGGER.warn("{} file will be overwritten on exit.", (Object)StringUtils.ucfirst(STYPE));
        }
        try {
            String ftype = root.getAttribute("type").getValue();
            if (!STYPE.equalsIgnoreCase(ftype)) {
                LOGGER.warn("Root of {} file XML tree has wrong 'type' value.", (Object)STYPE);
                LOGGER.warn("Undesired results will probably occur parsing the file.");
                LOGGER.warn("{} file will be overwritten on exit.", (Object)StringUtils.ucfirst(STYPE));
            }
        }
        catch (Exception exc) {
            LOGGER.warn("Could not read 'type' attribute in {} root element.", (Object)STYPE);
            LOGGER.warn("Undesired results will probably occur parsing the file.");
            LOGGER.warn("{} file will be overwritten on exit.", (Object)StringUtils.ucfirst(STYPE));
        }
        for (Element child : root.getChildren()) {
            String childName = child.getName();
            if ("group".equals(childName)) {
                PanSavedSettings pss = new PanSavedSettings(child);
                this.add(pss);
                continue;
            }
            LOGGER.warn("Child '{}' of {} root is not 'group'.", (Object)STYPE, (Object)childName);
        }
    }

    public void save() {
        File backup;
        block32: {
            block31: {
                if (this.settingsFile_ == null) {
                    LOGGER.warn("No {} File object exists; {} will not be saved.", (Object)STYPE, (Object)STYPE);
                    return;
                }
                backup = null;
                try {
                    String bkpName = this.settingsFile_.toString() + "_bkp";
                    backup = new File(bkpName);
                }
                catch (Exception exc) {
                    backup = null;
                }
                if (backup != null) {
                    try (FileInputStream fis = new FileInputStream(this.settingsFile_);
                         FileOutputStream fos = new FileOutputStream(backup);
                         FileChannel inputChannel = fis.getChannel();
                         FileChannel outputChannel = fos.getChannel();){
                        outputChannel.transferFrom(inputChannel, 0L, inputChannel.size());
                    }
                    catch (Exception exc) {
                        LOGGER.warn("Exception saving {} backup: {}", (Object)STYPE, (Object)exc.toString());
                        if (!LOGGER.isTraceEnabled()) break block31;
                        exc.printStackTrace();
                    }
                }
            }
            try {
                this.save(this.settingsFile_);
            }
            catch (Exception exc) {
                LOGGER.warn("Exception saving {}: {}", (Object)STYPE, (Object)exc);
                if (!LOGGER.isTraceEnabled()) break block32;
                exc.printStackTrace();
            }
        }
        if (backup != null && backup.exists()) {
            backup.delete();
        }
    }

    public void save(File f) {
        block9: {
            try (FileOutputStream fos = new FileOutputStream(f);){
                this.saveStream(fos);
            }
            catch (Exception exc) {
                if (PlatformUtils.isHeadless()) {
                    LOGGER.warn("failed to write {} due to exception: {}", (Object)STYPE, (Object)exc.toString());
                } else {
                    GuiUtils.showSlowMessage(null, "File Error", "I encountered an error while savings xsettings.\n" + exc.toString());
                }
                if (!LOGGER.isDebugEnabled()) break block9;
                exc.printStackTrace();
            }
        }
    }

    protected void saveStream(OutputStream ostream) throws IOException {
        block3: {
            Objects.requireNonNull(ostream, "Null output stream.");
            Element root = new Element("gissapp");
            root.setAttribute("name", "Panoply".toLowerCase());
            root.setAttribute("type", STYPE);
            root.setAttribute("version", "4.11.1");
            root.setAttribute("locale", Locale.getDefault().toString());
            for (int i = 0; i < this.size(); ++i) {
                PanSavedSettings group = this.get(i);
                group.writeXml(root);
            }
            Document d = new Document(root);
            XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
            try {
                outputter.output(d, ostream);
            }
            catch (Exception exc) {
                if (!LOGGER.isTraceEnabled()) break block3;
                exc.printStackTrace();
            }
        }
    }

    public int size() {
        return this.internalList_.size();
    }

    public PanSavedSettings get(String name) {
        for (int i = 0; i < this.size(); ++i) {
            PanSavedSettings pss = this.get(i);
            if (!pss.getName().equals(name)) continue;
            return pss;
        }
        return null;
    }

    public PanSavedSettings get(int index) {
        return this.internalList_.get(index);
    }

    public void add(String name, PanPlotMeta pmeta) {
        PanSavedSettings pss = new PanSavedSettings(name, pmeta);
        this.add(pss);
    }

    public boolean add(PanSavedSettings element) {
        if (this.internalList_.add(element)) {
            this.fireIntervalAdded(null, this.size() - 1);
            return true;
        }
        return false;
    }

    public void add(int index, PanSavedSettings element) {
        this.internalList_.add(index, element);
        this.fireIntervalAdded(null, index);
    }

    public void clear() {
        this.internalList_.clear();
        this.fireContentsChanged(null);
    }

    public PanSavedSettings remove(int index) {
        PanSavedSettings element = this.internalList_.remove(index);
        this.fireIntervalRemoved(null, index);
        return element;
    }

    public boolean remove(PanSavedSettings element) {
        int index = this.internalList_.indexOf(element);
        if (index < 0) {
            return false;
        }
        this.internalList_.remove(element);
        this.fireIntervalRemoved(null, index);
        return true;
    }

    public void sortByType() {
        this.internalList_.sort((o1, o2) -> o1.compareByType((PanSavedSettings)o2));
        this.fireContentsChanged(null);
    }

    public void sortByName() {
        this.internalList_.sort((o1, o2) -> o1.compareByName((PanSavedSettings)o2));
        this.fireContentsChanged(null);
    }

    public void sortByDate() {
        this.internalList_.sort((o1, o2) -> o1.compareByDate((PanSavedSettings)o2));
        this.fireContentsChanged(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListDataListener(ResourceListDataListener l) {
        EventListenerList eventListenerList = this.listeners_;
        synchronized (eventListenerList) {
            this.listeners_.add(ResourceListDataListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListDataListener(ResourceListDataListener l) {
        EventListenerList eventListenerList = this.listeners_;
        synchronized (eventListenerList) {
            this.listeners_.remove(ResourceListDataListener.class, l);
        }
    }

    private void fireContentsChanged(Component component) {
        if (this.listeners_ == null) {
            return;
        }
        ResourceListDataEvent e = new ResourceListDataEvent(this, component, 0, 0, -1);
        for (ResourceListDataListener l : (ResourceListDataListener[])this.listeners_.getListeners(ResourceListDataListener.class)) {
            l.contentsChanged(e);
        }
    }

    private void fireIntervalAdded(Component component, int index) {
        if (this.listeners_ == null) {
            return;
        }
        ResourceListDataEvent e = new ResourceListDataEvent(this, component, 1, index, index);
        for (ResourceListDataListener l : (ResourceListDataListener[])this.listeners_.getListeners(ResourceListDataListener.class)) {
            l.intervalAdded(e);
        }
    }

    private void fireIntervalRemoved(Component component, int index) {
        if (this.listeners_ == null) {
            return;
        }
        ResourceListDataEvent e = new ResourceListDataEvent(this, component, 2, index, index);
        for (ResourceListDataListener l : (ResourceListDataListener[])this.listeners_.getListeners(ResourceListDataListener.class)) {
            l.intervalRemoved(e);
        }
    }

    private static class Singleton {
        private static final PanSavedSettingsList INSTANCE = new PanSavedSettingsList();

        private Singleton() {
        }
    }
}

