/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefs;

import gov.nasa.giss.data.nc.NcVarClass;
import gov.nasa.giss.data.nc.NcVarSorting;
import gov.nasa.giss.graphics.AbstractColorTable;
import gov.nasa.giss.graphics.ColorTableOutlierShape;
import gov.nasa.giss.graphics.ColorUtils;
import gov.nasa.giss.graphics.PaperSize;
import gov.nasa.giss.map.SymbolID;
import gov.nasa.giss.map.overlay.MapOverlay;
import gov.nasa.giss.panoply.prefs.PanBookmarksList;
import gov.nasa.giss.panoply.prefs.PanHistoryList;
import gov.nasa.giss.panoply.prefs.PanProjectionPrefs;
import gov.nasa.giss.panoply.util.PanAnimationFormat;
import gov.nasa.giss.panoply.util.PanAxisMethod;
import gov.nasa.giss.panoply.util.PanAxisTickColor;
import gov.nasa.giss.panoply.util.PanColorbarLabelLocation;
import gov.nasa.giss.panoply.util.PanColorbarOutlierGap;
import gov.nasa.giss.panoply.util.PanColorbarOutlierSide;
import gov.nasa.giss.panoply.util.PanContourLocation;
import gov.nasa.giss.panoply.util.PanContourStyle;
import gov.nasa.giss.panoply.util.PanParamKeys;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.panoply.util.PanScaleMethod;
import gov.nasa.giss.panoply.util.PanStrokePattern;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.panoply.util.PanVectorStyle;
import gov.nasa.giss.prefs.AbstractPreferences;
import gov.nasa.giss.prefs.PreferencesHash;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.util.EasyXmlParser;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.util.Locale;
import java.util.Objects;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanPreferences
extends AbstractPreferences {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final int MAJOR_VERSION = 4;
    static final String PREFS_VERSION = "4.11.1";
    private static final String NONE = "NONE";

    public static PanPreferences getSharedInstance() {
        return Singleton.INSTANCE;
    }

    private PanPreferences() {
        super("Panoply", "gov.nasa.giss", ".gissjava");
    }

    @Override
    public synchronized void restoreDefaults() {
        this.set("beta:numberlays", false);
        this.set("beta:underlays", false);
        this.set("files:open.path", System.getProperty("user.home"));
        this.set("files:save.path", System.getProperty("user.home"));
        this.set("files:launch.dialog", true);
        this.set("files:save.image.dialog", false);
        this.set("files:save.image.fext", "PNG");
        this.set("files:save.pspdf.paper", PaperSize.LETTER.name().toLowerCase());
        this.set("files:save.pspdf.vectorized", false);
        this.set("files:save.kmz.scale", true);
        this.set("files:save.kmz.knockout", true);
        this.set("files:save.kmz.border", false);
        this.set("files:save.anim.fext", PanAnimationFormat.MP4.name().toLowerCase());
        this.set("files:save.anim.frate", 8);
        this.set("files:save.anim.quality", 100);
        this.set("files:save.anim.subtitles.vis", true);
        this.set("files:save.anim.subtitles.type", "value");
        this.set("files:save.anim.options", false);
        this.set("files:save.export.warning", true);
        this.set("files:grib.strict", true);
        this.set("files:history.days", 30);
        this.set("files:autoimport.colorbars", false);
        this.set("files:autoimport.overlays", false);
        this.set("files:autoimport.underlays", false);
        this.set("app:version.enabled", true);
        this.set("app:version.count", 0);
        this.set("app:version.last", PanProperties.VERSION_PROPS.getString("build-date"));
        this.set("app:version.next", PanProperties.VERSION_PROPS.getString("build-date"));
        this.set("app:version.skip", "");
        this.set("sources:bounds.left", -1);
        this.set("sources:bounds.top", -1);
        this.set("sources:bounds.width", 600);
        this.set("sources:bounds.height", 500);
        this.set("sources:nodes.expanded", true);
        this.set("sources:toolbar.labels", true);
        this.set("sources:info.vis", true);
        this.set("sources:info.width", 30);
        this.set("sources:info.enhanced", false);
        this.set("sources:datasets.sorting", NcVarSorting.ALPHA.name().toLowerCase());
        this.set("sources:datasets.varclass", NcVarClass.ALL.name().toLowerCase());
        this.set("sources:catalogs.find.warned", false);
        this.set("plot:size.factor", 140);
        this.set("plot:color.background", Color.WHITE);
        this.set("plot:labels.font", "SansSerif");
        this.set("plot:labels.super10", false);
        this.set("plot:lineplot.grid.style", PanStrokePattern.SOLID.name().toLowerCase());
        this.set("plot:lineplot.grid.weight", 50);
        this.set("plot:lineplot.axes.offset", true);
        this.set("plot:lineplot.axes.tickmark.weight", 100);
        this.set("plot:lineplot.axes.tickmark.color", PanAxisTickColor.BORDER.name().toLowerCase());
        this.set("plot:lineplot.xaxis.label.size", Float.valueOf(11.0f));
        this.set("plot:lineplot.yaxis.label.size", Float.valueOf(11.0f));
        this.set("plot:lineplot.xaxis.tick.size", Float.valueOf(9.0f));
        this.set("plot:lineplot.yaxis.tick.size", Float.valueOf(9.0f));
        this.set("plot:ccplot.grid.color", Color.BLACK);
        this.set("plot:ccplot.grid.style", PanStrokePattern.SOLID.name().toLowerCase());
        this.set("plot:ccplot.grid.weight", 50);
        this.set("plot:ccplot.axes.offset", false);
        this.set("plot:ccplot.axes.tickmark.weight", 100);
        this.set("plot:ccplot.axes.tickmark.color", PanAxisTickColor.BORDER.name().toLowerCase());
        this.set("plot:ccplot.xaxis.label.size", Float.valueOf(11.0f));
        this.set("plot:ccplot.yaxis.label.size", Float.valueOf(11.0f));
        this.set("plot:ccplot.xaxis.tick.size", Float.valueOf(9.0f));
        this.set("plot:ccplot.yaxis.tick.size", Float.valueOf(9.0f));
        this.set("plot:xaxis.div.major", 6);
        this.set("plot:yaxis.div.major", 6);
        this.set("plot:xaxis.div.minor", 2);
        this.set("plot:yaxis.div.minor", 2);
        this.set("plot:interpolate", true);
        this.set("plot:scale.autofit", false);
        this.set("plot:scale.method", PanScaleMethod.SCALAR.name().toLowerCase());
        this.set("plot:scale.exponent", 0);
        this.set("plot:scale.div.major", 5);
        this.set("plot:scale.div.minor", 2);
        this.set("plot:colorbar.name", "panoply.act");
        this.set("plot:colorbar.invalids", new Color(191, 191, 191));
        this.set("plot:colorbar.reverse", false);
        this.set("plot:colorbar.length", 60);
        this.set("plot:colorbar.border.weight", 100);
        this.set("plot:colorbar.outlier.shape", ColorTableOutlierShape.TRIANGLE.name().toLowerCase());
        this.set("plot:colorbar.outlier.side", PanColorbarOutlierSide.BOTH.name().toLowerCase());
        this.set("plot:colorbar.outlier.gap", PanColorbarOutlierGap.THIN.name().toLowerCase());
        this.set("plot:scale.label.location", PanColorbarLabelLocation.ABOVE.name().toLowerCase());
        this.set("plot:scale.tick.size", Float.valueOf(11.0f));
        this.set("plot:scale.tick.format", "%.1f");
        this.set("plot:footnote.minmax.vis", true);
        this.set("plot:footnote.minmax.format", "Same");
        this.set("plot:contour.style", PanContourStyle.NONE.name().toLowerCase());
        this.set("plot:contour.color", Color.BLACK);
        this.set("plot:contour.weight", 75);
        this.set("plot:contour.location", PanContourLocation.MAJOR.name().toLowerCase());
        this.set("plot:contour.label.vis", false);
        this.set("plot:contour.label.size", Float.valueOf(6.5f));
        this.set("plot:vector.style", PanVectorStyle.ARROW.name().toLowerCase());
        this.set("plot:vector.color", Color.BLACK);
        this.set("plot:vector.weight", 75);
        this.set("plot:vector.spacing", 110);
        this.set("plot:vector.sample", true);
        this.set(PanParamKeys.P_LINE_STROKE_COLOR[0], Color.RED);
        this.set(PanParamKeys.P_LINE_STROKE_COLOR[1], Color.BLUE);
        this.set(PanParamKeys.P_LINE_STROKE_STYLE[0], PanStrokePattern.SOLID.name().toLowerCase());
        this.set(PanParamKeys.P_LINE_STROKE_STYLE[1], PanStrokePattern.SOLID.name().toLowerCase());
        this.set(PanParamKeys.P_LINE_STROKE_WGT[0], 150);
        this.set(PanParamKeys.P_LINE_STROKE_WGT[1], 150);
        this.set(PanParamKeys.P_TRAJ_STROKE_COLOR[0], Color.BLACK);
        this.set(PanParamKeys.P_TRAJ_STROKE_COLOR[1], Color.RED);
        this.set(PanParamKeys.P_TRAJ_STROKE_STYLE[0], NONE);
        this.set(PanParamKeys.P_TRAJ_STROKE_STYLE[1], NONE);
        this.set(PanParamKeys.P_TRAJ_STROKE_WGT[0], 50);
        this.set(PanParamKeys.P_TRAJ_STROKE_WGT[1], 50);
        this.set("plot:xy.size.width", 80);
        this.set("plot:xy.size.height", 40);
        this.set("plot:xy.xaxis.div.major", 5);
        this.set("plot:xy.xaxis.div.minor", 2);
        this.set("plot:xy.xaxis.tick.format", "%.1f");
        this.set("plot:xy.yaxis.div.major", 5);
        this.set("plot:xy.yaxis.div.minor", 2);
        this.set("plot:xy.yaxis.tick.format", "%.1f");
        this.set("plot:xy.yaxis.posup", true);
        this.set("plot:lonlat.size.width", 100);
        this.set("plot:lonlat.size.height", 50);
        this.set("plot:lonlat.proj.name", "Equirectangular");
        this.set("plot:lonlat.proj.lon0", 0.0);
        this.set("plot:lonlat.proj.lat0", 0.0);
        this.set("plot:lonlat.border.weight", 150);
        this.set("plot:grid.spacing.lon", Float.valueOf(15.0f));
        this.set("plot:grid.spacing.lat", Float.valueOf(15.0f));
        this.set("plot:grid.offset.lat", false);
        this.set("plot:grid.label.step", 0);
        this.set("plot:grid.label.size", Float.valueOf(6.5f));
        this.set(PanParamKeys.P_OVERLAY_NAME[0], PanUtils.getDefaultOverlayName());
        this.set(PanParamKeys.P_OVERLAY_COLOR[0], Color.BLACK);
        this.set(PanParamKeys.P_OVERLAY_INVERT[0], false);
        this.set(PanParamKeys.P_OVERLAY_STYLE[0], PanStrokePattern.SOLID.name().toLowerCase());
        this.set(PanParamKeys.P_OVERLAY_SYMBOL_ID[0], SymbolID.DOT.name().toLowerCase());
        this.set(PanParamKeys.P_OVERLAY_SYMBOL_SIZE[0], Float.valueOf(6.0f));
        this.set(PanParamKeys.P_OVERLAY_WGT[0], 75);
        try {
            for (int i = 1; i < 3; ++i) {
                this.set(PanParamKeys.P_OVERLAY_NAME[i], NONE);
                this.set(PanParamKeys.P_OVERLAY_COLOR[i], Color.GRAY);
                this.set(PanParamKeys.P_OVERLAY_INVERT[i], false);
                this.set(PanParamKeys.P_OVERLAY_STYLE[i], PanStrokePattern.SOLID.name().toLowerCase());
                this.set(PanParamKeys.P_OVERLAY_SYMBOL_ID[i], SymbolID.DOT.name().toLowerCase());
                this.set(PanParamKeys.P_OVERLAY_SYMBOL_SIZE[i], Float.valueOf(6.0f));
                this.set(PanParamKeys.P_OVERLAY_WGT[i], 50);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.set("plot:lonlat.vector.dir1", "East");
        this.set("plot:lonlat.vector.dir2", "North");
        this.set("plot:llzonal.xaxis.begin", -90.0);
        this.set("plot:llzonal.xaxis.end", 90.0);
        this.set("plot:lonlat.proj.shading.vis", false);
        this.set("plot:lonlat.proj.shading.opacity", 40);
        this.set("plot:lonlat.proj.subsolar.lon", -74.0);
        this.set("plot:lonlat.proj.subsolar.lat", 23.0);
        this.set("plot:beta.numberlay.enabled", false);
        this.set("plot:beta.numberlay.invalids", true);
        this.set("plot:beta.numberlay.color", Color.BLACK);
        this.set("plot:beta.numberlay.weight", 75);
        this.set("plot:beta.numberlay.size", Float.valueOf(6.5f));
        this.set("plot:beta.numberlay.spacing.lon", 10.0);
        this.set("plot:beta.numberlay.spacing.lat", 8.0);
        this.set("plot:beta.numberlay.offset.lon", false);
        this.set("plot:beta.numberlay.offset.lat", true);
        this.set(PanParamKeys.P_FEATURE_SYMBOL_ID[0], SymbolID.CIRCLE.name().toLowerCase());
        this.set(PanParamKeys.P_FEATURE_SYMBOL_SIZE[0], Float.valueOf(6.0f));
        this.set(PanParamKeys.P_FEATURE_SYMBOL_FILL[0], true);
        this.set(PanParamKeys.P_FEATURE_SYMBOL_ID[1], SymbolID.SQUARE.name().toLowerCase());
        this.set(PanParamKeys.P_FEATURE_SYMBOL_SIZE[1], Float.valueOf(6.0f));
        this.set(PanParamKeys.P_FEATURE_SYMBOL_FILL[1], true);
        this.set("plot:feature.background", new Color(127, 127, 127));
        this.set("plot:feature.nanskip", true);
        this.set("plot:lattime.size.width", 80);
        this.set("plot:lattime.size.height", 45);
        this.set("plot:lattime.xaxis.begin", -90.0);
        this.set("plot:lattime.xaxis.end", 90.0);
        this.set("plot:latvert.size.width", 80);
        this.set("plot:latvert.size.height", 45);
        this.set("plot:latvert.xaxis.begin", -90.0);
        this.set("plot:latvert.xaxis.end", 90.0);
        this.set("plot:latvert.yaxis.method", PanAxisMethod.SCALAR.name().toLowerCase());
        this.set("plot:latvert.yaxis.tick.format", "%.1f");
        this.set("plot:lontime.size.width", 80);
        this.set("plot:lontime.size.height", 45);
        this.set("plot:lontime.xaxis.begin", -180.0);
        this.set("plot:lontime.xaxis.end", 180.0);
        this.set("plot:lonvert.size.width", 80);
        this.set("plot:lonvert.size.height", 45);
        this.set("plot:lonvert.xaxis.begin", -180.0);
        this.set("plot:lonvert.xaxis.end", 180.0);
        this.set("plot:lonvert.yaxis.method", PanAxisMethod.SCALAR.name().toLowerCase());
        this.set("plot:lonvert.yaxis.tick.format", "%.1f");
        this.set("plot:timelat.size.width", 80);
        this.set("plot:timelat.size.height", 45);
        this.set("plot:timelat.xaxis.div.major", 5);
        this.set("plot:timelat.xaxis.div.minor", 2);
        this.set("plot:timelat.yaxis.end", 90.0);
        this.set("plot:timelat.yaxis.begin", -90.0);
        this.set("plot:timevert.size.width", 80);
        this.set("plot:timevert.size.height", 45);
        this.set("plot:timevert.xaxis.div.major", 5);
        this.set("plot:timevert.xaxis.div.minor", 2);
        this.set("plot:timevert.yaxis.method", PanAxisMethod.SCALAR.name().toLowerCase());
        this.set("plot:timevert.yaxis.tick.format", "%.1f");
        this.set("plot:lineplot.grid.style", PanStrokePattern.SOLID.name().toLowerCase());
        this.set("plot:lineplot.grid.weight", 50);
        this.set("plot:lineplot.horz.size.width", 80);
        this.set("plot:lineplot.horz.size.height", 40);
        this.set("plot:lineplot.vert.size.width", 80);
        this.set("plot:lineplot.vert.size.height", 60);
        this.set("units:c_is_celsius", false);
        this.set("units:mb_is_millibar", false);
        this.set("units:fraction_is_percent", false);
        PanProjectionPrefs.getSharedInstance();
    }

    @Override
    protected void readStream(InputStream istream) throws IOException, JDOMException {
        Document document = EasyXmlParser.parseDocument(istream);
        Element root = document.getRootElement();
        String rootName = root.getName();
        if (!"application".equals(rootName) && !"gissapp".equals(rootName)) {
            LOGGER.warn("Root of prefs XML tree is not 'application' or 'gissapp'.");
            LOGGER.warn("Prefs file content will be ignored.");
            LOGGER.warn("Prefs file content will be overwritten when Panoply exits.");
            return;
        }
        try {
            String name = root.getAttribute("name").getValue();
            if (!name.equalsIgnoreCase(this.getAppName())) {
                LOGGER.warn("Root of prefs file XML tree has wrong application name.");
                LOGGER.warn("Prefs file content will be ignored.");
                LOGGER.warn("Prefs file content will be overwritten when Panoply exits.");
                return;
            }
        }
        catch (Exception exc) {
            LOGGER.warn("Could not read application name in prefs file.");
            LOGGER.warn("Prefs file content will be ignored.");
            LOGGER.warn("Prefs file content will be overwritten when Panoply exits.");
            return;
        }
        String version = PREFS_VERSION;
        try {
            Attribute versionA = root.getAttribute("version");
            if (versionA != null && ((version = versionA.getValue()) == null || version.isEmpty())) {
                version = PREFS_VERSION;
            }
        }
        catch (Exception exc) {
            LOGGER.warn("Could not parse prefs file version.");
            LOGGER.warn("Prefs file content will be ignored.");
            LOGGER.warn("Prefs file will be overwritten when Panoply exits.");
            return;
        }
        if (version.compareTo(PREFS_VERSION) < 0) {
            LOGGER.warn("Prefs file is older version.");
            LOGGER.warn("Defunct keys will be ignored if encountered.");
        } else if (version.compareTo(PREFS_VERSION) > 0) {
            LOGGER.warn("Prefs file is newer version?");
            LOGGER.warn("Unknown keys will be ignored if encountered.");
        }
        boolean skipMost = false;
        try {
            Attribute plocaleA = root.getAttribute("locale");
            if (plocaleA == null) {
                LOGGER.trace("No prefs locale specified");
            } else {
                String locale = Locale.getDefault().toString();
                String plocale = plocaleA.getValue();
                if (!plocale.equalsIgnoreCase(locale)) {
                    LOGGER.warn("Prefs locale {} does not match system locale {}.", (Object)plocale, (Object)locale);
                    LOGGER.warn("Prefs content will not be read except for bookmarks and history.");
                    LOGGER.warn("Prefs content will be overwritten on exit.");
                    skipMost = true;
                }
            }
        }
        catch (Exception exc) {
            LOGGER.warn("Could not read prefs locale.");
            LOGGER.warn("Prefs content will not be read except for bookmarks and history.");
            LOGGER.warn("Prefs content will be overwritten on exit.");
            skipMost = true;
        }
        for (Element child : root.getChildren()) {
            String childName = child.getName();
            if ("property".equals(childName)) {
                this.readProperty(this, child);
                continue;
            }
            if ("group".equals(childName)) {
                String pkey = null;
                try {
                    pkey = child.getAttribute("key").getValue();
                }
                catch (Exception exc) {
                    LOGGER.warn("Exception extracting pref group key.");
                    return;
                }
                if (pkey == null) {
                    LOGGER.warn("Pref group has no key.");
                    continue;
                }
                if ("bookmarks".equals(pkey) || "history".equals(pkey)) {
                    PanBookmarksList.getSharedInstance().read(child);
                    continue;
                }
                if ("projections".equals(pkey)) {
                    PanProjectionPrefs.getSharedInstance().read(child);
                    continue;
                }
                if ("colortables".equals(pkey) || "overlays".equals(pkey)) {
                    LOGGER.trace("Encountered {}, but this is Panoply 4", (Object)pkey);
                    continue;
                }
                if (skipMost) continue;
                this.readGroup(this, child);
                continue;
            }
            LOGGER.warn("Ignoring unknown pref key {} in root group.", (Object)childName);
        }
    }

    private void readGroup(PreferencesHash parent, Element group) {
        String pkey = null;
        try {
            pkey = group.getAttribute("key").getValue();
        }
        catch (Exception exc) {
            LOGGER.warn("Exception extracting pref group key.");
            return;
        }
        if (pkey == null) {
            LOGGER.warn("Pref group has no key.");
            return;
        }
        Object already = parent.get(pkey);
        if (already == null) {
            LOGGER.warn("Unknown pref group {}.", (Object)pkey);
            return;
        }
        if (!(already instanceof PreferencesHash)) {
            LOGGER.warn("Existing pref {} is not a subgroup.", (Object)pkey);
            return;
        }
        PreferencesHash pg = (PreferencesHash)already;
        for (Element child : group.getChildren()) {
            String childName = child.getName();
            if ("property".equals(childName)) {
                this.readProperty(pg, child);
                continue;
            }
            if ("group".equals(childName)) {
                this.readGroup(pg, child);
                continue;
            }
            LOGGER.warn("Ignoring key {} in group {}; may be old key.", (Object)childName, (Object)pkey);
        }
    }

    private void readProperty(PreferencesHash parent, Element child) {
        String pkey = null;
        String pvalue = null;
        try {
            pkey = child.getAttribute("key").getValue();
            pvalue = child.getAttribute("value").getValue();
        }
        catch (Exception exc) {
            LOGGER.warn("Unable to parse a pref property.");
            return;
        }
        if (pkey == null) {
            LOGGER.warn("Pref element has no key.");
            return;
        }
        if (!parent.containsKey(pkey)) {
            LOGGER.warn("Ignoring unknown pref key {} in group {}", (Object)pkey, (Object)parent.getName());
            return;
        }
        Object already = parent.get(pkey);
        if (already instanceof Boolean) {
            parent.set(pkey, Boolean.valueOf(pvalue));
        } else if (already instanceof Double) {
            try {
                parent.setDouble(pkey, pvalue);
            }
            catch (Exception exc) {
                LOGGER.warn("Bad double for key {}", (Object)pkey);
            }
        } else if (already instanceof Float) {
            try {
                parent.setFloat(pkey, pvalue);
            }
            catch (Exception exc) {
                LOGGER.warn("Bad float for key {}", (Object)pkey);
            }
        } else if (already instanceof Integer) {
            try {
                parent.setInt(pkey, pvalue);
            }
            catch (Exception exc) {
                LOGGER.warn("Bad int for key {}", (Object)pkey);
            }
        } else if (already instanceof String) {
            parent.set(pkey, pvalue);
        } else if (already instanceof Color) {
            try {
                parent.setColor(pkey, pvalue);
            }
            catch (Exception exc) {
                LOGGER.warn("Bad color for key {}", (Object)pkey);
            }
        } else {
            if (already == null) {
                LOGGER.warn("Ignoring null pref value for key {} as type is unknown", (Object)pkey);
                return;
            }
            LOGGER.warn("No class handler for pref property key {}", (Object)pkey);
            LOGGER.warn("Object is {}", already);
        }
    }

    @Override
    protected void saveStream(OutputStream ostream) throws IOException {
        block2: {
            Objects.requireNonNull(ostream, "Null output stream.");
            Element root = new Element("gissapp");
            root.setAttribute("name", this.getAppName().toLowerCase());
            root.setAttribute("version", PREFS_VERSION);
            root.setAttribute("locale", Locale.getDefault().toString());
            this.writeGroup(this, root);
            PanProjectionPrefs.getSharedInstance().write(root);
            PanBookmarksList.getSharedInstance().write(root);
            PanHistoryList.getSharedInstance().write(root);
            Document d = new Document(root);
            XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
            try {
                outputter.output(d, ostream);
            }
            catch (Exception exc) {
                if (!LOGGER.isTraceEnabled()) break block2;
                exc.printStackTrace();
            }
        }
    }

    private void writeGroup(PreferencesHash group, Element element) {
        for (String pkey : group.keySet()) {
            Object pvalue = group.get(pkey);
            Element ex = null;
            if (pvalue instanceof PreferencesHash) {
                PreferencesHash pg = (PreferencesHash)pvalue;
                ex = new Element("group");
                ex.setAttribute("key", pkey);
                this.writeGroup(pg, ex);
            } else {
                ex = new Element("property");
                ex.setAttribute("key", pkey);
                if (pkey.contains("lonlat.overlay.") && !pkey.contains("lonlat.overlay.1") && !pkey.contains("lonlat.overlay.2") && !pkey.contains("lonlat.overlay.3")) continue;
                if (pvalue == null && pkey.contains("lonlat.overlay.") && pkey.endsWith("name")) {
                    ex.setAttribute("value", NONE);
                } else if (pvalue instanceof Double || pvalue instanceof Float) {
                    ex.setAttribute("value", PrintfFormat.PFORMAT_10G.sprintfx(pvalue));
                } else if (pvalue instanceof Color) {
                    String s = ColorUtils.colorToString((Color)pvalue);
                    ex.setAttribute("value", s);
                } else if (pvalue instanceof AbstractColorTable) {
                    ex.setAttribute("value", ((AbstractColorTable)pvalue).toString());
                } else if (pvalue instanceof MapOverlay) {
                    ex.setAttribute("value", ((MapOverlay)pvalue).toString());
                } else {
                    try {
                        ex.setAttribute("value", pvalue.toString());
                    }
                    catch (Exception exc) {
                        LOGGER.error("Exception writing pref {}, {}", (Object)pkey, (Object)exc.toString());
                    }
                }
            }
            element.addContent(ex);
        }
    }

    private static class Singleton {
        private static final PanPreferences INSTANCE = new PanPreferences();

        private Singleton() {
        }
    }
}

