/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui.table;

import gov.nasa.giss.data.nc.array.NcArray1D;
import gov.nasa.giss.panoply.plotui.table.PanArrayTableModel;

public final class PanArray1DTableModel
extends PanArrayTableModel {
    protected NcArray1D array_;
    protected Direction direction_;

    public PanArray1DTableModel(NcArray1D array, Direction direction) {
        this.array_ = array;
        this.direction_ = direction;
    }

    @Override
    public int getColumnCount() {
        if (this.direction_ == Direction.HORIZONTAL) {
            return this.array_.getLength();
        }
        return 1;
    }

    @Override
    public int getRowCount() {
        if (this.direction_ == Direction.HORIZONTAL) {
            return 1;
        }
        return this.array_.getLength();
    }

    public Class<String> getColumnClass(int col) {
        return String.class;
    }

    @Override
    public String getColumnName(int col) {
        if (this.direction_ == Direction.HORIZONTAL) {
            try {
                int colx;
                int n = colx = this.flippedLR_ ? this.array_.getLength() - 1 - col : col;
                if (this.showCellIndex_) {
                    return Integer.toString(colx + 1);
                }
                double val = this.array_.getAxis().valueAt(colx);
                return this.hdrFormatter_.sprintfx(val);
            }
            catch (Exception exc) {
                return "";
            }
        }
        return "Val";
    }

    @Override
    public String getRowName(int row) {
        if (this.direction_ == Direction.VERTICAL) {
            try {
                int rowx;
                int n = rowx = this.flippedBT_ ? this.array_.getLength() - 1 - row : row;
                if (this.showCellIndex_) {
                    return Integer.toString(rowx + 1);
                }
                double val = this.array_.getAxis().valueAt(rowx);
                return this.hdrFormatter_.sprintfx(val);
            }
            catch (Exception exc) {
                return "";
            }
        }
        return "";
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.direction_ == Direction.HORIZONTAL) {
            try {
                int colx = this.flippedLR_ ? this.array_.getLength() - 1 - col : col;
                return this.valFormatter_.sprintfx(this.array_.valueAt(colx));
            }
            catch (Exception ignore) {
                return "ERR";
            }
        }
        try {
            int rowx = this.flippedBT_ ? this.array_.getLength() - 1 - row : row;
            return this.valFormatter_.sprintfx(this.array_.valueAt(rowx));
        }
        catch (Exception ignore) {
            return "ERR";
        }
    }

    @Override
    public void setFlipBT(boolean flipped) {
        this.flippedBT_ = flipped;
        this.fireTableDataChanged();
        this.fireTableStructureChanged();
    }

    @Override
    public void setFlipLR(boolean flipped) {
        this.flippedLR_ = flipped;
        this.fireTableDataChanged();
        this.fireTableStructureChanged();
    }

    public static enum Direction {
        HORIZONTAL,
        VERTICAL;

    }
}

