/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanScaleControls;
import gov.nasa.giss.panoply.ui.PanButton;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.menu.GissMenu;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanScaleControls1D
extends PanScaleControls {
    private PanButton swapBtn_;
    private Action swapAction_;

    public PanScaleControls1D(PanPlotMeta pmeta, PanMenuBar mbar) {
        super(pmeta, mbar);
        if (!this.ptype_.isLinePlot()) {
            throw new IllegalArgumentException("Plot type is not line plot.");
        }
        this.createActions(mbar);
        this.createLayout();
    }

    private void createActions(PanMenuBar mbar) {
        GissMenu plotMenu = mbar.getMenuByName("plot-menu");
        switch (this.ptype_) {
            case HORZ_LINE: 
            case LL_ZONAL: {
                this.swapAction_ = new SwapBoundsAction("swap-ybounds");
                this.pmeta_.putAction("swap-ybounds", this.swapAction_);
                plotMenu.getItemByName("swap-ybounds").setAction(this.swapAction_);
                plotMenu.getItemByName("swap-ybounds").setEnabled(true);
                plotMenu.getItemByName("log-scale").setEnabled(true);
                break;
            }
            case VERT_LINE: {
                this.swapAction_ = new SwapBoundsAction("swap-xbounds");
                this.pmeta_.putAction("swap-xbounds", this.swapAction_);
                plotMenu.getItemByName("swap-xbounds").setAction(this.swapAction_);
                plotMenu.getItemByName("swap-xbounds").setEnabled(true);
                plotMenu.getItemByName("log-scale").setEnabled(false);
                break;
            }
            default: {
                throw new RuntimeException("Bad plot type specified for a line plot.");
            }
        }
    }

    private void createLayout() {
        PanLabel axLabel2;
        PanLabel axLabel1;
        PanLabel axLabel0;
        switch (this.ptype_) {
            case HORZ_LINE: 
            case LL_ZONAL: {
                axLabel0 = PanLabel.small("Y Axis:\u2009");
                axLabel1 = PanLabel.small("Bottom:\u2009");
                axLabel2 = PanLabel.small(", Top:\u2009");
                this.swapBtn_ = PanButton.small("swap-ybounds", this.swapAction_, "Swap B/T");
                break;
            }
            case VERT_LINE: {
                axLabel0 = PanLabel.small("X Axis:\u2009");
                axLabel1 = PanLabel.small("Left:\u2009");
                axLabel2 = PanLabel.small(", Right:\u2009");
                this.swapBtn_ = PanButton.small("swap-xbounds", this.swapAction_, "Swap L/R");
                break;
            }
            default: {
                throw new RuntimeException("Bad plot type specified for a line plot.");
            }
        }
        this.fitToDataBtn_.setText("Reset");
        QuickBox rangeBox = QuickBox.createLeftBox(axLabel1, this.val1TF_, axLabel2, this.val2TF_, this.swapBtn_, this.fitToDataBtn_, Box.createVerticalStrut(12));
        PanLabel unitsLabel1 = PanLabel.small("Units:\u2009");
        PanLabel unitsLabel2 = PanLabel.small("of\u2009");
        PanLabel scalingLabel = PanLabel.small("\u00d7 Scaling:\u2009");
        PanLabel tenLabel = PanLabel.small("10^");
        QuickBox unitsBox = QuickBox.createLeftBox(unitsLabel1, this.methodCombo_, unitsLabel2, this.unitsCombo_, scalingLabel, tenLabel, this.scalingSpinner_);
        PanLabel formatLabel1 = PanLabel.small("Ticks:\u2009");
        PanLabel formatLabel2 = PanLabel.small("Format:\u2009");
        PanLabel formatLabel3 = PanLabel.small("\u2014 ");
        PanLabel formatLabel4 = PanLabel.small("Divisions: Major:\u2009");
        PanLabel formatLabel5 = PanLabel.small(", Minor:\u2009");
        PanLabel formatLabel6 = PanLabel.small("\u2014 Size:\u2009");
        QuickBox divBox = QuickBox.createLeftBox(formatLabel1, formatLabel2, this.tickFormatCombo_, formatLabel3, formatLabel4, this.majorDivSpinner_, formatLabel5, this.minorDivSpinner_, formatLabel6, this.tickSizeCombo_);
        PanLabel captionLabel1 = PanLabel.small("Caption:\u2009");
        PanLabel captionLabel2 = PanLabel.small("\u2014 Size:\u2009");
        QuickBox captionBox = QuickBox.createLeftBox(captionLabel1, this.dfltCaptionBtn_, this.customCaptionBtn_, this.captionTF_, captionLabel2, this.captionSizeCombo_);
        int tfh = this.captionTF_.getPreferredSize().height;
        this.captionTF_.setMinimumSize(new Dimension(150, tfh));
        this.captionTF_.setPreferredSize(new Dimension(225, tfh));
        this.captionTF_.setMaximumSize(new Dimension(1000, tfh));
        this.setOpaque(false);
        FlexingGridLayout fgl = new FlexingGridLayout(2, 4, 0, 2);
        fgl.setRigidHeight(true);
        fgl.setPadBottom(true);
        this.setLayout(fgl);
        this.setBorder(null);
        this.add((Component)axLabel0, new FGConstraint(0, 0));
        this.add((Component)rangeBox, new FGConstraint(1, 0));
        this.add((Component)unitsBox, new FGConstraint(1, 1));
        this.add((Component)divBox, new FGConstraint(1, 2));
        this.add((Component)captionBox, new FGConstraint(1, 3));
        GuiUtils.matchLabelWidths(axLabel1, unitsLabel1, formatLabel1, captionLabel1);
    }

    private void swapExtrema() {
        double oldval1 = this.pmeta_.getDouble("scale.min");
        double oldval2 = this.pmeta_.getDouble("scale.max");
        String bstr = this.val2TF_.getText();
        String tstr = this.val1TF_.getText();
        this.val2TF_.setText(tstr);
        this.val1TF_.setText(bstr);
        this.pmeta_.setGroup({"scale.min", oldval2}, {"scale.max", oldval1});
    }

    @Override
    public void setScaleRange(double val1, double val2) {
        this.val1TF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(val1));
        this.val2TF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(val2));
        this.pmeta_.setGroup({"scale.min", val1}, {"scale.max", val2});
    }

    public void zoom(double factor) {
        double oldval1 = this.pmeta_.getDouble("scale.min");
        double oldval2 = this.pmeta_.getDouble("scale.max");
        double center = 0.5 * (oldval1 + oldval2);
        double diff = oldval2 - oldval1;
        double newdiff = diff / factor;
        double halfdiff = 0.5 * newdiff;
        double newval1 = center - halfdiff;
        double newval2 = center + halfdiff;
        this.setScaleRange(newval1, newval2);
    }

    public void zoom(double factor, double center) {
        double oldval1 = this.pmeta_.getDouble("scale.min");
        double oldval2 = this.pmeta_.getDouble("scale.max");
        double diff = oldval2 - oldval1;
        double newdiff = diff / factor;
        double halfdiff = 0.5 * newdiff;
        double newval1 = center - halfdiff;
        double newval2 = center + halfdiff;
        this.setScaleRange(newval1, newval2);
    }

    class SwapBoundsAction
    extends AbstractAction {
        private boolean busy_;

        SwapBoundsAction(String actionID) {
            super(PanProperties.MENU_PROPS.getString(actionID));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.busy_) {
                return;
            }
            this.busy_ = true;
            PanScaleControls1D.this.swapExtrema();
            this.busy_ = false;
        }
    }
}

