/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.panoply.plot.PanPlot;
import gov.nasa.giss.panoply.plotui.PanGridControls;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.plotui.PanPlotGlass;
import gov.nasa.giss.panoply.plotui.PanPlotHolder;
import gov.nasa.giss.ui.cursor.CursorUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanPlotMouseListener
extends MouseInputAdapter
implements KeyEventDispatcher,
KeyListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final int SHORTCUT_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    protected static final boolean META_IS_SHORTCUT = SHORTCUT_MASK == 4;
    protected static final int SHORTCUT_LIT = 4096;
    protected static final int ALT_LIT = 16;
    protected static final int SHIFT_LIT = 1;
    protected static final int ZOOM_IN = 4096;
    protected static final int ZOOM_OUT = 4112;
    protected final PanPlotFrame pframe_;
    protected PanPlotHolder pholder_;
    private PanPlot plot_;
    private PanGridControls gridControls_;
    protected Rectangle currentRect_;
    protected Rectangle rectToDraw_;
    protected Rectangle previousRectDrawn_ = new Rectangle();
    protected boolean dragInProgress_;
    protected Point pressPt_;
    protected Point releasePt_;

    public PanPlotMouseListener(PanPlotFrame frame) {
        this.pframe_ = frame;
        this.pholder_ = frame.getPlotHolder();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        PanPlotMouseListener panPlotMouseListener = this;
        synchronized (panPlotMouseListener) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        }
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (!this.pframe_.isFocused()) {
            return false;
        }
        if (!this.pholder_.isVisible()) {
            return false;
        }
        Point framePt = this.pframe_.getMousePosition(true);
        if (framePt == null) {
            return false;
        }
        if (this.pframe_.getComponentAt(framePt) == this.pholder_) {
            return false;
        }
        if (this.pholder_.isFocusOwner()) {
            return false;
        }
        if (e.getID() == 401) {
            this.keyPressed(e);
        } else if (e.getID() == 402) {
            this.keyReleased(e);
        }
        return false;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.handleKeyEvent(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.handleKeyEvent(e);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Component c = e.getComponent();
        if (!(c instanceof PanPlotHolder)) {
            return;
        }
        if (!this.pholder_.isVisible()) {
            return;
        }
        this.pholder_.requestFocusInWindow();
        PanPlotGlass glass = (PanPlotGlass)this.pframe_.getGlassPane();
        glass.clear();
        glass.repaint();
        CursorUtils.setDefaultCursor(this.pholder_);
        if (e.isPopupTrigger()) {
            return;
        }
        int keyModifiers = this.getModifiers(e);
        Point eventPt = e.getPoint();
        Point2D.Double p2d = this.pholder_.transformXY2GridCoords(eventPt);
        if (p2d == null) {
            return;
        }
        if (keyModifiers == 1) {
            this.getGridControls().recenter(p2d.x, p2d.y);
        } else if (keyModifiers == 4096) {
            this.getGridControls().zoomIn(p2d.x, p2d.y);
        } else if (keyModifiers == 16) {
            Point glassPt = SwingUtilities.convertPoint(this.pholder_, eventPt, glass);
            String text = this.pholder_.describePoint(eventPt.x, eventPt.y);
            if (text == null || text.isEmpty()) {
                glass.setContentType(PanPlotGlass.ContentType.NONE);
                glass.setVisible(false);
            } else {
                glass.setPoint(glassPt);
                glass.setText(text);
                glass.setContentType(PanPlotGlass.ContentType.TEXT_BOX);
                glass.setVisible(true);
                glass.repaint();
            }
        } else if (keyModifiers == 4112) {
            this.getGridControls().zoomOut(p2d.x, p2d.y);
        }
        this.updateCursor(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (!this.dragInProgress_) {
            this.updateCursor(e);
            Component c = e.getComponent();
            if (!(c instanceof PanPlotHolder)) {
                return;
            }
            PanPlotHolder ph = (PanPlotHolder)c;
            PanPlotGlass glass = (PanPlotGlass)this.pframe_.getGlassPane();
            Point eventPt = e.getPoint();
            Point glassPt = SwingUtilities.convertPoint(ph, eventPt, glass);
            int keyModifiers = this.getModifiers(e);
            if (keyModifiers == 1) {
                glass.setPoint(glassPt);
                glass.setContentType(PanPlotGlass.ContentType.CROSSHAIRS);
                glass.setVisible(true);
                glass.repaint();
            } else {
                glass.setContentType(PanPlotGlass.ContentType.NONE);
                glass.setVisible(false);
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        CursorUtils.setDefaultCursor(this.pframe_);
        if (!this.dragInProgress_) {
            PanPlotGlass glass = (PanPlotGlass)this.pframe_.getGlassPane();
            glass.setContentType(PanPlotGlass.ContentType.NONE);
            glass.setVisible(false);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.pholder_.requestFocusInWindow();
        this.pressPt_ = e.getPoint();
        PanPlotGlass glass = (PanPlotGlass)this.pframe_.getGlassPane();
        Point glassPt = SwingUtilities.convertPoint(this.pholder_, this.pressPt_, glass);
        this.currentRect_ = new Rectangle(glassPt.x, glassPt.y, 0, 0);
        this.updateDrawableRect(glass);
        glass.setRectangle(this.rectToDraw_);
        glass.setContentType(PanPlotGlass.ContentType.DRAG_FRAME);
        glass.setVisible(true);
        glass.repaint();
        this.dragInProgress_ = true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.dragInProgress_ = false;
        int keyModifiers = this.getModifiers(e);
        if (keyModifiers == 4096) {
            this.updateDragRect(e);
            if (this.rectToDraw_ != null && (this.rectToDraw_.width > 1 || this.rectToDraw_.height > 1)) {
                Point releasePt = e.getPoint();
                Point2D.Double coords1 = this.pholder_.transformXY2GridCoords(this.pressPt_);
                Point2D.Double coords2 = this.pholder_.transformXY2GridCoords(this.releasePt_);
                if (coords2 == null) {
                    LOGGER.trace("BAD? release {},{}", (Object)releasePt, (Object)coords2);
                }
                if (coords1 != null && coords2 != null) {
                    Point centerPt = new Point((int)(0.5 * (double)(this.pressPt_.x + releasePt.x)), (int)(0.5 * (double)(this.pressPt_.y + releasePt.y)));
                    Point2D.Double coordsC = this.pholder_.transformXY2GridCoords(centerPt);
                    double l = this.pressPt_.x < releasePt.x ? coords1.x : coords2.x;
                    double t = this.pressPt_.y < releasePt.y ? coords1.y : coords2.y;
                    double r = this.pressPt_.x < releasePt.x ? coords2.x : coords1.x;
                    double b = this.pressPt_.y < releasePt.y ? coords2.y : coords1.y;
                    this.getGridControls().dragZoom(coordsC.x, coordsC.y, l, t, r, b);
                } else {
                    LOGGER.trace("Still BAD? release {},{}", (Object)releasePt, (Object)coords2);
                }
            }
        }
        CursorUtils.setDefaultCursor(this.pholder_);
        PanPlotGlass glass = (PanPlotGlass)this.pframe_.getGlassPane();
        glass.setContentType(PanPlotGlass.ContentType.NONE);
        glass.setVisible(false);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.updateDragRect(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.updateCursor(e);
        Component c = e.getComponent();
        if (!(c instanceof PanPlotHolder)) {
            return;
        }
        PanPlotHolder ph = (PanPlotHolder)c;
        PanPlotGlass glass = (PanPlotGlass)this.pframe_.getGlassPane();
        Point eventPt = e.getPoint();
        Point glassPt = SwingUtilities.convertPoint(ph, eventPt, glass);
        int keyModifiers = this.getModifiers(e);
        if (keyModifiers == 1) {
            glass.setPoint(glassPt);
            glass.setContentType(PanPlotGlass.ContentType.CROSSHAIRS);
            glass.setVisible(true);
            glass.repaint();
        } else {
            glass.setVisible(false);
            glass.setContentType(PanPlotGlass.ContentType.NONE);
        }
    }

    protected void handleKeyEvent(KeyEvent e) {
        if (!this.pholder_.isVisible()) {
            return;
        }
        Component c = e.getComponent();
        if (this.dragInProgress_) {
            int keyModifiers = this.getModifiers(e);
            int crw = this.currentRect_.width;
            int crh = this.currentRect_.height;
            if (keyModifiers == 4096 || keyModifiers == 4112) {
                CursorUtils.setZoomInCursor(this.pholder_);
            } else if (crw < 0 && crh < 0) {
                c.setCursor(Cursor.getPredefinedCursor(6));
            } else if (crw >= 0 && crh < 0) {
                c.setCursor(Cursor.getPredefinedCursor(7));
            } else if (crw < 0 && crh >= 0) {
                c.setCursor(Cursor.getPredefinedCursor(4));
            } else {
                c.setCursor(Cursor.getPredefinedCursor(5));
            }
        } else {
            this.updateCursor(e);
        }
    }

    protected void updateCursor(InputEvent e) {
        Point framePt = this.pframe_.getMousePosition(true);
        if (framePt == null) {
            CursorUtils.setDefaultCursor(this.pholder_);
            return;
        }
        Point phPt = SwingUtilities.convertPoint(this.pframe_, framePt, this.pholder_);
        Point2D.Double p2d = this.pholder_.transformXY2GridCoords(phPt.x, phPt.y);
        if (p2d == null) {
            CursorUtils.setDefaultCursor(this.pholder_);
            return;
        }
        int keyModifiers = this.getModifiers(e);
        if (keyModifiers == 1) {
            CursorUtils.setCrosshairCursor(this.pholder_);
        } else if (keyModifiers == 4096) {
            CursorUtils.setZoomInCursor(this.pholder_);
        } else if (keyModifiers == 16) {
            CursorUtils.setHelpCursor(this.pholder_);
        } else if (keyModifiers == 4112) {
            CursorUtils.setZoomOutCursor(this.pholder_);
        } else {
            CursorUtils.setDefaultCursor(this.pholder_);
        }
    }

    private void updateDragRect(MouseEvent e) {
        if (e.getID() == 500) {
            this.rectToDraw_ = null;
            return;
        }
        Point eventPt = new Point(e.getPoint());
        Point2D.Double p2d = this.pholder_.transformXY2GridCoords(eventPt);
        if (p2d == null) {
            int i;
            LOGGER.trace("Drag out of plot; adjusting.");
            boolean posX = eventPt.x > this.pressPt_.x;
            boolean posY = eventPt.y > this.pressPt_.y;
            int goodx = this.pressPt_.x;
            int goody = this.pressPt_.y;
            if (posX) {
                for (i = eventPt.x; i > this.pressPt_.x; --i) {
                    p2d = this.pholder_.transformXY2GridCoords(new Point(i, this.pressPt_.y));
                    if (p2d == null) continue;
                    goodx = i;
                    break;
                }
            } else {
                for (i = eventPt.x; i < this.pressPt_.x; ++i) {
                    p2d = this.pholder_.transformXY2GridCoords(new Point(i, this.pressPt_.y));
                    if (p2d == null) continue;
                    goodx = i;
                    break;
                }
            }
            if (posY) {
                for (i = eventPt.y; i > this.pressPt_.y; --i) {
                    p2d = this.pholder_.transformXY2GridCoords(new Point(this.pressPt_.x, i));
                    if (p2d == null) continue;
                    goody = i;
                    break;
                }
            } else {
                for (i = eventPt.y; i < this.pressPt_.y; ++i) {
                    p2d = this.pholder_.transformXY2GridCoords(new Point(this.pressPt_.x, i));
                    if (p2d == null) continue;
                    goody = i;
                    break;
                }
            }
            eventPt = new Point(goodx, goody);
        }
        this.releasePt_ = new Point(eventPt.x, eventPt.y);
        PanPlotGlass glass = (PanPlotGlass)this.pframe_.getGlassPane();
        Point glassPt = SwingUtilities.convertPoint(this.pholder_, eventPt, glass);
        if (glassPt == null) {
            return;
        }
        this.currentRect_.setSize(glassPt.x - this.currentRect_.x, glassPt.y - this.currentRect_.y);
        this.updateDrawableRect(glass);
        Rectangle repaintRect = this.rectToDraw_.union(this.previousRectDrawn_);
        repaintRect.x -= 3;
        repaintRect.y -= 3;
        repaintRect.width += 6;
        repaintRect.height += 6;
        glass.setRectangle(this.rectToDraw_);
        glass.setContentType(PanPlotGlass.ContentType.DRAG_FRAME);
        glass.setVisible(true);
        glass.repaint(repaintRect.x, repaintRect.y, repaintRect.width, repaintRect.height);
        Component c = e.getComponent();
        int keyModifiers = this.getModifiers(e);
        if (keyModifiers == 4096 || keyModifiers == 4112) {
            CursorUtils.setZoomInCursor(this.pholder_);
        } else {
            int crw = this.currentRect_.width;
            int crh = this.currentRect_.height;
            if (crw < 0 && crh < 0) {
                c.setCursor(Cursor.getPredefinedCursor(6));
            } else if (crw >= 0 && crh < 0) {
                c.setCursor(Cursor.getPredefinedCursor(7));
            } else if (crw < 0 && crh >= 0) {
                c.setCursor(Cursor.getPredefinedCursor(4));
            } else {
                c.setCursor(Cursor.getPredefinedCursor(5));
            }
        }
    }

    protected void updateDrawableRect(Component c) {
        this.updateDrawableRect(c.getWidth(), c.getHeight());
    }

    protected void updateDrawableRect(int compWidth, int compHeight) {
        int x = this.currentRect_.x;
        int y = this.currentRect_.y;
        int width = this.currentRect_.width;
        int height = this.currentRect_.height;
        if (width < 0 && (x = x - (width = 0 - width) + 1) < 0) {
            width += x;
            x = 0;
        }
        if (height < 0 && (y = y - (height = 0 - height) + 1) < 0) {
            height += y;
            y = 0;
        }
        if (x + width > compWidth) {
            width = compWidth - x;
        }
        if (y + height > compHeight) {
            height = compHeight - y;
        }
        if (this.rectToDraw_ != null) {
            this.previousRectDrawn_.setBounds(this.rectToDraw_.x, this.rectToDraw_.y, this.rectToDraw_.width, this.rectToDraw_.height);
            this.rectToDraw_.setBounds(x, y, width, height);
        } else {
            this.rectToDraw_ = new Rectangle(x, y, width, height);
        }
    }

    protected int getModifiers(InputEvent e) {
        int result = 0;
        if (META_IS_SHORTCUT) {
            if (e.isMetaDown()) {
                result |= 0x1000;
            }
        } else if (e.isControlDown()) {
            result |= 0x1000;
        }
        if (e.isShiftDown()) {
            result |= 1;
        }
        if (e.isAltDown()) {
            result |= 0x10;
        }
        return result;
    }

    private PanGridControls getGridControls() {
        if (this.gridControls_ == null) {
            this.gridControls_ = (PanGridControls)this.pframe_.findComponentNamed("grid-controls");
        }
        return this.gridControls_;
    }

    protected PanPlot getPlot() {
        if (this.plot_ == null) {
            this.plot_ = this.pframe_.getPlot();
        }
        return this.plot_;
    }
}

