/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.data.nc.NcTransferableVariable;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.graphics.ColorTableFilenameFilter;
import gov.nasa.giss.io.FileUtils;
import gov.nasa.giss.map.overlay.OverlayFilenameFilter;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.plotui.PanPlotScrollPane;
import gov.nasa.giss.panoply.util.PanUtils;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanPlotDropTargetListener
implements DropTargetListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PanPlotFrame pframe_;
    private final PanPlotScrollPane pspane_;

    public PanPlotDropTargetListener(PanPlotFrame pf, PanPlotScrollPane psp) {
        this.pframe_ = pf;
        this.pspane_ = psp;
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        if (this.pframe_.isAnimationInProgress()) {
            return;
        }
        if (e.isDataFlavorSupported(NcTransferableVariable.NC_VARIABLE_FLAVOR)) {
            this.pspane_.togglePlotBorderActive(true);
            e.acceptDrag(1);
        } else if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            this.pspane_.togglePlotBorderActive(true);
            e.acceptDrag(1);
        }
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        if (this.pframe_.isAnimationInProgress()) {
            return;
        }
        this.pspane_.togglePlotBorderActive(false);
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        if (this.pframe_.isAnimationInProgress()) {
            return;
        }
        this.pspane_.togglePlotBorderActive(false);
        Transferable t = e.getTransferable();
        if (t.isDataFlavorSupported(NcTransferableVariable.NC_VARIABLE_FLAVOR)) {
            e.acceptDrop(1);
            try {
                NcVariable ncv = (NcVariable)t.getTransferData(NcTransferableVariable.NC_VARIABLE_FLAVOR);
                this.pframe_.addVariable(ncv);
                e.dropComplete(true);
            }
            catch (Exception exc) {
                LOGGER.warn("Drop exception: {}", (Object)exc.toString());
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                e.dropComplete(false);
            }
        } else if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrop(1);
            List<File> droplist = FileUtils.getTransferredFileList(t);
            if (droplist != null) {
                ArrayList<File> cblist = new ArrayList<File>();
                ArrayList<File> olist = new ArrayList<File>();
                for (File f : droplist) {
                    if (ColorTableFilenameFilter.isColorTableName(f)) {
                        cblist.add(f);
                        continue;
                    }
                    if (!OverlayFilenameFilter.isOverlayName(f)) continue;
                    olist.add(f);
                }
                PanUtils.getColorTableResourceList().addAlphabetic((Component)this.pframe_, cblist);
                PanUtils.getOverlayResourceList().addAlphabetic((Component)this.pframe_, olist);
            }
            e.dropComplete(true);
        } else {
            e.rejectDrop();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        if (this.pframe_.isAnimationInProgress()) {
            return;
        }
        this.pspane_.togglePlotBorderActive(true);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
        if (this.pframe_.isAnimationInProgress()) {
            return;
        }
        this.pspane_.togglePlotBorderActive(false);
    }
}

