/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.math.MathUtils;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanAbstractControlsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.ui.PanTextField;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.text.StringUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.invoke.MethodHandles;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanLonLatShadingControls
extends PanAbstractControlsPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanCheckBox shadingCB_;
    private PanIntSpinner sOpacitySpinner_;
    private PanTextField subsolarLonTF_;
    private PanTextField subsolarLatTF_;
    private boolean refreshing_;

    public PanLonLatShadingControls(PanPlotMeta pmeta, PanMenuBar mbar) {
        super("shading-controls", pmeta, mbar);
        this.createLayout();
        this.attachListeners();
    }

    private void createLayout() {
        PanLabel s1Label = PanLabel.small("Shading:\u2009");
        this.shadingCB_ = PanCheckBox.small("lonlat.proj.shading.vis", "Darken nightside", this.pmeta_.getBoolean("lonlat.proj.shading.vis"));
        QuickBox s1Box = QuickBox.createLeftBox(s1Label, this.shadingCB_);
        PanLabel s2Label1 = PanLabel.small(" ");
        PanLabel s2Label2 = PanLabel.small("Darkness:\u2009");
        PanLabel s2Label3 = PanLabel.small("%");
        this.sOpacitySpinner_ = PanIntSpinner.smallPct("lonlat.proj.shading.opacity", this.pmeta_.getInt("lonlat.proj.shading.opacity"));
        QuickBox s2Box = QuickBox.createLeftBox(s2Label1, s2Label2, this.sOpacitySpinner_, s2Label3);
        PanLabel s3Label1 = PanLabel.small(" ");
        PanLabel s3Label2 = PanLabel.small("Subsolar Pt:\u2009");
        PanLabel s3Label3 = PanLabel.small("Lon:\u2009");
        PanLabel s3Label4 = PanLabel.small("\u00b0E, Lat:\u2009");
        PanLabel s3Label5 = PanLabel.small("\u00b0N");
        this.subsolarLonTF_ = PanTextField.smallDoubleField("lonlat.proj.subsolar.lon", this.pmeta_.getDouble("lonlat.proj.subsolar.lon"));
        this.subsolarLatTF_ = PanTextField.smallDoubleField("lonlat.proj.subsolar.lat", this.pmeta_.getDouble("lonlat.proj.subsolar.lat"));
        QuickBox s3Box = QuickBox.createLeftBox(s3Label1, s3Label2, s3Label3, this.subsolarLonTF_, s3Label4, this.subsolarLatTF_, s3Label5);
        GuiUtils.matchLabelWidths(s1Label, s2Label1, s3Label1);
        FlexingGridLayout fgl = new FlexingGridLayout(2, 4, 0, 2);
        fgl.setRigidWidth(true);
        fgl.setRigidHeight(true);
        fgl.setPadBottom(true);
        this.setLayout(fgl);
        this.setBorder(PanGuiUtils.STD_BORDER);
        this.add((Component)s1Box, new FGConstraint(0, 0));
        this.add((Component)s2Box, new FGConstraint(0, 1));
        this.add((Component)s3Box, new FGConstraint(0, 2));
        this.refresh();
    }

    private void attachListeners() {
        this.shadingCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.pmeta_.setBoolean("lonlat.proj.shading.vis", this.shadingCB_.isSelected());
        });
        this.sOpacitySpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.pmeta_.setInt("lonlat.proj.shading.opacity", this.sOpacitySpinner_.getIntValue());
        });
        FocusAdapter lonlatFL = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PanLonLatShadingControls.this.handleSubsolarTF();
            }
        };
        this.subsolarLonTF_.addFocusListener(lonlatFL);
        this.subsolarLatTF_.addFocusListener(lonlatFL);
        this.subsolarLonTF_.addActionListener(e -> this.handleSubsolarTF());
        this.subsolarLatTF_.addActionListener(e -> this.handleSubsolarTF());
    }

    private void handleSubsolarTF() {
        double lat;
        if (this.refreshing_) {
            return;
        }
        if (this.subsolarLonTF_ == null || this.subsolarLatTF_ == null || this.pmeta_ == null) {
            return;
        }
        double lon = this.getSubsolarLon();
        if (Double.isNaN(lon)) {
            lon = this.pmeta_.getDouble("lonlat.proj.subsolar.lon");
            this.subsolarLonTF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(lon));
        }
        boolean shifted = false;
        while (lon > 180.0) {
            lon -= 360.0;
            shifted = true;
        }
        while (lon < -180.0) {
            lon += 360.0;
            shifted = true;
        }
        if (shifted) {
            this.subsolarLonTF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(lon));
        }
        if ((lat = this.getSubsolarLat()) < -90.0 || lat > 90.0) {
            lat = MathUtils.constrain(-90.0, 90.0, lat);
            this.subsolarLatTF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(lat));
        }
        if (this.pmeta_ != null) {
            this.pmeta_.setGroup({"lonlat.proj.subsolar.lon", lon}, {"lonlat.proj.subsolar.lat", lat});
        }
    }

    private double getSubsolarLon() {
        String s = this.subsolarLonTF_.getText();
        try {
            return StringUtils.parseDouble(s);
        }
        catch (Exception exc) {
            LOGGER.warn("Could not parse lon TF '{}'", (Object)s);
            return Double.NaN;
        }
    }

    private double getSubsolarLat() {
        String s = this.subsolarLatTF_.getText();
        try {
            return StringUtils.parseDouble(s);
        }
        catch (Exception exc) {
            LOGGER.warn("Could not parse lat TF '{}')", (Object)s);
            return Double.NaN;
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.shadingCB_.setSelected(this.pmeta_.getBoolean("lonlat.proj.shading.vis"));
        this.sOpacitySpinner_.setValue(this.pmeta_.getInt("lonlat.proj.shading.opacity"));
        this.subsolarLonTF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(this.pmeta_.getDouble("lonlat.proj.subsolar.lon")));
        this.subsolarLatTF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(this.pmeta_.getDouble("lonlat.proj.subsolar.lat")));
        this.refreshing_ = false;
    }
}

