/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanAbstractControlsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanColorComboBox;
import gov.nasa.giss.panoply.ui.PanFloatComboBox;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.ui.PanTextField;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.text.StringUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.invoke.MethodHandles;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanLonLatNumberlayControls
extends PanAbstractControlsPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanCheckBox showNumbersCB_;
    private PanCheckBox hideInvalidsCB_;
    private PanTextField lonSpacingTF_;
    private PanTextField latSpacingTF_;
    private PanCheckBox lonOffsetCB_;
    private PanCheckBox latOffsetCB_;
    private PanFloatComboBox labelSizeCombo_;
    private PanColorComboBox labelColorCombo_;

    public PanLonLatNumberlayControls(PanPlotMeta pmeta, PanMenuBar mbar) {
        super("numberlay-controls", pmeta, mbar);
        this.createLayout();
        this.attachListeners();
    }

    private void createLayout() {
        this.showNumbersCB_ = PanCheckBox.small("beta.numberlay.enabled", "Show overlay of data values", this.pmeta_.getBoolean("beta.numberlay.enabled"));
        QuickBox cbox11 = QuickBox.createLeftBox(this.showNumbersCB_);
        this.hideInvalidsCB_ = PanCheckBox.small("beta.numberlay.invalids", "Omit invalid values", !this.pmeta_.getBoolean("beta.numberlay.invalids"));
        QuickBox cbox12 = QuickBox.createLeftBox(this.hideInvalidsCB_);
        PanLabel s1Label = PanLabel.small("Spacing:\u2009");
        PanLabel s2Label = PanLabel.small("Lon:\u2009");
        PanLabel s3Label = PanLabel.small("\u00d7 Lat:\u2009");
        this.lonSpacingTF_ = PanTextField.smallDoubleField("beta.numberlay.spacing.lon", this.pmeta_.getDouble("beta.numberlay.spacing.lon"));
        this.latSpacingTF_ = PanTextField.smallDoubleField("beta.numberlay.spacing.lat", this.pmeta_.getDouble("beta.numberlay.spacing.lat"));
        QuickBox cbox13 = QuickBox.createLeftBox(s1Label, s2Label, this.lonSpacingTF_, s3Label, this.latSpacingTF_);
        this.lonOffsetCB_ = PanCheckBox.small("beta.numberlay.offset.lon", "Numbers on lon axis are offset from prime meridian", this.pmeta_.getBoolean("beta.numberlay.offset.lon"));
        QuickBox cbox14 = QuickBox.createLeftBox(this.lonOffsetCB_);
        this.latOffsetCB_ = PanCheckBox.small("beta.numberlay.offset.lat", "Numbers on lat axis are offset from equator", this.pmeta_.getBoolean("beta.numberlay.offset.lat"));
        QuickBox cbox15 = QuickBox.createLeftBox(this.latOffsetCB_);
        PanLabel labelSizeLabel = PanLabel.small("Size:\u2009");
        this.labelSizeCombo_ = PanFloatComboBox.small("beta.numberlay.size", 2.0f, 10.0f);
        this.labelSizeCombo_.setValue(this.pmeta_.getFloat("beta.numberlay.size"));
        QuickBox cbox21 = QuickBox.createLeftBox(labelSizeLabel, this.labelSizeCombo_);
        PanLabel colorLabel = PanLabel.small("Color:\u2009");
        this.labelColorCombo_ = PanColorComboBox.smallRainbow("beta.numberlay.color");
        this.labelColorCombo_.setSelectedColor(this.pmeta_.getColor("beta.numberlay.color"));
        QuickBox cbox22 = QuickBox.createLeftBox(colorLabel, this.labelColorCombo_);
        FlexingGridLayout fgl = new FlexingGridLayout(2, 5, 0, 2);
        fgl.setRigidWidth(true);
        fgl.setRigidHeight(true);
        fgl.setPadBottom(true);
        this.setLayout(fgl);
        this.setBorder(PanGuiUtils.STD_BORDER);
        this.add((Component)cbox11, new FGConstraint(0, 0));
        this.add((Component)cbox12, new FGConstraint(0, 1));
        this.add((Component)cbox13, new FGConstraint(0, 2));
        this.add((Component)cbox14, new FGConstraint(0, 3));
        this.add((Component)cbox15, new FGConstraint(0, 4));
        this.add((Component)cbox21, new FGConstraint(1, 0));
        this.add((Component)cbox22, new FGConstraint(1, 1));
        GuiUtils.matchLabelWidths(labelSizeLabel, colorLabel);
    }

    private void attachListeners() {
        this.showNumbersCB_.addItemListener(e -> this.pmeta_.setBoolean("beta.numberlay.enabled", this.showNumbersCB_.isSelected()));
        this.hideInvalidsCB_.addItemListener(e -> this.pmeta_.setBoolean("beta.numberlay.invalids", !this.hideInvalidsCB_.isSelected()));
        FocusAdapter lonSpacingFL = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PanLonLatNumberlayControls.this.handleLonSpacing();
            }
        };
        FocusAdapter latSpacingFL = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PanLonLatNumberlayControls.this.handleLatSpacing();
            }
        };
        this.lonSpacingTF_.addFocusListener(lonSpacingFL);
        this.latSpacingTF_.addFocusListener(latSpacingFL);
        this.lonSpacingTF_.addActionListener(e -> this.handleLonSpacing());
        this.latSpacingTF_.addActionListener(e -> this.handleLatSpacing());
        this.lonOffsetCB_.addItemListener(e -> this.pmeta_.setBoolean("beta.numberlay.offset.lon", e.getStateChange() == 1));
        this.latOffsetCB_.addItemListener(e -> this.pmeta_.setBoolean("beta.numberlay.offset.lat", e.getStateChange() == 1));
        this.labelSizeCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            float value = this.labelSizeCombo_.getValue();
            this.pmeta_.setFloat("beta.numberlay.size", value);
        });
        this.labelColorCombo_.addItemListener(e -> {
            Color cold;
            if (e.getStateChange() != 1) {
                return;
            }
            Color cnew = this.labelColorCombo_.getSelectedColor();
            if (!cnew.equals(cold = this.pmeta_.getColor("beta.numberlay.color"))) {
                this.pmeta_.setColor("beta.numberlay.color", cnew);
            }
        });
    }

    private void handleLonSpacing() {
        if (this.lonSpacingTF_ == null) {
            return;
        }
        String s = this.lonSpacingTF_.getText();
        double oldSpacing = this.pmeta_.getDouble("beta.numberlay.spacing.lon");
        try {
            double spacing = StringUtils.parseDouble(s);
            if (spacing <= 0.001) {
                if (spacing < 0.0) {
                    LOGGER.warn("Spacing cannot be less than 0.");
                } else if (spacing == 0.0) {
                    LOGGER.warn("Spacing cannot be 0.");
                } else {
                    LOGGER.warn("Spacing is too fine.");
                }
                this.lonSpacingTF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(oldSpacing));
                return;
            }
            this.pmeta_.setDouble("beta.numberlay.spacing.lon", spacing);
        }
        catch (Exception exc) {
            LOGGER.warn("Could not parse lon spacing TF '{}'", (Object)s);
            this.lonSpacingTF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(oldSpacing));
        }
    }

    private void handleLatSpacing() {
        if (this.latSpacingTF_ == null) {
            return;
        }
        String s = this.latSpacingTF_.getText();
        double oldSpacing = this.pmeta_.getDouble("beta.numberlay.spacing.lat");
        try {
            double spacing = StringUtils.parseDouble(s);
            if (spacing <= 0.001) {
                if (spacing < 0.0) {
                    LOGGER.warn("Spacing cannot be less than 0.");
                } else if (spacing == 0.0) {
                    LOGGER.warn("Spacing cannot be 0.");
                } else {
                    LOGGER.warn("Spacing is too fine.");
                }
                this.latSpacingTF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(oldSpacing));
                return;
            }
            this.pmeta_.setDouble("beta.numberlay.spacing.lat", spacing);
        }
        catch (Exception exc) {
            LOGGER.warn("Could not parse lat spacing TF '{}'", (Object)s);
            this.latSpacingTF_.setText(PrintfFormat.PFORMAT_7G.sprintfx(oldSpacing));
        }
    }
}

