/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.graphics.plot.PlotPropertyEvent;
import gov.nasa.giss.graphics.plot.PlotPropertyListener;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.AzimuthalProjection;
import gov.nasa.giss.map.proj.ConicProjection;
import gov.nasa.giss.map.proj.Equirectangular;
import gov.nasa.giss.map.proj.EquirectangularOblique;
import gov.nasa.giss.map.proj.EquirectangularRegional;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ui.ProjBooleanComponent;
import gov.nasa.giss.map.proj.ui.ProjDoubleComponent;
import gov.nasa.giss.map.proj.ui.ProjIntegerComponent;
import gov.nasa.giss.map.proj.ui.ProjListComponent;
import gov.nasa.giss.map.proj.ui.ProjParamComponent;
import gov.nasa.giss.math.MathUtils;
import gov.nasa.giss.panoply.action.PanPlotZoomInAction;
import gov.nasa.giss.panoply.action.PanPlotZoomOutAction;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanProjectionMeta;
import gov.nasa.giss.panoply.plotui.PanGridControls;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.ui.PanButton;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanColorComboBox;
import gov.nasa.giss.panoply.ui.PanEnumComboBox;
import gov.nasa.giss.panoply.ui.PanFloatComboBox;
import gov.nasa.giss.panoply.ui.PanGridLabelStepComboBox;
import gov.nasa.giss.panoply.ui.PanGridSpacingComboBox;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.ui.PanLinkButton;
import gov.nasa.giss.panoply.ui.PanProjectionComboBox;
import gov.nasa.giss.panoply.ui.PanTextField;
import gov.nasa.giss.panoply.util.PanStrokePattern;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.text.StringUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.menu.GissMenu;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import javax.swing.Box;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanLonLatMapControls
extends PanGridControls
implements PlotPropertyListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final PrintfFormat PFORMAT_7G = PrintfFormat.PFORMAT_7G;
    private PanProjectionComboBox projCombo_;
    private PanTextField copLonTF_;
    private PanTextField copLatTF_;
    private QuickBox[] projParamBoxes_;
    private ProjParamComponent[] projParamComponents_ = new ProjParamComponent[5];
    private PanButton fixEqRegBtn_;
    private PanButton fixConicBtn_;
    private PanGridSpacingComboBox gridLonSpacingCombo_;
    private PanGridSpacingComboBox gridLatSpacingCombo_;
    private PanLinkButton linkBtn_;
    private boolean linkedSpacing_;
    private PanCheckBox gridLatOffsetCB_;
    private PanEnumComboBox gridStyleCombo_;
    private PanColorComboBox gridColorCombo_;
    private PanIntSpinner gridWeightSpinner_;
    private PanGridLabelStepComboBox gridLabelStepCombo_;
    private PanLabel gridLabelSizeLabel_;
    private PanFloatComboBox gridLabelSizeCombo_;
    private PanIntSpinner bWeightSpinner_;
    private String lastproj_;
    private boolean refreshing_;

    public PanLonLatMapControls(PanPlotMeta pmeta, PanMenuBar mbar) {
        super(pmeta, mbar);
        this.createActions(mbar);
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
        this.pmeta_.addPlotPropertyListener(this);
    }

    private void createActions(PanMenuBar mbar) {
        GissMenu plotMenu = mbar.getMenuByName("plot-menu");
        AbstractAction a = new PanPlotZoomInAction(this);
        this.pmeta_.putAction("zoom-plot-in", a);
        plotMenu.getItemByName("zoom-plot-in").setAction(a);
        a = new PanPlotZoomOutAction(this);
        this.pmeta_.putAction("zoom-plot-out", a);
        plotMenu.getItemByName("zoom-plot-out").setAction(a);
    }

    private void createLayout() {
        PanLabel projLabel = PanLabel.small("Projection:\u2009");
        this.projCombo_ = PanProjectionComboBox.small("lonlat.proj.name", true);
        this.projCombo_.setSelectedItem(this.pmeta_.getString("lonlat.proj.name"));
        QuickBox projNameBox = QuickBox.createLeftBox(projLabel, this.projCombo_);
        PanLabel centerLabel = PanLabel.small("Center on: ");
        PanLabel lonLabel = PanLabel.small("Lon. ");
        PanLabel degELabel = PanLabel.small("\u00b0E");
        PanLabel latLabel = PanLabel.small(", Lat. ");
        PanLabel degNLabel = PanLabel.small("\u00b0N");
        this.copLonTF_ = PanTextField.smallDoubleField("lonlat.proj.lon0", this.pmeta_.getDouble("lonlat.proj.lon0"));
        this.copLatTF_ = PanTextField.smallDoubleField("lonlat.proj.lat0", this.pmeta_.getDouble("lonlat.proj.lat0"));
        QuickBox copLonBox = QuickBox.createLeftBox(lonLabel, this.copLonTF_, degELabel);
        QuickBox copLatBox = QuickBox.createLeftBox(latLabel, this.copLatTF_, degNLabel);
        QuickBox projCenterBox = QuickBox.createLeftBox(centerLabel, copLonBox, copLatBox);
        this.projParamBoxes_ = new QuickBox[]{QuickBox.createHorizontalBox(new Component[0]), QuickBox.createHorizontalBox(new Component[0])};
        PanLabel gridLabel = PanLabel.small("Grid:\u2009");
        PanLabel gSpacingLabel = PanLabel.small("Spacing:\u2009");
        this.gridLonSpacingCombo_ = PanGridSpacingComboBox.small("grid.spacing.lon");
        this.gridLatSpacingCombo_ = PanGridSpacingComboBox.small("grid.spacing.lat");
        this.gridLonSpacingCombo_.setSpacing(this.pmeta_.getFloat("grid.spacing.lon"));
        this.gridLatSpacingCombo_.setSpacing(this.pmeta_.getFloat("grid.spacing.lat"));
        this.linkedSpacing_ = this.gridLonSpacingCombo_.getSpacing() == this.gridLatSpacingCombo_.getSpacing();
        this.linkBtn_ = new PanLinkButton(null);
        this.linkBtn_.setButtonSize(16);
        this.linkBtn_.setLinked(this.linkedSpacing_);
        PanLabel gdegLabel1 = PanLabel.small("\u00b0E-W");
        PanLabel gdegLabelX = PanLabel.small(" \u00d7 ");
        PanLabel gdegLabel2 = PanLabel.small("\u00b0N-S");
        PanLabel gdegLabelAA = PanLabel.small("  ");
        this.gridLatOffsetCB_ = PanCheckBox.small("grid.offset.lat", "Offset parallels", this.pmeta_.getBoolean("grid.offset.lat"));
        PanLabel gStyleLabel = PanLabel.small("Style:\u2009");
        this.gridStyleCombo_ = PanEnumComboBox.small("grid.style", PanStrokePattern.class);
        this.gridStyleCombo_.setSelectedItem(this.pmeta_.getString("grid.style"));
        PanLabel gColorLabel = PanLabel.small(", Color:\u2009");
        this.gridColorCombo_ = PanColorComboBox.smallRainbow("grid.color");
        this.gridColorCombo_.setSelectedColor(this.pmeta_.getColor("grid.color"));
        PanLabel gWeightLabel = PanLabel.small(", Weight:\u2009");
        this.gridWeightSpinner_ = PanIntSpinner.smallWeight("grid.weight", this.pmeta_.getInt("grid.weight"), 200);
        PanLabel gPctLabel = PanLabel.small("%");
        PanLabel gLabelsLabel = PanLabel.small("Labels:\u2009");
        this.gridLabelStepCombo_ = PanGridLabelStepComboBox.small("grid.label.step");
        this.gridLabelStepCombo_.setStep(this.pmeta_.getInt("grid.label.step"));
        this.gridLabelSizeLabel_ = PanLabel.small(" \u2014 Size:\u2009");
        this.gridLabelSizeCombo_ = PanFloatComboBox.small("grid.label.size", 5.0f, 10.0f);
        this.gridLabelSizeCombo_.setValue(this.pmeta_.getFloat("grid.label.size"));
        PanLabel borderLabel = PanLabel.small("Border: ");
        PanLabel bWeightLabel = PanLabel.small("Weight:\u2009");
        this.bWeightSpinner_ = PanIntSpinner.smallWeight("lonlat.border.weight", this.pmeta_.getInt("lonlat.border.weight"), 250);
        PanLabel bPctLabel = PanLabel.small("%");
        GuiUtils.matchLabelWidths(gridLabel, borderLabel);
        int gww = gridLabel.getPreferredSize().width;
        int gwx = gSpacingLabel.getPreferredSize().width;
        QuickBox gSpacingBox = QuickBox.createLeftBox(gridLabel, gSpacingLabel, this.gridLonSpacingCombo_, gdegLabel1, gdegLabelX, this.gridLatSpacingCombo_, gdegLabel2, gdegLabelAA, this.linkBtn_);
        QuickBox gOffsetBox = QuickBox.createLeftBox(Box.createHorizontalStrut(gww), Box.createHorizontalStrut(gwx), this.gridLatOffsetCB_);
        QuickBox gStyleBox = QuickBox.createLeftBox(Box.createHorizontalStrut(gww), gStyleLabel, this.gridStyleCombo_, gColorLabel, this.gridColorCombo_, gWeightLabel, this.gridWeightSpinner_, gPctLabel);
        QuickBox gLabelsBox = QuickBox.createLeftBox(Box.createHorizontalStrut(gww), gLabelsLabel, this.gridLabelStepCombo_, this.gridLabelSizeLabel_, this.gridLabelSizeCombo_);
        QuickBox borderBox = QuickBox.createLeftBox(borderLabel, bWeightLabel, this.bWeightSpinner_, bPctLabel);
        FlexingGridLayout fgl = new FlexingGridLayout(2, 5, 0, 2);
        fgl.setRigidWidth(true);
        fgl.setRigidHeight(true);
        fgl.setPadBottom(true);
        this.setLayout(fgl);
        this.setBorder(PanGuiUtils.STD_BORDER);
        this.add((Component)projNameBox, new FGConstraint(0, 0));
        this.add((Component)projCenterBox, new FGConstraint(0, 1));
        this.add((Component)this.projParamBoxes_[0], new FGConstraint(0, 2));
        this.add((Component)this.projParamBoxes_[1], new FGConstraint(0, 3));
        this.add((Component)gSpacingBox, new FGConstraint(1, 0));
        this.add((Component)gOffsetBox, new FGConstraint(1, 1));
        this.add((Component)gStyleBox, new FGConstraint(1, 2));
        this.add((Component)gLabelsBox, new FGConstraint(1, 3));
        this.add((Component)borderBox, new FGConstraint(1, 4));
        centerLabel.setPreferredSize(projLabel.getPreferredSize());
        centerLabel.setMaximumSize(centerLabel.getPreferredSize());
        GuiUtils.matchLabelWidths(gSpacingLabel, gColorLabel, gStyleLabel, gLabelsLabel);
    }

    @Override
    public void refresh() {
        LOGGER.trace("");
        super.refresh();
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        LOGGER.trace("{}", (Object)this.refreshing_);
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        AbstractProjection proj = projmeta.getProjection();
        String projname = proj.getName();
        this.projCombo_.setSelectedItem(this.pmeta_.getString("lonlat.proj.name"));
        boolean sameProj = projname.equals(this.lastproj_);
        this.lastproj_ = projname;
        if (sameProj) {
            this.refreshParamFields();
        } else {
            this.changeProjection();
        }
        this.gridLabelStepCombo_.setEnabled(proj.canLabelGrid());
        this.gridLabelSizeCombo_.setEnabled(proj.canLabelGrid());
        float newLonSpacing = this.pmeta_.getFloat("grid.spacing.lon");
        float newLatSpacing = this.pmeta_.getFloat("grid.spacing.lat");
        if (newLonSpacing != this.gridLonSpacingCombo_.getSpacing()) {
            this.gridLonSpacingCombo_.setSpacing(this.pmeta_.getFloat("grid.spacing.lon"));
        }
        if (newLatSpacing != this.gridLatSpacingCombo_.getSpacing()) {
            this.gridLatSpacingCombo_.setSpacing(this.pmeta_.getFloat("grid.spacing.lat"));
        }
        this.linkedSpacing_ = this.gridLonSpacingCombo_.getSpacing() == this.gridLatSpacingCombo_.getSpacing();
        this.linkBtn_.setLinked(this.linkedSpacing_);
        this.gridStyleCombo_.setSelectedItem(this.pmeta_.getString("grid.style"));
        this.gridColorCombo_.setSelectedColor(this.pmeta_.getColor("grid.color"));
        this.gridWeightSpinner_.setValue(this.pmeta_.getInt("grid.weight"));
        this.gridLabelStepCombo_.setStep(this.pmeta_.getInt("grid.label.step"));
        this.gridLabelSizeCombo_.setValue(this.pmeta_.getFloat("grid.label.size"));
        this.refreshZoomEnabling();
        this.refreshing_ = false;
        this.repaint();
    }

    @Override
    public final void refreshZoomEnabling() {
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        this.pmeta_.getAction("zoom-plot-in").setEnabled(projmeta.canZoomIn());
        this.pmeta_.getAction("zoom-plot-out").setEnabled(projmeta.canZoomOut());
    }

    private synchronized void refreshParamFields() {
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        this.refreshing_ = true;
        AbstractProjection proj = projmeta.getProjection();
        int pcount = proj.getExtraParamCount();
        for (int i = 0; i < pcount; ++i) {
            Object value = projmeta.getXParamValue(i);
            if (value == null || value instanceof String && ((String)value).isEmpty()) continue;
            ProjParamComponent xcomp = this.projParamComponents_[i];
            try {
                if (value instanceof String) {
                    xcomp.setValue((String)value);
                    continue;
                }
                if (xcomp instanceof ProjDoubleComponent && value instanceof Double) {
                    ((ProjDoubleComponent)xcomp).setValue((Double)value);
                    continue;
                }
                if (xcomp instanceof ProjIntegerComponent && value instanceof Integer) {
                    ProjIntegerComponent pic = (ProjIntegerComponent)xcomp;
                    pic.setValue((Integer)value);
                    continue;
                }
                if (xcomp instanceof ProjBooleanComponent && value instanceof Boolean) {
                    ((ProjBooleanComponent)xcomp).setSelected((Boolean)value);
                    continue;
                }
                if (xcomp instanceof ProjListComponent) {
                    ((ProjListComponent)xcomp).setValue(value.toString());
                    continue;
                }
                LOGGER.debug("xcomp {} {} does not match known type.", (Object)i, (Object)xcomp.getClass());
                continue;
            }
            catch (Exception exc) {
                LOGGER.debug("xcomp {} exc: {}", (Object)i, (Object)exc.toString());
            }
        }
        this.refreshing_ = false;
    }

    private void changeProjection() {
        int i;
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        AbstractProjection proj = projmeta.getProjection();
        if (proj.hasProperty(0x1000000)) {
            this.copLonTF_.setEnabled(proj.isRecenterableLon());
            this.copLatTF_.setEnabled(false);
        } else {
            this.copLonTF_.setEnabled(proj.isRecenterableLon());
            this.copLatTF_.setEnabled(proj.isRecenterableLat());
        }
        this.projParamBoxes_[0].removeAll();
        this.projParamBoxes_[1].removeAll();
        int pcount = proj.getExtraParamCount();
        int pRow = 0;
        int pRowItem = 0;
        for (i = 0; i < this.projParamComponents_.length; ++i) {
            this.projParamComponents_[i] = null;
        }
        for (i = 0; i < pcount; ++i) {
            ProjParamComponent xcomp;
            if (pRowItem > 0) {
                this.projParamBoxes_[pRow].add(PanLabel.small(", "));
            }
            int pid = i;
            this.projParamComponents_[i] = xcomp = proj.getParamComponent(i);
            PanGuiUtils.setSizeSmall(xcomp);
            xcomp.setMaximumSize(xcomp.getPreferredSize());
            this.projParamBoxes_[pRow].add(xcomp);
            if (xcomp instanceof ProjListComponent) {
                ++pRow;
                pRowItem = 0;
            } else if (++pRowItem > 2) {
                ++pRow;
                pRowItem = 0;
            }
            xcomp.addChangeListener(e -> this.handleExtraParam(xcomp, pid));
        }
        this.refreshParamFields();
        if (proj instanceof EquirectangularRegional) {
            if (this.fixEqRegBtn_ == null) {
                this.fixEqRegBtn_ = PanButton.small("Fix Proportions");
                this.fixEqRegBtn_.addActionListener(e -> this.fixEqRegional());
            }
            this.projParamBoxes_[1].add(this.fixEqRegBtn_);
        } else if (proj.hasProperty(16)) {
            if (this.fixConicBtn_ == null) {
                this.fixConicBtn_ = PanButton.small("Autoset Parallels");
                this.fixConicBtn_.addActionListener(e -> this.fixConic());
            }
            this.projParamBoxes_[1].add(this.fixConicBtn_);
        }
        this.projParamBoxes_[0].add(Box.createHorizontalGlue());
        this.projParamBoxes_[1].add(Box.createHorizontalGlue());
        PanPlotFrame pf = this.getParentFrame();
        if (pf != null) {
            this.projParamBoxes_[0].invalidate();
            this.projParamBoxes_[1].invalidate();
            this.invalidate();
            pf.validate();
            this.repaint();
        }
    }

    private void attachListeners() {
        this.projCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            if (this.projCombo_.isRefreshing()) {
                return;
            }
            String name = this.projCombo_.getSelectedItem().toString();
            this.pmeta_.setString("lonlat.proj.name", name);
            this.scheduleRefreshTask();
        });
        FocusAdapter lonlatFL = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PanLonLatMapControls.this.handleCenterTF();
            }
        };
        this.copLonTF_.addFocusListener(lonlatFL);
        this.copLatTF_.addFocusListener(lonlatFL);
        this.copLonTF_.addActionListener(e -> this.handleCenterTF());
        this.copLatTF_.addActionListener(e -> this.handleCenterTF());
        this.gridLonSpacingCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            PanLonLatMapControls panLonLatMapControls = this;
            synchronized (panLonLatMapControls) {
                float spacing = this.gridLonSpacingCombo_.getSpacing();
                LOGGER.trace("spacing {}", (Object)Float.valueOf(spacing));
                if (this.linkedSpacing_) {
                    this.pmeta_.setGroup({"grid.spacing.lon", Float.valueOf(spacing)}, {"grid.spacing.lat", Float.valueOf(spacing)});
                } else {
                    this.pmeta_.setFloat("grid.spacing.lon", spacing);
                }
            }
        });
        this.gridLatSpacingCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            PanLonLatMapControls panLonLatMapControls = this;
            synchronized (panLonLatMapControls) {
                float spacing = this.gridLatSpacingCombo_.getSpacing();
                LOGGER.trace("spacing {}", (Object)Float.valueOf(spacing));
                this.pmeta_.setFloat("grid.spacing.lat", spacing);
                if (this.linkedSpacing_) {
                    this.pmeta_.setGroup({"grid.spacing.lon", Float.valueOf(spacing)}, {"grid.spacing.lat", Float.valueOf(spacing)});
                } else {
                    this.pmeta_.setFloat("grid.spacing.lat", spacing);
                }
            }
        });
        this.linkBtn_.addActionListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.linkedSpacing_ = !this.linkedSpacing_;
            this.linkBtn_.setLinked(this.linkedSpacing_);
            if (this.linkedSpacing_) {
                float spacing = this.gridLonSpacingCombo_.getSpacing();
                this.gridLatSpacingCombo_.setSpacing(spacing);
            }
        });
        this.gridLatOffsetCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.pmeta_.setBoolean("grid.offset.lat", e.getStateChange() == 1);
        });
        this.gridColorCombo_.addItemListener(e -> {
            Color cold;
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            Color cnew = this.gridColorCombo_.getSelectedColor();
            if (!cnew.equals(cold = this.pmeta_.getColor("grid.color"))) {
                this.pmeta_.setColor("grid.color", cnew);
            }
        });
        this.gridWeightSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.pmeta_.setInt("grid.weight", this.gridWeightSpinner_.getIntValue());
        });
        this.gridStyleCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.put("grid.style", (Object)this.gridStyleCombo_.getStringValue());
        });
        this.gridLabelStepCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.pmeta_.setInt("grid.label.step", this.gridLabelStepCombo_.getStep());
        });
        this.gridLabelSizeCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            float value = this.gridLabelSizeCombo_.getValue();
            this.pmeta_.setFloat("grid.label.size", value);
        });
        this.bWeightSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.pmeta_.setInt("lonlat.border.weight", this.bWeightSpinner_.getIntValue());
        });
    }

    private boolean isZoomable() {
        return this.pmeta_.getProjectionMeta().isZoomable();
    }

    @Override
    public void recenter(double lon, double lat) {
        double newlon;
        if (lat > 90.0 || lat < -90.0) {
            throw new IllegalArgumentException("Invalid latitude.");
        }
        double newlat = lat;
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        AbstractProjection proj = projmeta.getProjection();
        if (proj instanceof EquirectangularRegional) {
            double hhh = 0.0;
            try {
                Object oo = projmeta.getXParamValue(1);
                if (oo instanceof Double) {
                    hhh = (Double)oo;
                } else if (oo instanceof String) {
                    hhh = StringUtils.parseDouble((String)oo);
                }
            }
            catch (Exception exc) {
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                return;
            }
            double halfH = 0.5 * hhh;
            if (newlat + halfH > 90.0) {
                newlat = 90.0 - halfH;
            } else if (newlat - halfH < -90.0) {
                newlat = -90.0 + halfH;
            }
        }
        for (newlon = lon; newlon > 180.0; newlon -= 360.0) {
        }
        while (newlon < -180.0) {
            newlon += 360.0;
        }
        double oldlon = this.getCopLon();
        double oldlat = this.getCopLat();
        if (this.copLonTF_.isEnabled()) {
            if (Double.isNaN(oldlon)) {
                oldlon = -9999.0;
            }
            if (newlon != oldlon) {
                this.copLonTF_.setText(PFORMAT_7G.sprintfx(newlon));
            }
        } else {
            newlon = oldlon;
        }
        if (this.copLatTF_.isEnabled()) {
            if (Double.isNaN(oldlat)) {
                oldlat = -9999.0;
            }
            if (newlat != oldlat) {
                this.copLatTF_.setText(PFORMAT_7G.sprintfx(newlat));
            }
        } else {
            newlat = oldlat;
        }
        if (this.pmeta_ != null) {
            this.pmeta_.setGroup({"lonlat.proj.lon0", newlon}, {"lonlat.proj.lat0", newlat});
        }
    }

    private void handleCenterTF() {
        PanProjectionMeta projmeta;
        AbstractProjection proj;
        double lat;
        if (this.refreshing_) {
            return;
        }
        if (this.copLonTF_ == null || this.copLatTF_ == null || this.pmeta_ == null) {
            return;
        }
        double lon = this.getCopLon();
        if (Double.isNaN(lon)) {
            lon = this.pmeta_.getDouble("lonlat.proj.lon0");
            this.copLonTF_.setText(PFORMAT_7G.sprintfx(lon));
        }
        boolean shifted = false;
        while (lon > 180.0) {
            lon -= 360.0;
            shifted = true;
        }
        while (lon < -180.0) {
            lon += 360.0;
            shifted = true;
        }
        if (shifted) {
            this.copLonTF_.setText(PFORMAT_7G.sprintfx(lon));
        }
        if ((lat = this.getCopLat()) < -90.0 || lat > 90.0) {
            lat = MathUtils.constrain(-90.0, 90.0, lat);
            this.copLatTF_.setText(PFORMAT_7G.sprintfx(lat));
        }
        if ((proj = (projmeta = this.pmeta_.getProjectionMeta()).getProjection()) instanceof EquirectangularRegional) {
            double hhh = 0.0;
            try {
                Object oo = projmeta.getXParamValue(1);
                if (oo instanceof Double) {
                    hhh = (Double)oo;
                } else if (oo instanceof String) {
                    hhh = StringUtils.parseDouble((String)oo);
                }
            }
            catch (Exception exc) {
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                return;
            }
            double halfH = 0.5 * hhh;
            if (lat + halfH > 90.0) {
                lat = 90.0 - halfH;
                this.copLatTF_.setText(PFORMAT_7G.sprintfx(lat));
            } else if (lat - halfH < -90.0) {
                lat = -90.0 + halfH;
                this.copLatTF_.setText(PFORMAT_7G.sprintfx(lat));
            }
        }
        if (this.pmeta_ != null) {
            this.pmeta_.setGroup({"lonlat.proj.lon0", lon}, {"lonlat.proj.lat0", lat});
        }
    }

    @Override
    public void zoomIn() {
        this.zoom(1.5);
    }

    @Override
    public void zoomOut() {
        this.zoom(0.6666666666666666);
    }

    @Override
    public void zoomIn(double lon, double lat) {
        this.zoom(1.5, lon, lat);
    }

    @Override
    public void zoomOut(double lon, double lat) {
        this.zoom(0.6666666666666666, lon, lat);
    }

    @Override
    public void zoom(double factor) {
        String pname;
        if (!this.isZoomable()) {
            return;
        }
        double lon = 0.0;
        double lat = 0.0;
        if (this.copLonTF_.isEnabled() && Double.isNaN(lon = this.getCopLon())) {
            LOGGER.warn("Using default longitude 0.");
            lon = 0.0;
        }
        if ((pname = this.pmeta_.getString("lonlat.proj.name")).equals("Equirectangular")) {
            this.copLatTF_.setText(PFORMAT_7G.sprintfx(0.0));
            lat = 0.0;
        } else if (this.copLatTF_.isEnabled() && Double.isNaN(lat = this.getCopLat())) {
            LOGGER.warn("Using default latitude 0.");
            lat = 0.0;
        }
        this.zoom(factor, lon, lat);
    }

    @Override
    public void zoom(double factor, double lon, double lat) {
        block45: {
            AbstractProjection proj;
            double oldLat;
            if (!this.isZoomable()) {
                return;
            }
            PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
            if (!projmeta.isZoomable()) {
                return;
            }
            double oldLon = this.getCopLon();
            if (Double.isNaN(oldLon)) {
                oldLon = -9999.0;
            }
            if (lon != oldLon) {
                this.copLonTF_.setText(PFORMAT_7G.sprintfx(lon));
            }
            if (Double.isNaN(oldLat = this.getCopLat())) {
                oldLat = -9999.0;
            }
            if (lat != oldLat) {
                this.copLatTF_.setText(PFORMAT_7G.sprintfx(lat));
            }
            if ((proj = projmeta.getProjection()) instanceof Equirectangular || proj instanceof EquirectangularRegional) {
                double w = 360.0;
                double h = 180.0;
                if (proj instanceof EquirectangularRegional) {
                    try {
                        Object woo = projmeta.getXParamValue(0);
                        Object hoo = projmeta.getXParamValue(1);
                        if (woo == null) {
                            LOGGER.debug("Width object is null");
                        } else if (woo instanceof Double) {
                            w = (Double)woo;
                        } else if (woo instanceof String) {
                            w = StringUtils.parseDouble((String)woo);
                        } else {
                            LOGGER.debug("No match for width object class {}", (Object)woo.getClass());
                        }
                        if (hoo == null) {
                            LOGGER.debug("Height object is null");
                        } else if (hoo instanceof Double) {
                            h = (Double)hoo;
                        } else if (hoo instanceof String) {
                            h = StringUtils.parseDouble((String)hoo);
                        } else {
                            LOGGER.debug("No match for height object class {}", (Object)hoo.getClass());
                        }
                    }
                    catch (Exception exc) {
                        if (LOGGER.isTraceEnabled()) {
                            exc.printStackTrace();
                        }
                        return;
                    }
                }
                w = Math.min(w / factor, 360.0);
                h = Math.min(h / factor, 180.0);
                if (w == 360.0 && h == 180.0) {
                    this.projCombo_.setSelectedItem("Equirectangular");
                    this.pmeta_.setGroup({"lonlat.proj.name", "Equirectangular"}, {"lonlat.proj.lon0", lon}, {"lonlat.proj.lat0", lat});
                } else {
                    double newlat = lat;
                    double halfH = 0.5 * h;
                    if (lat + halfH > 90.0) {
                        newlat = 90.0 - halfH;
                        this.copLatTF_.setText(PFORMAT_7G.sprintfx(newlat));
                    } else if (lat - halfH < -90.0) {
                        newlat = -90.0 + halfH;
                        this.copLatTF_.setText(PFORMAT_7G.sprintfx(newlat));
                    }
                    this.projCombo_.setSelectedItem("Equirectangular Regional");
                    this.pmeta_.setGroup({"lonlat.proj.name", "Equirectangular Regional"}, {"lonlat.proj.lon0", lon}, {"lonlat.proj.lat0", newlat}, {"lonlat.proj.xparam.1", w}, {"lonlat.proj.xparam.2", h});
                }
            } else {
                if (proj instanceof EquirectangularOblique) {
                    try {
                        ProjDoubleParameter hp = (ProjDoubleParameter)proj.getParameter(0);
                        double hh = hp.getValue();
                        hh /= factor;
                        hh = Math.min(hh, hp.getMaximum());
                        hh = Math.max(hh, hp.getMinimum());
                        if (this.pmeta_ != null) {
                            this.pmeta_.setGroup({"lonlat.proj.lon0", lon}, {"lonlat.proj.lat0", lat}, {"lonlat.proj.xparam.1", hh});
                        }
                        break block45;
                    }
                    catch (Exception exc) {
                        if (LOGGER.isTraceEnabled()) {
                            exc.printStackTrace();
                        }
                        break block45;
                    }
                }
                if (proj instanceof AzimuthalProjection) {
                    try {
                        ProjDoubleParameter cap = ((AzimuthalProjection)proj).getClipAngleParameter();
                        if (cap == null) break block45;
                        String paramKey = "lonlat.proj.xparam.1";
                        if (this.projParamComponents_[1] != null && cap == this.projParamComponents_[1].getParameter()) {
                            paramKey = "lonlat.proj.xparam.2";
                        }
                        if (this.projParamComponents_[2] != null && cap == this.projParamComponents_[2].getParameter()) {
                            paramKey = "lonlat.proj.xparam.3";
                        }
                        double r = cap.getValue();
                        r /= factor;
                        r = Math.min(r, cap.getMaximum());
                        r = Math.max(r, cap.getMinimum());
                        if (this.pmeta_ != null) {
                            this.pmeta_.setGroup({"lonlat.proj.lon0", lon}, {"lonlat.proj.lat0", lat}, {paramKey, r});
                        }
                        break block45;
                    }
                    catch (Exception exc) {
                        if (LOGGER.isTraceEnabled()) {
                            exc.printStackTrace();
                        }
                        break block45;
                    }
                }
                if (proj.hasProperty(16)) {
                    try {
                        ProjDoubleParameter hp = ((ConicProjection)proj).getHeightParameter();
                        double hh = hp.getValue();
                        hh /= factor;
                        hh = Math.min(hh, hp.getMaximum());
                        hh = Math.max(hh, hp.getMinimum());
                        if (this.pmeta_ != null) {
                            this.pmeta_.setGroup({"lonlat.proj.lon0", lon}, {"lonlat.proj.lat0", lat}, {"lonlat.proj.xparam.3", hh});
                        }
                    }
                    catch (Exception exc) {
                        if (!LOGGER.isTraceEnabled()) break block45;
                        exc.printStackTrace();
                    }
                }
            }
        }
        this.refresh();
    }

    @Override
    public void dragZoom(double clon, double clat, double llon, double tlat, double rlon, double blat) {
        double oldLat;
        if (!this.isZoomable()) {
            return;
        }
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        AbstractProjection proj = projmeta.getProjection();
        double oldLon = this.getCopLon();
        if (Double.isNaN(oldLon)) {
            oldLon = -9999.0;
        }
        if (clon != oldLon) {
            this.copLonTF_.setText(PFORMAT_7G.sprintfx(clon));
        }
        if (Double.isNaN(oldLat = this.getCopLat())) {
            oldLat = -9999.0;
        }
        if (clat != oldLat) {
            this.copLatTF_.setText(PFORMAT_7G.sprintfx(clat));
        }
        if (proj instanceof Equirectangular || proj instanceof EquirectangularRegional) {
            double w = Math.min(rlon - llon, 360.0);
            double h = Math.min(tlat - blat, 180.0);
            if (proj instanceof Equirectangular) {
                this.pmeta_.setGroup({"lonlat.proj.name", "Equirectangular Regional"}, {"lonlat.proj.lon0", clon}, {"lonlat.proj.lat0", clat}, {"lonlat.proj.xparam.1", w}, {"lonlat.proj.xparam.2", h});
                this.projCombo_.setSelectedItem("Equirectangular Regional");
                this.copLatTF_.setEnabled(true);
            } else {
                this.pmeta_.setGroup({"lonlat.proj.lon0", clon}, {"lonlat.proj.lat0", clat}, {"lonlat.proj.xparam.1", w}, {"lonlat.proj.xparam.2", h});
            }
        } else if (proj instanceof AzimuthalProjection) {
            ProjDoubleParameter cap = ((AzimuthalProjection)proj).getClipAngleParameter();
            double r = Math.max(Math.abs(tlat - clat), Math.abs(blat - clat));
            r = Math.min(r, cap.getMaximum());
            r = Math.max(r, cap.getMinimum());
            this.pmeta_.setGroup({"lonlat.proj.lon0", clon}, {"lonlat.proj.lat0", clat}, {"lonlat.proj.xparam.1", r});
        } else {
            LOGGER.warn("Tried to set edges on non-zoomable projection.");
        }
    }

    @Override
    public void resetGridBounds() {
    }

    private void setRegionalFields(double w, double h) {
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        AbstractProjection proj = projmeta.getProjection();
        if (proj instanceof EquirectangularRegional) {
            ProjDoubleComponent wfield = (ProjDoubleComponent)this.projParamComponents_[0];
            ProjDoubleComponent hfield = (ProjDoubleComponent)this.projParamComponents_[1];
            wfield.setValue(w);
            hfield.setValue(h);
            if (this.pmeta_ != null) {
                this.pmeta_.setGroup({"lonlat.proj.xparam.1", w}, {"lonlat.proj.xparam.2", h});
            }
        } else {
            LOGGER.warn("Tried to set regional width and height on non-ER projection.");
        }
    }

    private void handleExtraParam(ProjParamComponent pf, int pid) {
        if (pf == null || !pf.isVisible()) {
            return;
        }
        if (this.refreshing_) {
            return;
        }
        Object pvalue = pf.getValue();
        LOGGER.trace("{}, {}", (Object)pid, pvalue);
        try {
            String pkey = "lonlat.proj.xparam." + (pid + 1);
            this.pmeta_.set(pkey, pvalue);
            PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
            AbstractProjection proj = projmeta.getProjection();
            if (proj.hasProperty(0x1000000)) {
                this.copLonTF_.setEnabled(proj.isRecenterableLon());
                this.copLonTF_.setText(PFORMAT_7G.sprintfx(proj.getCenter().getLon()));
            }
        }
        catch (Exception exc) {
            LOGGER.warn("Could not parse parameter field value: []", (Object)pf.toString());
        }
    }

    private void fixEqRegional() {
        double lat;
        try {
            lat = StringUtils.parseDouble(this.copLatTF_.getText());
        }
        catch (Exception exc) {
            return;
        }
        if (lat > 85.0) {
            lat = 85.0;
        } else if (lat < -85.0) {
            lat = -85.0;
        }
        double coslat = Math.cos(Math.toRadians(lat));
        ProjDoubleComponent hfield = (ProjDoubleComponent)this.projParamComponents_[1];
        double h1 = (Double)hfield.getValue();
        int wfactor = this.pmeta_.getInt("size.width");
        int hfactor = this.pmeta_.getInt("size.height");
        double whratio = (double)wfactor / (double)hfactor;
        double w2 = h1 * whratio / coslat;
        double h2 = h1;
        if (w2 > 360.0) {
            w2 = 360.0;
            h2 = w2 * coslat / whratio;
        }
        if (h2 > 180.0) {
            h2 = 180.0;
        }
        this.setRegionalFields(w2, h2);
    }

    private void fixConic() {
        double lat;
        try {
            lat = StringUtils.parseDouble(this.copLatTF_.getText());
        }
        catch (Exception exc) {
            return;
        }
        ProjDoubleComponent p1field = (ProjDoubleComponent)this.projParamComponents_[0];
        ProjDoubleComponent p2field = (ProjDoubleComponent)this.projParamComponents_[1];
        ProjDoubleComponent hfield = (ProjDoubleComponent)this.projParamComponents_[2];
        double h = (Double)hfield.getValue();
        if (h < 0.0) {
            h = 1.0;
        }
        double p1 = lat + 0.3 * h;
        double p2 = lat - 0.3 * h;
        if (p1 > 90.0) {
            p1 = 90.0;
        }
        if (p2 < -90.0) {
            p2 = -90.0;
        }
        p1field.setValue(p1);
        p2field.setValue(p2);
        if (this.pmeta_ != null) {
            this.pmeta_.setGroup({"lonlat.proj.xparam.1", p1}, {"lonlat.proj.xparam.2", p2});
        }
    }

    private double getCopLon() {
        String s = this.copLonTF_.getText();
        try {
            return StringUtils.parseDouble(s);
        }
        catch (Exception exc) {
            LOGGER.warn("Could not parse lon TF '{}'", (Object)s);
            return Double.NaN;
        }
    }

    private double getCopLat() {
        String s = this.copLatTF_.getText();
        try {
            return StringUtils.parseDouble(s);
        }
        catch (Exception exc) {
            LOGGER.warn("Could not parse lat TF '{}')", (Object)s);
            return Double.NaN;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        PanLonLatMapControls panLonLatMapControls = this;
        synchronized (panLonLatMapControls) {
            this.projParamBoxes_[0].removeAll();
            this.projParamBoxes_[1].removeAll();
            super.flush();
        }
    }

    @Override
    public void plotPropertyChanged(PlotPropertyEvent e) {
        boolean changeAll;
        if (e == null) {
            return;
        }
        String pname = e.getMessage();
        boolean bl = changeAll = pname == null || "all".equals(pname);
        if (changeAll || pname.contains("grid.style")) {
            this.gridStyleCombo_.setSelectedItem(this.pmeta_.getString("grid.style"));
        }
        if (changeAll || pname.contains("grid.weight")) {
            this.gridWeightSpinner_.setValue(this.pmeta_.getInt("grid.weight"));
        }
        this.repaint();
    }
}

